/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.io;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleUtil {
    @Nullable
    public static String readBundleFullName() {
        try {
            Path path = Paths.get("", new String[0]).toAbsolutePath();
            String fullName = path.getParent().getFileName().toString();
            if (fullName.length() < 3) {
                return null;
            }
            return fullName;
        }
        catch (InvalidPathException e) {
            System.err.println(new Date() + ": BundleUtil: Error reading bundle name");
            return null;
        }
    }

    @NotNull
    public static String readBundleFullNameNotNull() {
        String bundle = BundleUtil.readBundleFullName();
        bundle = bundle == null ? "unknown bundle" : bundle;
        return bundle;
    }

    public static String getBundleTarget() {
        return BundleUtil.getBundleTarget(BundleUtil.readBundleFullName());
    }

    public static String getBundleTarget(String s) {
        if (s == null) {
            return null;
        }
        int lastDot = s.lastIndexOf(46);
        if (lastDot == -1) {
            throw new IllegalStateException("Dot expected somewhere in [" + s + "]");
        }
        return s.substring(lastDot + 1);
    }
}

