/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu.commands;

import com.rusefi.dfu.DfuCommmand;
import com.rusefi.dfu.DfuConnection;
import com.rusefi.dfu.DfuConnectionUtil;
import com.rusefi.dfu.DfuLogic;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class DfuCommandGetStatus {
    private static final int PACKET_SIZE = 6;
    private static final AtomicInteger STATUS_COUNTER = new AtomicInteger();

    public static DeviceStatus read(DfuLogic.Logger logger, DfuConnection connection) {
        ByteBuffer buffer = connection.allocateBuffer(6);
        int count = connection.receiveData(DfuCommmand.GETSTATUS, (short)0, buffer);
        if (count != 6) {
            return new DeviceStatus(null, State.DFU_ERROR);
        }
        buffer.rewind();
        Status status = Status.valueOf(buffer.get());
        int timeout = buffer.get();
        timeout |= buffer.get() << 8;
        byte stateCode = buffer.get();
        DfuConnectionUtil.sleep(logger, timeout |= buffer.get() << 8);
        State state = State.valueOf(stateCode);
        logger.info(STATUS_COUNTER.incrementAndGet() + " GETSTATUS " + (Object)((Object)status) + " timeout=" + timeout + " " + (Object)((Object)state));
        return new DeviceStatus(status, state);
    }

    public static class DeviceStatus {
        private final Status status;
        private final State state;

        public DeviceStatus(Status status, State state) {
            this.status = status;
            this.state = state;
        }

        public Status getStatus() {
            return this.status;
        }

        public State getState() {
            return this.state;
        }

        public String toString() {
            return "DeviceStatus{status=" + (Object)((Object)this.status) + ", state=" + (Object)((Object)this.state) + '}';
        }
    }

    public static enum State {
        APP_IDLE(0),
        APP_DETACH(1),
        DFU_IDLE(2),
        DFU_DOWNLOAD_SYNC(3),
        DFU_DOWNLOAD_BUSY(4),
        DFU_DOWNLOAD_IDLE(5),
        DFU_MANIFEST_SYNC(6),
        DFU_MANIFEST(7),
        DFU_MANIFEST_WAIT_RESET(8),
        DFU_UPLOAD_IDLE(9),
        DFU_ERROR(10);

        private final byte value;

        private State(int value) {
            this.value = (byte)value;
        }

        public static State valueOf(byte value) {
            for (State state : State.values()) {
                if (state.value != value) continue;
                return state;
            }
            return null;
        }
    }

    public static enum Status {
        OK(0),
        ERROR_TARGET(1),
        ERROR_FILE(2),
        ERROR_WRITE(3),
        ERROR_ERASE(4),
        ERROR_CHECK_ERASED(5),
        ERROR_PROG(6),
        ERROR_VERIFY(7),
        ERROR_ADDRESS(8),
        ERROR_NOTDONE(9),
        ERROR_FIRMWARE(10),
        ERROR_VENDOR(11),
        ERROR_USBR(12),
        ERROR_POR(13),
        ERROR_UNKNOWN(14),
        ERROR_STALLEDPKT(15);

        private final byte value;

        private Status(int value) {
            this.value = (byte)value;
        }

        public static Status valueOf(byte value) {
            for (Status s : Status.values()) {
                if (s.value != value) continue;
                return s;
            }
            return null;
        }
    }
}

