/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.DataPoint;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.SmoothingFunction;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class SparkLine
extends JComponent {
    private static final Util UTIL = Util.INSTANCE;
    private static final DecimalFormat DF = new DecimalFormat("0.00");
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 48);
    private boolean recreateImages = true;
    private final LinkedList<DataPoint> DATA_LIST;
    private List<Double> sortedList = new ArrayList<Double>(3600);
    private List<DataPoint> trashList;
    private List<Point2D> pointList;
    private final Color DISABLED_COLOR;
    private double start;
    private double stop;
    private double lo;
    private double hi;
    private int loIndex;
    private int hiIndex;
    private double offset;
    private double scaleY;
    private double rangeY;
    private boolean filled;
    private SmoothingFunction smoothFunction;
    private boolean smoothing;
    private float lineWidth;
    private LcdColor sparkLineColor;
    private Paint customSparkLineColor;
    private Color lineColor;
    private ColorDef areaFill;
    private Color customAreaFillTop;
    private Color customAreaFillBottom;
    private boolean lineShadowVisible;
    private boolean startStopIndicatorVisible;
    private boolean hiLoIndicatorVisible;
    private boolean backgroundVisible;
    private boolean infoLabelsVisible;
    private final Font INFO_LABEL_FONT;
    private BufferedImage sparkLineBackgroundImage;
    private BufferedImage startIndicatorImage;
    private BufferedImage stopIndicatorImage;
    private BufferedImage loIndicatorImage;
    private BufferedImage hiIndicatorImage;
    private BufferedImage sparkLineImage;
    private Shape disabledShape;
    private final RoundRectangle2D CLIP_SHAPE;
    private long timeFrame;
    private double pixelResolution;
    private double baseLineY;
    private boolean baseLineVisible;
    private boolean averageVisible;
    private boolean normalAreaVisible;
    private final Line2D AVERAGE_LINE;
    private final Rectangle2D NORMAL_AREA;
    private Color averageColor;
    private Color normalAreaColor;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Container container = SparkLine.this.getParent();
            if (SparkLine.this.getWidth() < SparkLine.this.getMinimumSize().width && SparkLine.this.getHeight() < SparkLine.this.getMinimumSize().height) {
                if (container != null && SparkLine.this.getParent().getLayout() == null) {
                    SparkLine.this.setSize(SparkLine.this.getMinimumSize());
                } else {
                    SparkLine.this.setPreferredSize(SparkLine.this.getMinimumSize());
                }
            }
            if (container != null && SparkLine.this.getParent().getLayout() == null) {
                SparkLine.this.setSize(SparkLine.this.getWidth(), SparkLine.this.getHeight());
            } else {
                SparkLine.this.setPreferredSize(new Dimension(SparkLine.this.getWidth(), SparkLine.this.getHeight()));
            }
            SparkLine.this.calcInnerBounds();
            SparkLine.this.recreateAllImages();
            SparkLine.this.init(((SparkLine)SparkLine.this).INNER_BOUNDS.width, ((SparkLine)SparkLine.this).INNER_BOUNDS.height);
        }
    };

    public SparkLine() {
        this.DATA_LIST = new LinkedList();
        this.trashList = new ArrayList<DataPoint>(512);
        this.pointList = new ArrayList<Point2D>(this.INNER_BOUNDS.width);
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.scaleY = 1.0;
        this.rangeY = 0.0;
        this.filled = false;
        this.smoothFunction = SmoothingFunction.COSINUS;
        this.smoothing = false;
        this.lineWidth = 1.0f;
        this.sparkLineColor = LcdColor.WHITE_LCD;
        this.customSparkLineColor = Color.WHITE;
        this.lineColor = this.sparkLineColor.TEXT_COLOR;
        this.areaFill = ColorDef.RED;
        this.customAreaFillTop = new Color(1.0f, 1.0f, 1.0f, 0.4f);
        this.customAreaFillBottom = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.lineShadowVisible = false;
        this.startStopIndicatorVisible = true;
        this.hiLoIndicatorVisible = false;
        this.backgroundVisible = true;
        this.infoLabelsVisible = false;
        this.INFO_LABEL_FONT = new Font("Verdana", 0, 12);
        this.CLIP_SHAPE = new RoundRectangle2D.Double();
        this.timeFrame = 3600000L;
        this.baseLineVisible = false;
        this.averageVisible = false;
        this.normalAreaVisible = false;
        this.AVERAGE_LINE = new Line2D.Double(this.INNER_BOUNDS.x, 0.0, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, 0.0);
        this.NORMAL_AREA = new Rectangle2D.Double(this.INNER_BOUNDS.x, 0.0, this.INNER_BOUNDS.width, 0.0);
        this.averageColor = new Color(102, 216, 29);
        this.normalAreaColor = new Color(216, 29, 68, 25);
        this.createInitialImages();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.repaint(this.INNER_BOUNDS);
    }

    private void init(int n, int n2) {
        double d;
        if (n <= 1 || n2 <= 1) {
            return;
        }
        double d2 = d = n > n2 ? (double)n2 * 0.095 : (double)n * 0.095;
        if (this.recreateImages) {
            if (this.sparkLineBackgroundImage != null) {
                this.sparkLineBackgroundImage.flush();
            }
            this.sparkLineBackgroundImage = this.create_SPARK_LINE_BACKGROUND_Image(n, n2);
            this.CLIP_SHAPE.setRoundRect(1.0, 1.0, n - 2, n2 - 2, d - 1.0, d - 1.0);
            if (this.startIndicatorImage != null) {
                this.startIndicatorImage.flush();
            }
            this.startIndicatorImage = this.create_START_STOP_INDICATOR_Image(n);
            if (this.stopIndicatorImage != null) {
                this.stopIndicatorImage.flush();
            }
            this.stopIndicatorImage = this.create_START_STOP_INDICATOR_Image(n);
            if (this.loIndicatorImage != null) {
                this.loIndicatorImage.flush();
            }
            this.loIndicatorImage = this.create_LO_INDICATOR_Image(n);
            if (this.hiIndicatorImage != null) {
                this.hiIndicatorImage.flush();
            }
            this.hiIndicatorImage = this.create_HI_INDICATOR_Image(n);
        }
        this.recreateImages = false;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, n, n2, d, d);
        this.pixelResolution = this.INNER_BOUNDS.getWidth() / (double)this.timeFrame;
        this.offset = (int)(0.06 * (double)n) < 8 ? 8.0 : (double)((int)(0.06 * (double)n));
        this.baseLineY = (double)(this.INNER_BOUNDS.y + this.INNER_BOUNDS.height) - ((0.0 - this.lo) * (1.0 / this.scaleY) + this.offset);
        if (!this.DATA_LIST.isEmpty()) {
            this.calculate(n, n2);
        }
        if (this.sparkLineImage != null) {
            this.sparkLineImage.flush();
        }
        this.sparkLineImage = this.createSparkLineImage(n, n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        if (this.backgroundVisible) {
            graphics2D.drawImage((Image)this.sparkLineBackgroundImage, 0, 0, null);
            graphics2D.setClip(this.CLIP_SHAPE);
        }
        if (this.infoLabelsVisible && this.INNER_BOUNDS.height > 40) {
            graphics2D.setColor(this.sparkLineColor.TEXT_COLOR);
            graphics2D.setFont(this.INFO_LABEL_FONT.deriveFont(0.12f * (float)this.INNER_BOUNDS.height));
            graphics2D.drawString("hi: " + DF.format(this.hi), (int)((double)this.INNER_BOUNDS.width * 0.0277777778), 2 + graphics2D.getFont().getSize());
            graphics2D.drawString("lo: " + DF.format(this.lo), (int)((double)this.INNER_BOUNDS.width * 0.0277777778), this.INNER_BOUNDS.height - 4);
        }
        graphics2D.drawImage((Image)this.sparkLineImage, 0, 0, null);
        if (this.baseLineVisible) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(this.INNER_BOUNDS.x, (int)this.baseLineY, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, (int)this.baseLineY);
        }
        if (this.normalAreaVisible) {
            graphics2D.setColor(this.normalAreaColor);
            graphics2D.fill(this.NORMAL_AREA);
        }
        if (this.averageVisible) {
            graphics2D.setColor(this.averageColor);
            graphics2D.draw(this.AVERAGE_LINE);
        }
        if (!this.isEnabled()) {
            graphics2D.setColor(this.DISABLED_COLOR);
            graphics2D.fill(this.disabledShape);
        }
        graphics2D.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        graphics2D.dispose();
    }

    public void addDataPoint(double d) {
        for (DataPoint dataPoint : this.DATA_LIST) {
            if (System.currentTimeMillis() - dataPoint.getTimeStamp() <= this.timeFrame) continue;
            this.trashList.add(dataPoint);
        }
        for (DataPoint dataPoint : this.trashList) {
            this.DATA_LIST.remove(dataPoint);
        }
        this.trashList.clear();
        this.DATA_LIST.add(new DataPoint(System.currentTimeMillis(), d));
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public void addDataPoint(double d, long l) {
        for (DataPoint dataPoint : this.DATA_LIST) {
            if (l - dataPoint.getTimeStamp() <= this.timeFrame) continue;
            this.trashList.add(dataPoint);
        }
        for (DataPoint dataPoint : this.trashList) {
            this.DATA_LIST.remove(dataPoint);
        }
        this.trashList.clear();
        this.DATA_LIST.add(new DataPoint(l, d));
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public List<DataPoint> getDataList() {
        LinkedList<DataPoint> linkedList = new LinkedList<DataPoint>();
        linkedList.addAll(this.DATA_LIST);
        return linkedList;
    }

    public void setDataList(LinkedList<DataPoint> linkedList) {
        this.DATA_LIST.clear();
        this.DATA_LIST.addAll(linkedList);
        this.repaint(this.INNER_BOUNDS);
    }

    public double getStart() {
        return this.start;
    }

    public double getStop() {
        return this.stop;
    }

    public double getLo() {
        return this.lo;
    }

    public double getHi() {
        return this.hi;
    }

    public double getVariance() {
        if (!this.DATA_LIST.isEmpty()) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (DataPoint dataPoint : this.DATA_LIST) {
                d2 += dataPoint.getValue() * dataPoint.getValue();
                d += dataPoint.getValue();
            }
            d3 = d / (double)this.DATA_LIST.size();
            return d2 / (double)this.DATA_LIST.size() - d3 * d3;
        }
        return 0.0;
    }

    public double getAverage() {
        if (!this.DATA_LIST.isEmpty()) {
            double d = 0.0;
            for (DataPoint dataPoint : this.DATA_LIST) {
                d += dataPoint.getValue();
            }
            return d / (double)this.DATA_LIST.size();
        }
        return 0.0;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getRange() {
        return this.rangeY;
    }

    public double getQ1() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            int n = this.sortedList.size() % 2 != 0 ? this.sortedList.size() / 2 : this.sortedList.size() / 2 - 1;
            return this.sortedList.subList(0, n).get(this.sortedList.subList(0, n).size() / 2);
        }
        return 0.0;
    }

    public double getQ2() {
        return this.getMedian();
    }

    public double getQ3() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            int n = this.sortedList.size() / 2;
            return this.sortedList.subList(n, this.sortedList.size() - 1).get(this.sortedList.subList(n, this.sortedList.size() - 1).size() / 2);
        }
        return 0.0;
    }

    public double getMedian() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            if (this.sortedList.size() % 2 != 0) {
                return this.sortedList.get(this.sortedList.size() / 2);
            }
            return (this.sortedList.get(this.sortedList.size() / 2 - 1) + this.sortedList.get(this.sortedList.size() / 2)) / 2.0;
        }
        return 0.0;
    }

    public long getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(long l) {
        this.timeFrame = l;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public long getStartTimestamp() {
        if (this.DATA_LIST.isEmpty()) {
            return 0L;
        }
        return this.DATA_LIST.getFirst().getTimeStamp();
    }

    public long getStopTimestamp() {
        if (this.DATA_LIST.isEmpty()) {
            return 0L;
        }
        return this.DATA_LIST.getLast().getTimeStamp();
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
        if (bl) {
            this.hiLoIndicatorVisible = false;
        }
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public LcdColor getSparkLineColor() {
        return this.sparkLineColor;
    }

    public void setSparkLineColor(LcdColor lcdColor) {
        this.lineColor = lcdColor.TEXT_COLOR;
        this.sparkLineColor = lcdColor;
        this.recreateImages = true;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Paint getCustomSparkLineColor() {
        return this.customSparkLineColor;
    }

    public void setCustomSparkLineColor(Paint paint) {
        this.customSparkLineColor = paint;
        this.recreateImages = true;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public ColorDef getAreaFill() {
        return this.areaFill;
    }

    public void setAreaFill(ColorDef colorDef) {
        this.areaFill = colorDef;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getCustomAreaFillTop() {
        return this.customAreaFillTop;
    }

    public void setCustomAreaFillTop(Color color) {
        this.customAreaFillTop = color;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getCustomAreaFillBottom() {
        return this.customAreaFillBottom;
    }

    public void setCustomAreaFillBottom(Color color) {
        this.customAreaFillBottom = color;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isLineShadowVisible() {
        return this.lineShadowVisible;
    }

    public void setLineShadow(boolean bl) {
        this.lineShadowVisible = bl;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isStartStopIndicatorVisible() {
        return this.startStopIndicatorVisible;
    }

    public void setStartStopIndicatorVisible(boolean bl) {
        this.startStopIndicatorVisible = bl;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isHiLoIndicatorVisible() {
        return this.hiLoIndicatorVisible;
    }

    public void setHiLoIndicatorVisible(boolean bl) {
        this.hiLoIndicatorVisible = bl;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean bl) {
        this.backgroundVisible = bl;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isInfoLabelsVisible() {
        return this.infoLabelsVisible;
    }

    public void setInfoLabelsVisible(boolean bl) {
        this.infoLabelsVisible = bl;
        this.repaint(this.INNER_BOUNDS);
    }

    public SmoothingFunction getSmoothFunction() {
        return this.smoothFunction;
    }

    public void setSmoothFunction(SmoothingFunction smoothingFunction) {
        this.smoothFunction = smoothingFunction;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isBaseLineVisible() {
        return this.baseLineVisible;
    }

    public void setBaseLineVisible(boolean bl) {
        this.baseLineVisible = bl;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isAverageVisible() {
        return this.averageVisible;
    }

    public void setAverageVisible(boolean bl) {
        this.averageVisible = bl;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isNormalAreaVisible() {
        return this.normalAreaVisible;
    }

    public void setNormalAreaVisible(boolean bl) {
        this.normalAreaVisible = bl;
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getAverageColor() {
        return this.averageColor;
    }

    public void setAverageColor(Color color) {
        this.averageColor = color;
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getNormalAreaColor() {
        return this.normalAreaColor;
    }

    public void setNormalAreaColor(Color color) {
        this.normalAreaColor = UTIL.setAlpha(color, 0.2f);
        this.repaint(this.INNER_BOUNDS);
    }

    public BufferedImage getAsImage() {
        BufferedImage bufferedImage = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintAll(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void calculate(int n, int n2) {
        int n3;
        this.start = this.DATA_LIST.getFirst().getValue();
        this.stop = this.DATA_LIST.getLast().getValue();
        this.lo = this.DATA_LIST.getFirst().getValue();
        this.hi = this.DATA_LIST.getFirst().getValue();
        this.loIndex = 0;
        this.hiIndex = 0;
        int n4 = this.DATA_LIST.size();
        for (n3 = 0; n3 < n4; ++n3) {
            double d = this.DATA_LIST.get(n3).getValue();
            this.calcHiLoValues(d, n3);
        }
        this.rangeY = this.hi - this.lo;
        this.scaleY = this.rangeY / ((double)n2 - this.offset * 2.0);
        this.pointList.clear();
        if (this.DATA_LIST.size() > 5 && this.smoothing) {
            this.smoothData();
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(n3).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (this.DATA_LIST.get(n3).getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
            }
        }
        if (this.averageVisible || this.normalAreaVisible) {
            double d = (this.getAverage() - this.lo) * (1.0 / this.scaleY) + this.offset;
            double d2 = this.getStandardDeviation() * (1.0 / this.scaleY);
            this.NORMAL_AREA.setRect(this.INNER_BOUNDS.x, d - d2, this.INNER_BOUNDS.width, 2.0 * d2);
            this.AVERAGE_LINE.setLine(this.INNER_BOUNDS.x, d, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, d);
        }
    }

    private void smoothData() {
        int n = this.DATA_LIST.size();
        switch (this.smoothFunction) {
            case CONTINUOUS_AVERAGE: {
                this.pointList.add(new Point2D.Double(0.0, (this.DATA_LIST.getFirst().getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
                for (int i = 1; i < n - 1; ++i) {
                    double d = this.continuousAverage(this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue());
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (d - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.getLast().getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (this.DATA_LIST.getLast().getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
                break;
            }
            case CUBIC_SPLINE: {
                for (int i = 2; i < n - 1; ++i) {
                    double d = this.cubicInterpolate(this.DATA_LIST.get(i - 2).getValue(), this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (d - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                break;
            }
            case HERMITE: {
                for (int i = 2; i < n - 1; ++i) {
                    double d = this.hermiteInterpolate(this.DATA_LIST.get(i - 2).getValue(), this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i - 0).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5, 0.0, 0.0);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (d - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                break;
            }
            default: {
                for (int i = 0; i < n - 1; ++i) {
                    double d = this.cosInterpolate(this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (d - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
            }
        }
    }

    private void calcHiLoValues(double d, int n) {
        if (d < this.lo) {
            this.lo = d;
            this.loIndex = n;
        }
        if (d > this.hi) {
            this.hi = d;
            this.hiIndex = n;
        }
    }

    private void sortData() {
        this.sortedList.clear();
        for (DataPoint dataPoint : this.DATA_LIST) {
            this.sortedList.add(dataPoint.getValue());
        }
        Collections.sort(this.sortedList);
    }

    private double continuousAverage(double d, double d2, double d3) {
        return (1.0 * d + 1.0 * d2 + 1.0 * d3) / 3.0;
    }

    private double cubicInterpolate(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5 * d5;
        double d7 = d4 - d3 - d + d2;
        double d8 = d - d2 - d7;
        double d9 = d3 - d;
        double d10 = d2;
        return d7 * d5 * d6 + d8 * d6 + d9 * d5 + d10;
    }

    private double cosInterpolate(double d, double d2, double d3) {
        double d4 = (1.0 - Math.cos(d3 * Math.PI)) / 2.0;
        return d * (1.0 - d4) + d2 * d4;
    }

    private double hermiteInterpolate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d5 * d5;
        double d9 = d8 * d5;
        double d10 = (d2 - d) * (1.0 + d7) * (1.0 - d6) / 2.0;
        d10 += (d3 - d2) * (1.0 - d7) * (1.0 - d6) / 2.0;
        double d11 = (d3 - d2) * (1.0 + d7) * (1.0 - d6) / 2.0;
        double d12 = 2.0 * d9 - 3.0 * d8 + 1.0;
        double d13 = d9 - 2.0 * d8 + d5;
        double d14 = d9 - d8;
        double d15 = -2.0 * d9 + 3.0 * d8;
        return d12 * d2 + d13 * d10 + d14 * (d11 += (d4 - d3) * (1.0 - d7) * (1.0 - d6) / 2.0) + d15 * d3;
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 64 || dimension.height < 24) {
            dimension = new Dimension(64, 24);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n = dimension.width < 64 ? 64 : dimension.width;
        int n2 = dimension.height < 24 ? 24 : dimension.height;
        super.setMinimumSize(new Dimension(n, n2));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width > 1920 || dimension.height > 720) {
            dimension = new Dimension(1920, 720);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n = dimension.width > 1920 ? 1920 : dimension.width;
        int n2 = dimension.height > 720 ? 720 : dimension.height;
        super.setMaximumSize(new Dimension(n, n2));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.calcInnerBounds();
        this.init(n, n2);
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.calcInnerBounds();
        this.init(dimension.width, dimension.height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.calcInnerBounds();
        this.init(rectangle.width, rectangle.height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.calcInnerBounds();
        this.init(n3, n4);
    }

    private BufferedImage create_SPARK_LINE_BACKGROUND_Image(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        if (double_.equals(double_2)) {
            ((Point2D)double_2).setLocation(0.0, ((Point2D)double_).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = n > n2 ? (double)n2 * 0.12 : (double)n * 0.12;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        if (double_4.equals(double_5)) {
            ((Point2D)double_5).setLocation(0.0, ((Point2D)double_4).getY() + 1.0);
        }
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.sparkLineColor.GRADIENT_START_COLOR, this.sparkLineColor.GRADIENT_FRACTION1_COLOR, this.sparkLineColor.GRADIENT_FRACTION2_COLOR, this.sparkLineColor.GRADIENT_FRACTION3_COLOR, this.sparkLineColor.GRADIENT_STOP_COLOR};
        if (this.customSparkLineColor != null && this.sparkLineColor == LcdColor.CUSTOM) {
            graphics2D.setPaint(this.customSparkLineColor);
        } else {
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
        }
        double d2 = ((RoundRectangle2D)double_3).getArcWidth() - 1.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage createSparkLineImage(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!this.pointList.isEmpty()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.moveTo(this.pointList.get(0).getX(), this.baseLineY);
            generalPath.moveTo(this.pointList.get(0).getX(), (double)n2 - this.pointList.get(0).getY());
            generalPath2.lineTo(this.pointList.get(0).getX(), (double)n2 - this.pointList.get(0).getY());
            for (Point2D point2D : this.pointList) {
                generalPath.lineTo(point2D.getX(), (double)n2 - point2D.getY());
                generalPath2.lineTo(point2D.getX(), (double)n2 - point2D.getY());
            }
            generalPath2.lineTo(this.pointList.get(this.pointList.size() - 1).getX(), this.baseLineY);
            generalPath2.closePath();
            graphics2D.setStroke(new BasicStroke(this.lineWidth, 1, 0));
            if (this.filled) {
                float f;
                Point2D point2D;
                Point2D.Double double_ = new Point2D.Double(0.0, this.INNER_BOUNDS.y);
                point2D = new Point2D.Double(0.0, this.INNER_BOUNDS.y + this.INNER_BOUNDS.height);
                if (double_.equals(point2D)) {
                    point2D.setLocation(0.0, ((Point2D)double_).getY() + 1.0);
                }
                if ((f = (float)(this.baseLineY / (double)this.INNER_BOUNDS.height)) < 0.0f || f > 1.0f) {
                    f = 0.5f;
                }
                if (double_.distance(point2D) != 0.0) {
                    float[] fArray = new float[]{0.0f, f, 1.0f};
                    Color[] colorArray = this.areaFill == ColorDef.CUSTOM ? new Color[]{this.customAreaFillTop, this.customAreaFillBottom, this.customAreaFillTop} : new Color[]{UTIL.setAlpha(this.areaFill.LIGHT, 0.75f), UTIL.setAlpha(this.areaFill.DARK, 0.0f), UTIL.setAlpha(this.areaFill.LIGHT, 0.75f)};
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, point2D, fArray, colorArray);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(generalPath2);
                }
            } else if (this.lineShadowVisible) {
                graphics2D.translate(1, 1);
                graphics2D.setColor(new Color(0));
                graphics2D.draw(generalPath);
                graphics2D.translate(-1, -1);
            }
            graphics2D.setColor(this.lineColor);
            graphics2D.draw(generalPath);
            if (this.startStopIndicatorVisible) {
                graphics2D.drawImage((Image)this.startIndicatorImage, (int)this.pointList.get(0).getX() - this.startIndicatorImage.getWidth() / 2, n2 - (int)this.pointList.get(0).getY() - this.startIndicatorImage.getHeight() / 2, null);
                graphics2D.drawImage((Image)this.stopIndicatorImage, (int)this.pointList.get(this.pointList.size() - 1).getX() - this.stopIndicatorImage.getWidth() / 2, n2 - (int)this.pointList.get(this.pointList.size() - 1).getY() - this.stopIndicatorImage.getHeight() / 2, null);
            }
            if (this.hiLoIndicatorVisible) {
                if (this.loIndex < this.pointList.size()) {
                    graphics2D.drawImage((Image)this.loIndicatorImage, (int)this.pointList.get(this.loIndex).getX() - this.loIndicatorImage.getWidth() / 2, n2 - (int)this.pointList.get(this.loIndex).getY() - this.loIndicatorImage.getHeight() / 2, null);
                }
                if (this.hiIndex < this.pointList.size()) {
                    graphics2D.drawImage((Image)this.hiIndicatorImage, (int)this.pointList.get(this.hiIndex).getX() - this.hiIndicatorImage.getWidth() / 2, n2 - (int)this.pointList.get(this.hiIndex).getY() - this.hiIndicatorImage.getHeight() / 2, null);
                }
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HI_INDICATOR_Image(int n) {
        if (n <= 0) {
            return null;
        }
        int n2 = (int)(0.015 * (double)n);
        if (n2 < 4) {
            n2 = 4;
        }
        if (n2 > 8) {
            n2 = 8;
        }
        BufferedImage bufferedImage = UTIL.createImage(n2, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.5, 0.0);
        generalPath.lineTo(0.0f, n4);
        generalPath.lineTo(n3, n4);
        generalPath.lineTo((double)n3 * 0.5, 0.0);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.RED);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LO_INDICATOR_Image(int n) {
        if (n <= 0) {
            return null;
        }
        int n2 = (int)(0.015 * (double)n);
        if (n2 < 4) {
            n2 = 4;
        }
        if (n2 > 8) {
            n2 = 8;
        }
        BufferedImage bufferedImage = UTIL.createImage(n2, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n3 * 0.5, (double)n4);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.lineTo(n3, 0.0f);
        generalPath.lineTo((double)n3 * 0.5, (double)n4);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0, 0, 72, 255), new Color(0, 29, 255, 255), new Color(0, 29, 255, 255), new Color(0, 0, 72, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(new Color(7679));
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_START_STOP_INDICATOR_Image(int n) {
        if (n <= 0) {
            return null;
        }
        int n2 = (int)(0.015 * (double)n);
        if (n2 < 4) {
            n2 = 4;
        }
        if (n2 > 8) {
            n2 = 8;
        }
        BufferedImage bufferedImage = UTIL.createImage(n2, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, n3, n4);
        Point2D.Double double_2 = new Point2D.Double(0.42857142857142855 * (double)n3, 0.2857142857142857 * (double)n4);
        float[] fArray = new float[]{0.0f, 0.01f, 0.99f, 1.0f};
        Color[] colorArray = new Color[]{new Color(204, 204, 204, 255), new Color(204, 204, 204, 255), new Color(51, 51, 51, 255), new Color(51, 51, 51, 255)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_2, (float)(0.5 * (double)n3), fArray, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void createInitialImages() {
        this.recreateImages = true;
    }

    private void recreateAllImages() {
        this.recreateImages = true;
    }

    @Override
    public String toString() {
        return "Sparkline";
    }
}

