/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.io.Serializable;
import java.util.Locale;

public class IndexedSetStats
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int payload_size;
    private final int allocated_size;
    private final long payload_distance;
    private final long amortized_cost;
    private final long mod_count;

    IndexedSetStats(int payload_size, int allocated_size, long payload_distance, long amortized_cost, long mod_count) {
        this.payload_size = payload_size;
        this.allocated_size = allocated_size;
        this.payload_distance = payload_distance;
        this.amortized_cost = amortized_cost;
        this.mod_count = mod_count;
    }

    public int getSize() {
        return this.payload_size;
    }

    public int getAllocatedSize() {
        return this.allocated_size;
    }

    public double getFillFactor() {
        return (double)this.payload_size / (double)this.allocated_size;
    }

    public double getAverageDistance() {
        return this.payload_distance == 0L ? 0.0 : (double)this.payload_distance / (double)this.payload_size;
    }

    public double getAmortizedCost() {
        return this.amortized_cost == 0L ? 0.0 : (double)this.amortized_cost / (double)this.payload_size;
    }

    public long getModCount() {
        return this.mod_count;
    }

    public String toString() {
        return String.format(Locale.US, "size %d, filled %.1f%%, avgdist %.3f, amortized %.3f, mods %d", this.getSize(), this.getFillFactor() * 100.0, this.getAverageDistance(), this.getAmortizedCost(), this.getModCount());
    }
}

