/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class RadialCounter
extends AbstractRadial {
    private boolean rotateTickmarks = true;
    private double oldValue = 0.0;
    private double rotationAngle = 0.0;
    private final Point2D CENTER;
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage lcdImage;
    private BufferedImage tickmarksImage;
    private BufferedImage overlayImage;
    private BufferedImage pointerImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private Timeline timeline;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public RadialCounter() {
        this.CENTER = new Point2D.Double();
        this.timeline = new Timeline(this);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setLcdVisible(true);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return this;
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n * 0.1f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n * 0.1f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n * 0.1f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n * 0.1f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n * 0.1f));
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterY() - (double)this.getInsets().top);
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(n);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.create_LCD_Image((int)((double)n * 0.32), (int)((double)n * 0.1), this.getLcdColor(), this.getCustomLcdBackground());
        this.LCD.setRect((double)(this.getGaugeBounds().width - this.lcdImage.getWidth()) / 2.0, (double)(this.getGaugeBounds().height - this.lcdImage.getHeight()) / 2.0, (double)n * 0.32, (double)n * 0.1);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = this.create_TICKMARKS_Image(n);
        if (this.overlayImage != null) {
            this.overlayImage.flush();
        }
        this.overlayImage = this.create_OVERLAY_Image(n);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(n);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, false, this.getForegroundType());
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.isFrameVisible()) {
            graphics2D.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.rotateTickmarks) {
            graphics2D.rotate(-this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        }
        if (!this.rotateTickmarks) {
            graphics2D.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.overlayImage, 0, 0, null);
        if (this.isLcdVisible()) {
            graphics2D.drawImage((Image)this.lcdImage, (int)this.LCD.getX(), (int)this.LCD.getY(), null);
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + (double)this.lcdImage.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
        }
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    @Override
    public double getValue() {
        return this.oldValue;
    }

    @Override
    public void setValue(double d) {
        this.rotationAngle = 0.6283185307179586 * (d % 10.0);
        this.fireStateChanged();
        this.oldValue = d;
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.timeline.abort();
        }
        this.timeline = new Timeline(this);
        this.timeline.addPropertyToInterpolate("value", this.oldValue, d);
        this.timeline.setEase(new Spline(0.5f));
        this.timeline.setDuration(1500L);
        this.timeline.play();
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 10.0;
    }

    public boolean isRotateTickmarks() {
        return this.rotateTickmarks;
    }

    public void setRotateTickmarks(boolean bl) {
        this.rotateTickmarks = bl;
        this.setValue(0.0);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().x, this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getInnerBounds();
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private BufferedImage create_TICKMARKS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int n2 = bufferedImage.getWidth();
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = new BasicStroke(0.01f * (float)n2, 1, 2);
        Font font = new Font("Verdana", 0, (int)(0.07476635f * (float)n2));
        float f = 0.1f * (float)n2;
        float f2 = 0.02f * (float)n2;
        float f3 = 0.04f * (float)n2;
        float f4 = (float)n2 * 0.37f;
        this.CENTER.setLocation((float)n2 / 2.0f, (float)n2 / 2.0f);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickmarkColorFromThemeEnabled()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            graphics2D.setColor(this.getTickmarkColor());
        }
        for (double d3 = Math.PI * 2; d3 >= 0.0; d3 -= 0.3141592653589793) {
            Line2D.Double double_4;
            graphics2D.setStroke(basicStroke);
            d = Math.sin(d3);
            d2 = Math.cos(d3);
            if (n4 == 1) {
                graphics2D.setStroke(basicStroke);
                ((Point2D)double_).setLocation(this.CENTER.getX() + (double)(f4 - f2) * d, this.CENTER.getY() + (double)(f4 - f2) * d2);
                ((Point2D)double_2).setLocation(this.CENTER.getX() + (double)f4 * d, this.CENTER.getY() + (double)f4 * d2);
                double_4 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
                graphics2D.draw(double_4);
                n4 = 0;
            }
            if (n3 == 2) {
                graphics2D.setStroke(basicStroke);
                ((Point2D)double_).setLocation(this.CENTER.getX() + (double)(f4 - f3) * d, this.CENTER.getY() + (double)(f4 - f3) * d2);
                ((Point2D)double_2).setLocation(this.CENTER.getX() + (double)f4 * d, this.CENTER.getY() + (double)f4 * d2);
                double_4 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
                graphics2D.draw(double_4);
                n3 = 0;
            }
            graphics2D.setFont(font);
            ((Point2D)double_3).setLocation(this.CENTER.getX() + (double)(f4 - f) * d, this.CENTER.getY() + (double)(f4 - f) * d2);
            if (n5 != 20 && n5 % 2 == 0) {
                graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf(n5 / 2), (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
            }
            graphics2D.setTransform(affineTransform);
            ++n4;
            ++n3;
            ++n5;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_OVERLAY_Image(int n) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.31308412551879883, (double)n3 * 0.31308412551879883, (double)n2 * 0.37383174896240234, (double)n3 * 0.37383174896240234);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Ellipse2D.Double double_5 = new Ellipse2D.Double((double)n2 * (double)0.317757f, (double)n3 * (double)0.317757f, (double)n2 * 0.3644859790802002, (double)n3 * 0.3644859790802002);
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_7 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 0.35f, 1.0f};
        Color[] colorArray2 = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_6, double_7, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_5);
        Ellipse2D.Double double_8 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_9 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.41f, 0.705f, 1.0f};
        Color[] colorArray3 = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 30), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_9, (float)(0.4158878326 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_8);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.45794392523364486, (double)n3 * 0.9112149532710281);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.8271028037383178);
        generalPath.lineTo((double)n2 * 0.5420560747663551, (double)n3 * 0.9112149532710281);
        generalPath.lineTo((double)n2 * 0.45794392523364486, (double)n3 * 0.9112149532710281);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.9018691588785047);
        generalPath2.lineTo((double)n2 * 0.5, (double)n3 * 0.8457943925233645);
        generalPath2.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.9018691588785047);
        generalPath2.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.9018691588785047);
        generalPath2.closePath();
        Area area = new Area(generalPath);
        area.subtract(new Area(generalPath2));
        Point2D.Double double_ = new Point2D.Double(0.0, area.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, area.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = this.getPointerColor() != ColorDef.CUSTOM ? new Color[]{this.getPointerColor().DARK, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().DARK} : new Color[]{this.getCustomPointerColorObject().DARK, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().LIGHT, this.getCustomPointerColorObject().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.translate(1, 0);
        graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.55f));
        graphics2D.fill(area);
        graphics2D.translate(-1, 0);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(area);
        if (this.getPointerColor() != ColorDef.CUSTOM) {
            graphics2D.setColor(this.getPointerColor().LIGHT);
        } else {
            graphics2D.setColor(this.getCustomPointerColorObject().LIGHT);
        }
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(area);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "RadialCounter";
    }
}

