/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.cli;

import cz.jaybee.intelhex.IntelHexException;
import cz.jaybee.intelhex.Parser;
import cz.jaybee.intelhex.Region;
import cz.jaybee.intelhex.listeners.BinWriter;
import cz.jaybee.intelhex.listeners.RangeDetector;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Hex2bin {
    public static void main(String[] args) {
        String fileIn = "Application.hex";
        String fileOut = "Application.bin";
        String dataFrom = "min";
        String dataTo = "max";
        boolean minimize = false;
        if (args.length == 0) {
            System.out.println("usage:");
            System.out.println("    hex2bin <hex> <bin> <start address> <end address> [minimize]");
            System.out.println();
            System.out.println("    full address range of app.hex");
            System.out.println("        hex2bin app.hex app.bin");
            System.out.println();
            System.out.println("    limited exact address range of app.hex, undefined data are 0xff");
            System.out.println("        hex2bin app.hex app.bin 0x0000 0x1fff");
            System.out.println();
            System.out.println("    limited minimal address range of app.hex, start at 0x0000,");
            System.out.println("    max address is 0x1fff, but can be lower");
            System.out.println("        hex2bin app.hex app.bin 0x0000 0x1fff minimize");
            return;
        }
        if (args.length >= 1) {
            fileIn = args[0];
        }
        if (args.length >= 2) {
            fileOut = args[1];
        }
        if (args.length >= 3) {
            dataFrom = args[2];
        }
        if (args.length >= 4) {
            dataTo = args[3];
        }
        if (args.length >= 5 && args[4].equals("minimize")) {
            minimize = true;
        }
        try (FileInputStream is = new FileInputStream(fileIn);){
            FileOutputStream os = new FileOutputStream(fileOut);
            Parser parser = new Parser(is);
            RangeDetector rangeDetector = new RangeDetector();
            parser.setDataListener(rangeDetector);
            parser.parse();
            is.getChannel().position(0L);
            Region outputRegion = rangeDetector.getFullRangeRegion();
            if (!"min".equals(dataFrom)) {
                outputRegion.setAddressStart(Long.parseLong(dataFrom.substring(2), 16));
            }
            if (!"max".equals(dataTo)) {
                outputRegion.setAddressEnd(Long.parseLong(dataTo.substring(2), 16));
            }
            BinWriter writer = new BinWriter(outputRegion, os, minimize);
            parser.setDataListener(writer);
            parser.parse();
            System.out.printf("Program start address 0x%08X\r\n", parser.getStartAddress());
            System.out.println("Memory regions: ");
            System.out.println(rangeDetector.getMemoryRegions());
            System.out.print("Written output: ");
            System.out.println(outputRegion);
        }
        catch (IntelHexException | IOException ex) {
            Logger.getLogger(Hex2bin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

