/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.EnumIniField;
import com.rusefi.ConfigDefinitionRootOutputFolder;
import com.rusefi.ConfigFieldImpl;
import com.rusefi.EnumsReader;
import com.rusefi.InvalidConstant;
import com.rusefi.ReaderProvider;
import com.rusefi.ReaderState;
import com.rusefi.RootHolder;
import com.rusefi.ToolUtil;
import com.rusefi.VariableRegistry;
import com.rusefi.core.Pair;
import com.rusefi.enum_reader.Value;
import com.rusefi.output.CHeaderConsumer;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigStructureImpl;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.FileJavaFieldsConsumer;
import com.rusefi.parse.TokenUtil;
import com.rusefi.parse.TypesHelper;
import com.rusefi.util.LazyFile;
import com.rusefi.util.SystemOut;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class ReaderStateImpl
implements ReaderState {
    private static final Logging log = Logging.getLogging(ReaderStateImpl.class);
    public static final String BIT = "bit";
    private static final String CUSTOM = "custom";
    private static final String END_STRUCT = "end_struct";
    private static final String STRUCT_NO_PREFIX = "struct_no_prefix ";
    private static final String STRUCT = "struct ";
    private final List<String> inputFiles = new ArrayList<String>();
    private final Stack<ConfigStructureImpl> stack = new Stack();
    private final Map<String, Integer> tsCustomSize = new HashMap<String, Integer>();
    private final Map<String, String> tsCustomLine = new HashMap<String, String>();
    private final Map<String, ConfigStructureImpl> structures = new HashMap<String, ConfigStructureImpl>();
    private final ReaderProvider readerProvider;
    private final LazyFile.LazyFileFactory fileFactory;
    private String headerMessage;
    private String tsFileOutputName = null;
    private String definitionInputFile = null;
    String destCDefinesFileName = null;
    private boolean withC_Defines = true;
    private final List<String> prependFiles = new ArrayList<String>();
    private final List<ConfigurationConsumer> destinations = new ArrayList<ConfigurationConsumer>();
    private final EnumsReader enumsReader = new EnumsReader();
    private final VariableRegistry variableRegistry = new VariableRegistry();

    public ReaderStateImpl() {
        this(ReaderProvider.REAL, LazyFile.REAL);
    }

    public ReaderStateImpl(ReaderProvider readerProvider, LazyFile.LazyFileFactory fileFactory) {
        this.readerProvider = readerProvider;
        this.fileFactory = fileFactory;
    }

    @Override
    public void setWithC_Defines(boolean withC_Defines) {
        this.withC_Defines = withC_Defines;
    }

    @Override
    public EnumsReader getEnumsReader() {
        return this.enumsReader;
    }

    public List<String> getInputFiles() {
        return this.inputFiles;
    }

    private static void handleBitLine(ReaderStateImpl state, String line) {
        String comment;
        String bitName;
        if (!(line = line.substring(BIT.length() + 1).trim()).contains(";")) {
            bitName = line;
            comment = "";
        } else {
            int index = line.indexOf(";");
            bitName = line.substring(0, index);
            comment = line.substring(index + 1);
        }
        String[] bitNameParts = bitName.split(",");
        if (log.debugEnabled()) {
            log.debug("Need to align before bit " + bitName);
        }
        state.stack.peek().addAlignmentFill(state, 4);
        String trueName = bitNameParts.length > 1 ? bitNameParts[1].replaceAll("\"", "") : null;
        String falseName = bitNameParts.length > 2 ? bitNameParts[2].replaceAll("\"", "") : null;
        ConfigFieldImpl bitField = new ConfigFieldImpl(state, bitNameParts[0], comment, null, "boolean", new int[0], null, false, false, trueName, falseName);
        if (state.stack.isEmpty()) {
            throw new IllegalStateException("Parent structure expected");
        }
        ConfigStructureImpl structure = state.stack.peek();
        structure.addBitField(bitField);
    }

    @Override
    public void doJob() throws IOException {
        for (String prependFile : this.prependFiles) {
            this.variableRegistry.readPrependValues(prependFile);
        }
        SystemOut.println("Reading definition from " + Objects.requireNonNull(this.definitionInputFile));
        String fileNameWithRoot = RootHolder.ROOT + this.definitionInputFile;
        try (BufferedReader definitionReader = new BufferedReader(this.readerProvider.read(fileNameWithRoot));){
            this.readBufferedReader(definitionReader, this.destinations);
        }
        catch (Throwable e) {
            throw new IllegalStateException("While processing " + fileNameWithRoot);
        }
        if (this.destCDefinesFileName != null) {
            CHeaderConsumer.writeDefinesToFile(this.getVariableRegistry(), ConfigDefinitionRootOutputFolder.getValue() + this.destCDefinesFileName, this.definitionInputFile);
        }
    }

    public void read(Reader reader) throws IOException {
        Map<String, EnumsReader.EnumState> newEnums = EnumsReader.readStatic(reader);
        for (Map.Entry<String, EnumsReader.EnumState> enumFamily : newEnums.entrySet()) {
            for (Map.Entry<String, Value> entry : enumFamily.getValue().entrySet()) {
                String key = enumFamily.getKey() + "_" + entry.getKey();
                String value = entry.getValue().getValue();
                this.variableRegistry.register(key, value);
                try {
                    int numericValue = entry.getValue().getIntValue();
                    this.variableRegistry.registerHex(key, numericValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.enumsReader.enums.putAll(newEnums);
    }

    private void handleCustomLine(String customLineWithPrefix) {
        String withoutPrefix = customLineWithPrefix.substring(CUSTOM.length() + 1).trim();
        Pair<String, String> nameAndRest = TokenUtil.grabFirstTokenAndTheRest(withoutPrefix);
        String name = (String)nameAndRest.first;
        String autoEnumOptions = this.variableRegistry.getEnumOptionsForTunerStudio(this.enumsReader, name);
        if (autoEnumOptions != null) {
            this.variableRegistry.register(name + "_auto_enum", autoEnumOptions);
        }
        String line = (String)nameAndRest.second;
        Pair<String, String> sizeAndRest = TokenUtil.grabFirstTokenAndTheRest(line);
        String customSize = (String)sizeAndRest.first;
        String tunerStudioLine = (String)sizeAndRest.second;
        tunerStudioLine = this.variableRegistry.applyVariables(tunerStudioLine);
        int size = this.parseSize(customSize, line);
        this.tsCustomSize.put(name, size);
        RawIniFile.Line rawLine = new RawIniFile.Line(tunerStudioLine);
        if (rawLine.getTokens()[0].equals("bits")) {
            boolean looksLikeListVariableSyntax;
            int enumCount;
            EnumIniField.ParseBitRange bitRange = new EnumIniField.ParseBitRange().invoke(rawLine.getTokens()[3]);
            int totalCount = 1 << bitRange.getBitSize0() + 1;
            List<String> enums = Arrays.asList(rawLine.getTokens()).subList(4, rawLine.getTokens().length);
            boolean isKeyValueSyntax = EnumIniField.EnumKeyValueMap.isKeyValueSyntax(EnumIniField.getEnumValuesSection(tunerStudioLine));
            int n = enumCount = isKeyValueSyntax ? enums.size() / 2 : enums.size();
            if (enumCount > totalCount) {
                throw new IllegalStateException(name + ": Too many options in " + tunerStudioLine + " capacity=" + totalCount + "/size=" + enums.size());
            }
            boolean bl = looksLikeListVariableSyntax = enumCount == 1;
            if (!isKeyValueSyntax && !looksLikeListVariableSyntax) {
                StringBuilder sb = new StringBuilder(tunerStudioLine);
                for (int i = enumCount; i < totalCount; ++i) {
                    sb.append(", ").append(InvalidConstant.QUOTED_INVALID);
                }
                tunerStudioLine = sb.toString();
            }
        }
        this.tsCustomLine.put(name, tunerStudioLine);
    }

    public int parseSize(String customSize, String line) {
        customSize = this.variableRegistry.applyVariables(customSize);
        customSize = customSize.replaceAll("x", "*");
        line = this.variableRegistry.applyVariables(line);
        int multPosition = customSize.indexOf(42);
        if (multPosition != -1) {
            int first;
            String firstPart = customSize.substring(0, multPosition).trim();
            try {
                first = Integer.parseInt(firstPart);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Size in " + line);
            }
            return first * this.parseSize(customSize.substring(multPosition + 1), line);
        }
        try {
            return Integer.parseInt(customSize);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Size in " + line);
        }
    }

    private void handleEndStruct(List<ConfigurationConsumer> consumers) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Unexpected end_struct");
        }
        ConfigStructureImpl structure = this.stack.pop();
        if (log.debugEnabled()) {
            log.debug("Ending structure " + structure.getName());
        }
        structure.addAlignmentFill(this, 4);
        this.structures.put(structure.getName(), structure);
        for (ConfigurationConsumer consumer : consumers) {
            consumer.handleEndStruct(this, structure);
        }
    }

    public void readBufferedReader(String inputString, ConfigurationConsumer ... consumers) {
        try {
            this.readBufferedReader(new BufferedReader(new StringReader(inputString)), Arrays.asList(consumers));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void readBufferedReader(BufferedReader definitionReader, List<ConfigurationConsumer> consumers) throws IOException {
        String line;
        for (ConfigurationConsumer consumer : consumers) {
            consumer.startFile();
        }
        int lineIndex = 0;
        while ((line = definitionReader.readLine()) != null) {
            ++lineIndex;
            if (ToolUtil.isEmptyDefinitionLine(line = ToolUtil.trimLine(line))) continue;
            if (line.startsWith(STRUCT)) {
                ReaderStateImpl.handleStartStructure(this, line.substring(STRUCT.length()), true);
                continue;
            }
            if (line.startsWith(STRUCT_NO_PREFIX)) {
                ReaderStateImpl.handleStartStructure(this, line.substring(STRUCT_NO_PREFIX.length()), false);
                continue;
            }
            if (line.startsWith(END_STRUCT)) {
                this.addBitPadding();
                this.handleEndStruct(consumers);
                continue;
            }
            if (line.startsWith(BIT)) {
                ReaderStateImpl.handleBitLine(this, line);
                continue;
            }
            if (ToolUtil.startsWithToken(line, CUSTOM)) {
                this.handleCustomLine(line);
                continue;
            }
            if (ToolUtil.startsWithToken(line, "#define")) {
                this.variableRegistry.processDefine(line.substring("#define".length()).trim());
                continue;
            }
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Expected to be within structure at line " + lineIndex + ": " + line);
            }
            this.addBitPadding();
            ReaderStateImpl.processField(this, line);
        }
        for (ConfigurationConsumer consumer : consumers) {
            consumer.endFile();
        }
        this.ensureEmptyAfterProcessing();
    }

    private void addBitPadding() {
        ConfigStructureImpl structure = this.stack.peek();
        structure.addBitPadding(this);
    }

    public void ensureEmptyAfterProcessing() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Unclosed structure: " + this.stack.peek().getName());
        }
    }

    private static void handleStartStructure(ReaderStateImpl state, String line, boolean withPrefix) {
        String comment;
        String name;
        if (line.contains(" ")) {
            int index = line.indexOf(32);
            name = line.substring(0, index);
            comment = line.substring(index + 1).trim();
        } else {
            name = line;
            comment = null;
        }
        ConfigStructure parent = state.stack.isEmpty() ? null : (ConfigStructure)state.stack.peek();
        ConfigStructureImpl structure = new ConfigStructureImpl(name, comment, withPrefix, parent);
        state.stack.push(structure);
        if (log.debugEnabled()) {
            log.debug("Starting structure " + structure.getName());
        }
    }

    private static void processField(ReaderStateImpl state, String line) {
        ConfigFieldImpl cf = ConfigFieldImpl.parse(state, line);
        if (cf == null) {
            if (ConfigFieldImpl.isPreprocessorDirective(line)) {
                cf = new ConfigFieldImpl(state, "", line, null, "directive", new int[0], null, false, false, null, null);
            } else {
                throw new IllegalStateException("Cannot parse line [" + line + "]");
            }
        }
        if (state.stack.isEmpty()) {
            throw new IllegalStateException(cf.getName() + ": Not enclosed in a struct");
        }
        ConfigStructureImpl structure = state.stack.peek();
        Integer getPrimitiveSize = TypesHelper.getPrimitiveSize(cf.getType());
        Integer customTypeSize = state.tsCustomSize.get(cf.getType());
        if (getPrimitiveSize != null && getPrimitiveSize > 1) {
            if (log.debugEnabled()) {
                log.debug("Need to align before " + cf.getName());
            }
            structure.addAlignmentFill(state, getPrimitiveSize);
        } else if (state.structures.containsKey(cf.getType())) {
            structure.addAlignmentFill(state, 4);
        } else if (customTypeSize != null) {
            structure.addAlignmentFill(state, customTypeSize % 8);
        }
        if (cf.isIterate()) {
            structure.addC(cf);
            for (int i = 1; i <= cf.getArraySizes()[0]; ++i) {
                String commentWithIndex = ReaderStateImpl.getCommentWithIndex(cf, i);
                ConfigFieldImpl element = new ConfigFieldImpl(state, cf.getName() + i, commentWithIndex, null, cf.getType(), new int[0], cf.getTsInfo(), false, cf.isHasAutoscale(), null, null);
                element.setFromIterate(cf.getName(), i);
                structure.addTs(element);
            }
        } else if (cf.isDirective()) {
            structure.addTs(cf);
        } else {
            structure.addBoth(cf);
        }
    }

    @NotNull
    private static String getCommentWithIndex(ConfigFieldImpl cf, int i) {
        String unquoted = VariableRegistry.unquote(cf.getCommentOrName());
        String string = unquoted + " " + i;
        return VariableRegistry.quote(string);
    }

    @Override
    public String getHeader() {
        if (this.headerMessage == null) {
            throw new NullPointerException("No header message yet");
        }
        return this.headerMessage;
    }

    @Override
    public void setDefinitionInputFile(String definitionInputFile) {
        this.definitionInputFile = definitionInputFile;
        this.headerMessage = ToolUtil.getGeneratedAutomaticallyTag() + definitionInputFile + " " + new Date();
        this.inputFiles.add(definitionInputFile);
    }

    @Override
    public void addCHeaderDestination(String cHeaderFileName) {
        this.destinations.add(new CHeaderConsumer(this, ConfigDefinitionRootOutputFolder.getValue() + cHeaderFileName, this.withC_Defines, this.fileFactory));
    }

    public void addJavaDestination(String fileName) {
        this.destinations.add(new FileJavaFieldsConsumer(this, fileName, 0, this.fileFactory));
    }

    @Override
    public void addPrepend(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        this.prependFiles.add(fileName);
        this.inputFiles.add(fileName);
    }

    @Override
    public void addDestination(ConfigurationConsumer ... consumers) {
        this.destinations.addAll(Arrays.asList(consumers));
    }

    public void addInputFile(String fileName) {
        this.inputFiles.add(fileName);
    }

    @Override
    public VariableRegistry getVariableRegistry() {
        return this.variableRegistry;
    }

    @Override
    public Map<String, Integer> getTsCustomSize() {
        return this.tsCustomSize;
    }

    @Override
    public Map<String, ? extends ConfigStructure> getStructures() {
        return this.structures;
    }

    @Override
    public Map<String, String> getTsCustomLine() {
        return this.tsCustomLine;
    }

    @Override
    public void setHeaderMessage(String headerMessage) {
        this.headerMessage = headerMessage;
    }

    @Override
    public String getTsFileOutputName() {
        return this.tsFileOutputName;
    }

    @Override
    public void setTsFileOutputName(String tsFileOutputName) {
        this.tsFileOutputName = tsFileOutputName;
    }

    @Override
    public List<String> getPrependFiles() {
        return this.prependFiles;
    }

    @Override
    public boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public ConfigStructure peek() {
        return this.stack.peek();
    }
}

