/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import java.awt.Color;
import java.awt.Paint;

public class DesignSet {
    private final FrameDesign FRAME_DESIGN;
    private final FrameEffect FRAME_EFFECT;
    private final Paint OUTER_FRAME_COLOR;
    private final Paint INNER_FRAME_COLOR;
    private final BackgroundColor BACKGROUND_COLOR;
    private final Color TEXTURE_COLOR;
    private final ColorDef COLOR;
    private final LedColor LED_COLOR;
    private final LedColor USER_LED_COLOR;
    private final LcdColor LCD_COLOR;
    private final Color GLOW_COLOR;
    private final KnobStyle KNOB_STYLE;

    private DesignSet(Builder builder) {
        this.FRAME_DESIGN = builder.frameDesign;
        this.FRAME_EFFECT = builder.frameEffect;
        this.OUTER_FRAME_COLOR = builder.outerFrameColor;
        this.INNER_FRAME_COLOR = builder.innerFrameColor;
        this.BACKGROUND_COLOR = builder.backgroundColor;
        this.TEXTURE_COLOR = builder.textureColor;
        this.COLOR = builder.color;
        this.LED_COLOR = builder.ledColor;
        this.USER_LED_COLOR = builder.userLedColor;
        this.LCD_COLOR = builder.lcdColor;
        this.GLOW_COLOR = builder.glowColor;
        this.KNOB_STYLE = builder.knobStyle;
    }

    public FrameDesign getFrameDesign() {
        return this.FRAME_DESIGN;
    }

    public FrameEffect getFrameEffect() {
        return this.FRAME_EFFECT;
    }

    public Paint getOuterFrameColor() {
        return this.OUTER_FRAME_COLOR;
    }

    public Paint getInnerFrameColor() {
        return this.INNER_FRAME_COLOR;
    }

    public BackgroundColor getBackgroundColor() {
        return this.BACKGROUND_COLOR;
    }

    public Color getTextureColor() {
        return this.TEXTURE_COLOR;
    }

    public ColorDef getColor() {
        return this.COLOR;
    }

    public LedColor getLedColor() {
        return this.LED_COLOR;
    }

    public LedColor getUserLedColor() {
        return this.USER_LED_COLOR;
    }

    public LcdColor getLcdColor() {
        return this.LCD_COLOR;
    }

    public Color getGlowColor() {
        return this.GLOW_COLOR;
    }

    public KnobStyle getKnobStyle() {
        return this.KNOB_STYLE;
    }

    public static class Builder {
        private FrameDesign frameDesign = null;
        private FrameEffect frameEffect = null;
        private Paint outerFrameColor = null;
        private Paint innerFrameColor = null;
        private BackgroundColor backgroundColor = null;
        private Color textureColor = null;
        private ColorDef color = null;
        private LedColor ledColor = null;
        private LedColor userLedColor = null;
        private LcdColor lcdColor = null;
        private Color glowColor = null;
        private KnobStyle knobStyle = null;

        public Builder frameDesign(FrameDesign frameDesign) {
            this.frameDesign = frameDesign;
            return this;
        }

        public Builder frameEffect(FrameEffect frameEffect) {
            this.frameEffect = frameEffect;
            return this;
        }

        public Builder outerFrameColor(Paint paint) {
            this.outerFrameColor = paint;
            return this;
        }

        public Builder innerFrameColor(Paint paint) {
            this.innerFrameColor = paint;
            return this;
        }

        public Builder backgroundColor(BackgroundColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder textureColor(Color color) {
            this.textureColor = color;
            return this;
        }

        public Builder color(ColorDef colorDef) {
            this.color = colorDef;
            return this;
        }

        public Builder ledColor(LedColor ledColor) {
            this.ledColor = ledColor;
            return this;
        }

        public Builder userLedColor(LedColor ledColor) {
            this.userLedColor = ledColor;
            return this;
        }

        public Builder lcdColor(LcdColor lcdColor) {
            this.lcdColor = lcdColor;
            return this;
        }

        public Builder glowColor(Color color) {
            this.glowColor = color;
            return this;
        }

        public Builder knobStyle(KnobStyle knobStyle) {
            this.knobStyle = knobStyle;
            return this;
        }

        public DesignSet build() {
            return new DesignSet(this);
        }
    }
}

