/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class BiLinearGradientPaint
implements Paint {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle BOUNDS;
    private final Color COLOR_00;
    private final Color COLOR_10;
    private final Color COLOR_01;
    private final Color COLOR_11;
    private final float FRACTION_X_STEPSIZE;
    private final float FRACTION_Y_STEPSIZE;
    private int titleBarHeight;

    public BiLinearGradientPaint(Shape shape, Color color, Color color2, Color color3, Color color4) throws IllegalArgumentException {
        this.BOUNDS = shape.getBounds();
        this.COLOR_00 = color;
        this.COLOR_10 = color2;
        this.COLOR_01 = color3;
        this.COLOR_11 = color4;
        this.FRACTION_X_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().width;
        this.FRACTION_Y_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().height;
        this.titleBarHeight = -1;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new BiLinearGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "BiLinearGradientPaint";
    }

    private final class BiLinearGradientPaintContext
    implements PaintContext {
        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            if (BiLinearGradientPaint.this.titleBarHeight == -1) {
                BiLinearGradientPaint.this.titleBarHeight = n2;
            }
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            float f = (float)(n - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
            float f2 = (float)(n2 - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.y - BiLinearGradientPaint.this.titleBarHeight) * BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE;
            f = f > 1.0f ? 1.0f : f;
            f2 = f2 > 1.0f ? 1.0f : f2;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    Color color = UTIL.bilinearInterpolateColor(BiLinearGradientPaint.this.COLOR_00, BiLinearGradientPaint.this.COLOR_10, BiLinearGradientPaint.this.COLOR_01, BiLinearGradientPaint.this.COLOR_11, f, f2);
                    f = (f += BiLinearGradientPaint.this.FRACTION_X_STEPSIZE) > 1.0f ? 1.0f : f;
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = color.getRed();
                    nArray[n5 + 1] = color.getGreen();
                    nArray[n5 + 2] = color.getBlue();
                    nArray[n5 + 3] = color.getAlpha();
                }
                f = (float)(n - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
                f2 = (f2 += BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE) > 1.0f ? 1.0f : f2;
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

