/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetBoundException;
import tel.schich.javacan.CanFrame;
import tel.schich.javacan.CanSocketOptions;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.RawCanChannel;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.platform.linux.LinuxNativeOperationException;
import tel.schich.javacan.platform.linux.LinuxNetworkDevice;

final class RawCanChannelImpl
extends RawCanChannel {
    private volatile NetworkDevice device;

    RawCanChannelImpl(int sock) {
        super(sock);
    }

    @Override
    public RawCanChannel bind(NetworkDevice device) throws IOException {
        if (!(device instanceof LinuxNetworkDevice)) {
            throw new IllegalArgumentException("Unsupported network device given!");
        }
        try {
            SocketCAN.bindSocket(this.getSocket(), ((LinuxNetworkDevice)device).getIndex(), 0, 0);
        }
        catch (LinuxNativeOperationException e) {
            throw RawCanChannelImpl.checkForClosedChannel(e);
        }
        this.device = device;
        return this;
    }

    @Override
    public NetworkDevice getDevice() {
        if (!this.isBound()) {
            throw new NotYetBoundException();
        }
        return this.device;
    }

    @Override
    public boolean isBound() {
        return this.device != null;
    }

    @Override
    public CanFrame read() throws IOException {
        int length = this.getOption(CanSocketOptions.FD_FRAMES) != false ? 72 : 16;
        ByteBuffer frameBuf = JavaCAN.allocateOrdered(length);
        return this.read(frameBuf);
    }

    @Override
    public CanFrame read(ByteBuffer buffer) throws IOException {
        this.readUnsafe(buffer);
        return CanFrame.create(buffer);
    }

    @Override
    public long readUnsafe(ByteBuffer buffer) throws IOException {
        long bytesRead = this.readSocket(buffer);
        buffer.flip();
        return bytesRead;
    }

    @Override
    public RawCanChannel write(CanFrame frame) throws IOException {
        long written = this.writeUnsafe(frame.getBuffer());
        if (written != (long)frame.getSize()) {
            throw new IOException("Frame written incompletely!");
        }
        return this;
    }

    @Override
    public long writeUnsafe(ByteBuffer buffer) throws IOException {
        return this.writeSocket(buffer);
    }
}

