/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.dfu;

import com.rusefi.dfu.BinaryImage;
import com.rusefi.dfu.FlashRange;
import cz.jaybee.intelhex.DataListener;
import cz.jaybee.intelhex.IntelHexException;
import cz.jaybee.intelhex.Parser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class HexImage
implements BinaryImage {
    private final byte[] image;

    public HexImage(byte[] image) {
        this.image = image;
    }

    public static HexImage loadHexToBuffer(String fileName, FlashRange flashRange) throws IntelHexException, IOException {
        return HexImage.loadHexToBuffer(new FileInputStream(fileName), flashRange);
    }

    public static HexImage loadHexToBuffer(InputStream is, final FlashRange flashRange) throws IntelHexException, IOException {
        Objects.requireNonNull(flashRange, "flashRange");
        final byte[] image = new byte[flashRange.getTotalLength()];
        Parser ihp = new Parser(is);
        final AtomicInteger totalBytesReceived = new AtomicInteger();
        final AtomicInteger maxOffset = new AtomicInteger();
        ihp.setDataListener(new DataListener(){

            @Override
            public void data(long address, byte[] data) {
                totalBytesReceived.addAndGet(data.length);
                maxOffset.set((int)Math.max((long)maxOffset.get(), address + (long)data.length));
                if (address < (long)flashRange.getBaseAddress() || address + (long)data.length > (long)(flashRange.getBaseAddress() + flashRange.getTotalLength())) {
                    throw new IllegalStateException(String.format("Image data out of range: %x@%x not within %s", data.length, address, flashRange.toString()));
                }
                System.arraycopy(data, 0, image, (int)(address - (long)flashRange.getBaseAddress()), data.length);
            }

            @Override
            public void eof() {
            }
        });
        ihp.parse();
        int imageSize = maxOffset.get() - flashRange.getBaseAddress();
        return new HexImage(Arrays.copyOfRange(image, 0, imageSize));
    }

    @Override
    public byte[] getImage() {
        return this.image;
    }

    public String toString() {
        return "HexImage{image=" + this.image.length + '}';
    }
}

