/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.livedata.ParseResult;
import com.rusefi.livedata.generated.CPP14Parser;
import com.rusefi.livedata.generated.CPP14ParserBaseListener;
import com.rusefi.ui.livedata.Range;
import com.rusefi.ui.livedata.SourceCodePainter;
import com.rusefi.ui.livedata.VariableValueSource;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;

public class CodeWalkthrough {
    private static final Logging log = Logging.getLogging(CodeWalkthrough.class);
    public static final Color ACTIVE_STATEMENT = new Color(102, 255, 102);
    public static final Color PASSIVE_CODE = Color.lightGray;
    public static final Color BROKEN_CODE = Color.orange;
    public static final Color TRUE_CONDITION = Color.GREEN;
    public static final Color FALSE_CONDITION = Color.RED;
    public static final Color CONFIG = Color.BLUE;
    private static final String CONFIG_MAGIC_PREFIX = "engineConfiguration";

    public static ParseResult applyVariables(final VariableValueSource valueSource, final String sourceCode, final SourceCodePainter painter, ParseTree tree) {
        final Stack currentState = new Stack();
        final ArrayList<String> brokenConditions = new ArrayList<String>();
        final ArrayList allTerminals = new ArrayList();
        final ArrayList<CPP14Parser.UnqualifiedIdContext> functions = new ArrayList<CPP14Parser.UnqualifiedIdContext>();
        new ParseTreeWalker().walk(new CPP14ParserBaseListener(){

            @Override
            public void enterFunctionDefinition(CPP14Parser.FunctionDefinitionContext ctx) {
                CodeWalkthrough.resetState(currentState);
                CPP14Parser.DeclaratoridContext declaratorid = ctx.declarator().pointerDeclarator().noPointerDeclarator().noPointerDeclarator().declaratorid();
                CPP14Parser.IdExpressionContext idExpressionContext = declaratorid.idExpression();
                CPP14Parser.QualifiedIdContext qualifiedIdContext = idExpressionContext.qualifiedId();
                CPP14Parser.UnqualifiedIdContext unqualifiedIdContext = qualifiedIdContext != null ? qualifiedIdContext.unqualifiedId() : idExpressionContext.unqualifiedId();
                functions.add(unqualifiedIdContext);
            }

            @Override
            public void enterDeclarationStatement(CPP14Parser.DeclarationStatementContext ctx) {
                super.enterDeclarationStatement(ctx);
                this.colorStatement(ctx, painter);
            }

            @Override
            public void enterExpressionStatement(CPP14Parser.ExpressionStatementContext ctx) {
                super.enterExpressionStatement(ctx);
                this.colorStatement(ctx, painter);
            }

            @Override
            public void enterJumpStatement(CPP14Parser.JumpStatementContext ctx) {
                super.enterJumpStatement(ctx);
                this.colorStatement(ctx, painter);
                if ("return".equalsIgnoreCase(ctx.getStart().getText()) && !currentState.isEmpty() && CodeWalkthrough.getOverallState(currentState) == BranchingState.TRUE) {
                    currentState.clear();
                }
            }

            @Override
            public void visitTerminal(TerminalNode node) {
                allTerminals.add(node);
                String text = node.getSymbol().getText();
                if ("else".equalsIgnoreCase(text)) {
                    if (log.debugEnabled()) {
                        log.debug("CONDITIONAL ELSE terminal, flipping condition");
                    }
                    if (currentState.isEmpty()) {
                        return;
                    }
                    BranchingState onTop = (BranchingState)((Object)currentState.pop());
                    currentState.add(onTop.flip());
                }
            }

            @Override
            public void enterCondition(CPP14Parser.ConditionContext ctx) {
                String conditionVariable = ctx.getText();
                if (log.debugEnabled()) {
                    log.debug("CONDITIONAL: REQUESTING VALUE " + conditionVariable);
                }
                if (currentState.isEmpty()) {
                    painter.paintBackground(PASSIVE_CODE, new Range(ctx));
                } else {
                    VariableValueSource.VariableState state = valueSource.getValue(conditionVariable);
                    Boolean value = state == null ? null : Boolean.valueOf(state.getValue() != 0.0);
                    BranchingState branchingState = BranchingState.valueOf(value);
                    if (log.debugEnabled()) {
                        log.debug("CURRENT STATE ADD " + state);
                    }
                    currentState.add(branchingState);
                    if (branchingState == BranchingState.BROKEN) {
                        brokenConditions.add(conditionVariable);
                        painter.paintBackground(BROKEN_CODE, new Range(ctx));
                    } else if (branchingState == BranchingState.TRUE) {
                        painter.paintBackground(TRUE_CONDITION, new Range(ctx));
                    } else {
                        painter.paintBackground(FALSE_CONDITION, new Range(ctx));
                    }
                }
            }

            @Override
            public void exitSelectionStatement(CPP14Parser.SelectionStatementContext ctx) {
                super.exitSelectionStatement(ctx);
                if (currentState.isEmpty()) {
                    return;
                }
                BranchingState onTop = (BranchingState)((Object)currentState.pop());
                if (onTop == BranchingState.BROKEN) {
                    currentState.push(BranchingState.BROKEN);
                }
                if (log.debugEnabled()) {
                    log.debug("CONDITIONAL: EXIT");
                }
            }

            private void colorStatement(ParserRuleContext ctx, SourceCodePainter painter2) {
                BranchingState isAlive;
                Color color = currentState.isEmpty() ? PASSIVE_CODE : ((isAlive = CodeWalkthrough.getOverallState(currentState)) == BranchingState.BROKEN ? BROKEN_CODE : (isAlive == BranchingState.TRUE ? ACTIVE_STATEMENT : PASSIVE_CODE));
                Range range = Range.create(ctx.start, ctx.stop);
                if (range == null) {
                    return;
                }
                if (log.debugEnabled()) {
                    log.info(color + " for " + sourceCode.substring(range.getStart(), range.getStop()));
                }
                painter2.paintBackground(color, range);
            }
        }, tree);
        ArrayList<Token> configTokens = new ArrayList<Token>();
        for (int i = 0; i < allTerminals.size() - 3; ++i) {
            if (!((TerminalNode)allTerminals.get(i)).getText().equals(CONFIG_MAGIC_PREFIX) || !((TerminalNode)allTerminals.get(i + 1)).getText().equals("->")) continue;
            Token token = ((TerminalNode)allTerminals.get(i + 2)).getSymbol();
            painter.paintForeground(CONFIG, Range.create(token, token));
            configTokens.add(token);
        }
        return new ParseResult(configTokens, brokenConditions, functions);
    }

    private static void resetState(Stack<BranchingState> currentState) {
        currentState.clear();
        currentState.add(BranchingState.TRUE);
    }

    private static BranchingState getOverallState(Stack<BranchingState> currentState) {
        for (BranchingState value : currentState) {
            if (value != BranchingState.BROKEN) continue;
            return BranchingState.BROKEN;
        }
        for (BranchingState value : currentState) {
            if (value != BranchingState.FALSE) continue;
            return BranchingState.FALSE;
        }
        return BranchingState.TRUE;
    }

    @NotNull
    private static String getOrigin(ParserRuleContext ctx, String s) {
        Range range = new Range(ctx);
        return s.substring(range.getStart(), range.getStop());
    }

    static {
        log.configureDebugEnabled(false);
    }

    private static enum BranchingState {
        TRUE,
        FALSE,
        BROKEN;


        public static BranchingState valueOf(Boolean state) {
            if (state == null) {
                return BROKEN;
            }
            return state != false ? TRUE : FALSE;
        }

        public BranchingState flip() {
            switch (this) {
                case TRUE: {
                    return FALSE;
                }
                case FALSE: {
                    return TRUE;
                }
            }
            return BROKEN;
        }
    }
}

