/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.devexperts.logging.Logging;
import com.rusefi.ReaderProvider;
import com.rusefi.ReaderState;
import com.rusefi.ReaderStateImpl;
import com.rusefi.TriggerMetaGenerator;
import com.rusefi.ldmp.StateDictionaryGenerator;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.FileJavaFieldsConsumer;
import com.rusefi.output.FragmentDialogConsumer;
import com.rusefi.output.GaugeConsumer;
import com.rusefi.output.GetConfigValueConsumer;
import com.rusefi.output.GetOutputValueConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.OutputsSectionConsumer;
import com.rusefi.output.SdCardFieldsContent;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class LiveDataProcessor {
    private static final Logging log = Logging.getLogging(LiveDataProcessor.class);
    private static final String header = "// generated by gen_live_documentation.sh / LiveDataProcessor.java\n";
    private static final String enumContentFileName = "console/binary/generated/live_data_ids.h";
    private static final String tsOutputsDestination = "console/binary/";
    public static final String GAUGES = "console/binary/" + File.separator + "generated/gauges.ini";
    public static final String DATA_LOG_FILE_NAME = "console/binary/" + File.separator + "generated/data_logs.ini";
    public static final String OUTPUTS_SECTION_FILE_NAME = "console/binary/" + File.separator + "generated/output_channels.ini";
    public static final String DATA_FRAGMENTS_H = "console/binary/generated/live_data_fragments.h";
    public static final String STATE_DICTIONARY_FACTORY_JAVA = "../java_console/io/src/main/java/com/rusefi/enums/StateDictionaryFactory.java";
    public static final String FANCY_CONTENT_INI = "console/binary/generated/fancy_content.ini";
    public static final String FANCY_MENU_INI = "console/binary/generated/fancy_menu.ini";
    private final ReaderProvider readerProvider;
    private final LazyFile.LazyFileFactory fileFactory;
    private final GaugeConsumer gaugeConsumer;
    private final StringBuilder enumContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n#pragma once\n\ntypedef enum {\n");
    private final StringBuilder baseAddressCHeader = new StringBuilder();
    private final StringBuilder totalSensors = new StringBuilder();
    private final StringBuilder fancyNewStuff = new StringBuilder();
    public final StateDictionaryGenerator stateDictionaryGenerator;
    private final StringBuilder fancyNewMenu = new StringBuilder();
    private final StringBuilder fragmentsContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n");
    private final String extraPrepend = System.getProperty("LiveDataProcessor.extra_prepend");

    public LiveDataProcessor(String yamlFileName, ReaderProvider readerProvider, LazyFile.LazyFileFactory fileFactory) {
        this.readerProvider = readerProvider;
        this.fileFactory = fileFactory;
        this.stateDictionaryGenerator = new StateDictionaryGenerator(yamlFileName);
        this.gaugeConsumer = new GaugeConsumer(GAUGES, fileFactory);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.err.println("Four arguments expected: name of live data yaml input file and else but got " + Arrays.toString(args));
            System.exit(-1);
        }
        String yamlFileName = args[0];
        String definitionInputFileName = args[1];
        String headerFileName = args[2];
        String javaDestinationFileName = args[3];
        TriggerMetaGenerator.doJob(definitionInputFileName, headerFileName, javaDestinationFileName);
        Map<String, Object> data = LiveDataProcessor.getStringObjectMap(new FileReader(yamlFileName));
        LiveDataProcessor liveDataProcessor = new LiveDataProcessor(yamlFileName, ReaderProvider.REAL, LazyFile.REAL);
        int sensorTsPosition = liveDataProcessor.handleYaml(data);
        liveDataProcessor.end(sensorTsPosition);
    }

    public static Map<String, Object> getStringObjectMap(Reader reader) {
        Yaml yaml = new Yaml();
        return (Map)yaml.load(reader);
    }

    private void end(int sensorTsPosition) throws IOException {
        log.info("TS_TOTAL_OUTPUT_SIZE=" + sensorTsPosition);
        try (FileWriter fw = new FileWriter("console/binary/generated/total_live_data_generated.h");){
            fw.write(header);
            fw.write("#define TS_TOTAL_OUTPUT_SIZE " + sensorTsPosition);
        }
    }

    public int handleYaml(Map<String, Object> data) throws IOException {
        final JavaSensorsConsumer javaSensorsConsumer = new JavaSensorsConsumer();
        final OutputsSectionConsumer outputsSections = new OutputsSectionConsumer(OUTPUTS_SECTION_FILE_NAME, this.fileFactory);
        final DataLogConsumer dataLogConsumer = new DataLogConsumer(DATA_LOG_FILE_NAME, this.fileFactory);
        final SdCardFieldsContent sdCardFieldsConsumer = new SdCardFieldsContent();
        final GetOutputValueConsumer outputValueConsumer = new GetOutputValueConsumer("controllers/lua/generated/output_lookup_generated.cpp", this.fileFactory);
        EntryHandler handler = new EntryHandler(){

            @Override
            public void onEntry(String name, String javaName, String folder, String prepend, boolean withCDefines, String[] outputNames, String constexpr, String conditional, String engineModule, Boolean isPtr, String cppFileName) throws IOException {
                LiveDataProcessor.this.stateDictionaryGenerator.onEntry(name, javaName, folder, prepend, withCDefines, outputNames, constexpr, conditional, engineModule, isPtr, cppFileName);
                int startingPosition = javaSensorsConsumer.sensorTsPosition;
                log.info("Starting " + name + " at " + startingPosition + " with [" + conditional + "]");
                LiveDataProcessor.this.baseAddressCHeader.append("#define " + name.toUpperCase() + "_BASE_ADDRESS " + startingPosition + "\n");
                ReaderStateImpl state = new ReaderStateImpl(LiveDataProcessor.this.readerProvider, LiveDataProcessor.this.fileFactory);
                state.setDefinitionInputFile(folder + File.separator + name + ".txt");
                state.setWithC_Defines(withCDefines);
                outputsSections.outputNames = outputNames;
                dataLogConsumer.outputNames = outputNames;
                LiveDataProcessor.this.gaugeConsumer.outputNames = outputNames;
                state.addDestination(javaSensorsConsumer, outputsSections, dataLogConsumer);
                ArrayList<FragmentDialogConsumer> fragmentConsumers = new ArrayList<FragmentDialogConsumer>();
                for (int i = 0; i < LiveDataProcessor.tempLimit(outputNames); ++i) {
                    String variableNameSuffix = outputNames.length > 1 ? Integer.toString(i) : "";
                    FragmentDialogConsumer fragmentDialogConsumer = new FragmentDialogConsumer(name, variableNameSuffix);
                    fragmentConsumers.add(fragmentDialogConsumer);
                    state.addDestination(fragmentDialogConsumer);
                }
                if (LiveDataProcessor.this.extraPrepend != null) {
                    state.addPrepend(LiveDataProcessor.this.extraPrepend);
                }
                state.addPrepend(prepend);
                state.addCHeaderDestination(folder + File.separator + name + "_generated.h");
                int baseOffset = outputsSections.getBaseOffset();
                state.addDestination(new FileJavaFieldsConsumer(state, "../java_console/models/src/main/java/com/rusefi/config/generated/" + javaName, baseOffset, LiveDataProcessor.this.fileFactory));
                if (constexpr != null) {
                    sdCardFieldsConsumer.home = constexpr;
                    sdCardFieldsConsumer.conditional = conditional;
                    sdCardFieldsConsumer.isPtr = isPtr;
                    state.addDestination((state1, structure) -> sdCardFieldsConsumer.handleEndStruct(state1, structure));
                    outputValueConsumer.currentSectionPrefix = constexpr;
                    outputValueConsumer.moduleMode = false;
                    outputValueConsumer.conditional = conditional;
                    outputValueConsumer.isPtr = isPtr;
                    state.addDestination((state1, structure) -> outputValueConsumer.handleEndStruct(state1, structure));
                } else if (engineModule != null) {
                    outputValueConsumer.currentEngineModule = engineModule;
                    outputValueConsumer.moduleMode = true;
                    outputValueConsumer.conditional = conditional;
                    outputValueConsumer.isPtr = isPtr;
                    state.addDestination((state1, structure) -> outputValueConsumer.handleEndStruct(state1, structure));
                }
                state.addDestination(new ConfigurationConsumer(){

                    @Override
                    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
                        LiveDataProcessor.this.gaugeConsumer.handleEndStruct(readerState, structure);
                    }
                });
                state.doJob();
                for (FragmentDialogConsumer fragmentDialogConsumer : fragmentConsumers) {
                    LiveDataProcessor.this.fancyNewStuff.append(fragmentDialogConsumer.getContent());
                    LiveDataProcessor.this.fancyNewMenu.append(fragmentDialogConsumer.menuLine());
                }
                log.info("Done with " + name + " at " + javaSensorsConsumer.sensorTsPosition);
            }
        };
        ArrayList liveDocs = (ArrayList)data.get("Usages");
        for (LinkedHashMap entry : liveDocs) {
            String[] outputNamesArr;
            String name = (String)entry.get("name");
            String java = (String)entry.get("java");
            String folder = (String)entry.get("folder");
            String prepend = (String)entry.get("prepend");
            String constexpr = (String)entry.get("constexpr");
            String engineModule = (String)entry.get("engineModule");
            String cppFileName = (String)entry.get("cppFileName");
            if (cppFileName == null) {
                cppFileName = name;
            }
            String conditional = (String)entry.get("conditional_compilation");
            Boolean withCDefines = (Boolean)entry.get("withCDefines");
            Boolean isPtr = (Boolean)entry.get("isPtr");
            withCDefines = withCDefines != null && withCDefines != false;
            isPtr = isPtr != null && isPtr != false;
            Object outputNames = entry.get("output_name");
            if (outputNames == null) {
                outputNamesArr = new String[]{""};
            } else if (outputNames instanceof String) {
                outputNamesArr = new String[]{(String)outputNames};
            } else {
                ArrayList nameList = (ArrayList)outputNames;
                outputNamesArr = new String[nameList.size()];
                nameList.toArray(outputNamesArr);
            }
            handler.onEntry(name, java, folder, prepend, withCDefines, outputNamesArr, constexpr, conditional, engineModule, isPtr, cppFileName);
            String enumName = "LDS_" + name;
            String type = name + "_s";
            this.enumContent.append(enumName + ",\n");
            if (outputNamesArr.length < 2) {
                this.fragmentsContent.append("decl_frag<").append(type).append(">{},\n");
                continue;
            }
            for (int i = 0; i < outputNamesArr.length; ++i) {
                if (LiveDataProcessor.needComment(i)) {
                    this.fragmentsContent.append("// ");
                }
                this.fragmentsContent.append("decl_frag<").append(type).append(", ").append(i).append(">{},\t// ").append(outputNamesArr[i]).append("\n");
            }
        }
        this.enumContent.append("} live_data_e;\n");
        LazyFile lazyFile = this.fileFactory.create("console/binary_log/log_fields_generated.h");
        SdCardFieldsContent.wrapContent(lazyFile, sdCardFieldsConsumer.getBody());
        lazyFile.close();
        dataLogConsumer.endFile();
        outputValueConsumer.endFile();
        try (LazyFile fw = this.fileFactory.create("console/binary/generated/sensors.java");){
            fw.write(this.totalSensors.toString());
        }
        fw = this.fileFactory.create(FANCY_CONTENT_INI);
        try {
            fw.write(this.fancyNewStuff.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
        fw = this.fileFactory.create(FANCY_MENU_INI);
        try {
            fw.write(this.fancyNewMenu.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
        GetConfigValueConsumer.writeStringToFile(STATE_DICTIONARY_FACTORY_JAVA, this.stateDictionaryGenerator.getCompleteClass(), this.fileFactory);
        this.totalSensors.append(javaSensorsConsumer.getContent());
        this.writeFiles();
        return javaSensorsConsumer.sensorTsPosition;
    }

    private void writeFiles() throws IOException {
        this.gaugeConsumer.endFile();
        try (LazyFile fw = this.fileFactory.create(enumContentFileName);){
            fw.write(this.enumContent.toString());
            fw.write(this.baseAddressCHeader.toString());
        }
        fw = this.fileFactory.create(DATA_FRAGMENTS_H);
        try {
            fw.write(this.fragmentsContent.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public static int tempLimit(String[] outputs) {
        return 1;
    }

    public static boolean needComment(int index) {
        return index > 0;
    }

    static interface EntryHandler {
        public void onEntry(String var1, String var2, String var3, String var4, boolean var5, String[] var6, String var7, String var8, String var9, Boolean var10, String var11) throws IOException;
    }
}

