/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config;

public enum FieldType {
    INT8(1),
    INT16(2),
    INT(4),
    UINT8(1),
    UINT16(2),
    BIT(4),
    FLOAT(4),
    STRING(0);

    public static final String INT_TYPE_STRING = "int";
    public static final String FLOAT_TYPE_STRING = "float";
    public static final String BYTE_TYPE_STRING = "byte";
    public static final String UBYTE_TYPE_STRING = "ubyte";
    public static final String SHORT_TYPE_STRING = "short";
    public static final String USHORT_TYPE_STRING = "ushort";
    private final int storageSize;

    private FieldType(int storageSize) {
        this.storageSize = storageSize;
    }

    private String getTypeForCommand() {
        switch (this) {
            case FLOAT: {
                return FLOAT_TYPE_STRING;
            }
            case INT16: {
                return SHORT_TYPE_STRING;
            }
            case UINT16: {
                return USHORT_TYPE_STRING;
            }
            case INT8: {
                return BYTE_TYPE_STRING;
            }
            case UINT8: {
                return UBYTE_TYPE_STRING;
            }
        }
        return INT_TYPE_STRING;
    }

    public static FieldType parseTs(String type) {
        if (type.equalsIgnoreCase("f32")) {
            return FLOAT;
        }
        if (type.equalsIgnoreCase("s32") || type.equalsIgnoreCase("u32")) {
            return INT;
        }
        if (type.equalsIgnoreCase("s16")) {
            return INT16;
        }
        if (type.equalsIgnoreCase("u16")) {
            return UINT16;
        }
        if (type.equalsIgnoreCase("s08")) {
            return INT8;
        }
        if (type.equalsIgnoreCase("u08")) {
            return UINT8;
        }
        throw new IllegalStateException(type);
    }

    public String getLoadCommand() {
        return "get_" + this.getTypeForCommand();
    }

    public String getStoreCommand() {
        return "set_" + this.getTypeForCommand();
    }

    public int getStorageSize() {
        if (this == STRING) {
            throw new UnsupportedOperationException("storage size is unclear on " + this);
        }
        return this.storageSize;
    }

    public boolean isString() {
        return this == STRING;
    }
}

