/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public enum BackgroundImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private BackgroundColor radBackgroundColor = BackgroundColor.DARK_GRAY;
    private Paint radCustomBackground = null;
    private BufferedImage radBackgroundImage = this.UTIL.createImage(1, 1, 3);
    private Color radTextureColor = new Color(0x686868);
    private int linWidth = 0;
    private int linHeight = 0;
    private BackgroundColor linBackgroundColor = BackgroundColor.DARK_GRAY;
    private Paint linCustomBackground = null;
    private BufferedImage linBackgroundImage = this.UTIL.createImage(1, 1, 3);
    private Color linTextureColor = new Color(0x686868);
    private final Color DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
    private final Color BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
    public final BufferedImage STAINLESS_GRINDED_TEXTURE = this.UTIL.create_STAINLESS_STEEL_PLATE_Texture(100);
    public final BufferedImage CARBON_FIBRE_TEXTURE = this.UTIL.create_CARBON_Texture(12);
    private BufferedImage punchedSheetTexture = this.UTIL.create_PUNCHED_SHEET_Image(12, new Color(1909027));

    public BufferedImage createRadialBackground(int n, BackgroundColor backgroundColor) {
        return this.createRadialBackground(n, backgroundColor, null);
    }

    public BufferedImage createRadialBackground(int n, BackgroundColor backgroundColor, Paint paint) {
        return this.createRadialBackground(n, backgroundColor, paint, null, null);
    }

    public BufferedImage createRadialBackground(int n, BackgroundColor backgroundColor, Paint paint, Color color, BufferedImage bufferedImage) {
        Color[] colorArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == n && this.radBackgroundColor == backgroundColor && this.radCustomBackground.equals(paint) && this.radTextureColor.equals(color)) {
            if (bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.radBackgroundImage, 0, 0, null);
                graphics2D.dispose();
            }
            return this.radBackgroundImage;
        }
        this.radBackgroundImage.flush();
        this.radBackgroundImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radBackgroundImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = n;
        int n3 = n;
        boolean bl = false;
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        if (double_2.equals(double_3)) {
            ((Point2D)double_3).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        if (paint != null && backgroundColor == BackgroundColor.CUSTOM) {
            graphics2D.setPaint(paint);
        } else {
            object4 = new Color[]{backgroundColor.GRADIENT_START_COLOR, backgroundColor.GRADIENT_FRACTION_COLOR, backgroundColor.GRADIENT_STOP_COLOR};
            if (backgroundColor == BackgroundColor.BRUSHED_METAL) {
                object3 = new TexturePaint(this.UTIL.createBrushMetalTexture(color, double_.getBounds().width, double_.getBounds().height), double_.getBounds());
            } else if (backgroundColor == BackgroundColor.STAINLESS) {
                object2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
                object = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                colorArray = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                object3 = new ConicalGradientPaint(false, (Point2D)object2, -0.45f, (float[])object, colorArray);
            } else if (backgroundColor == BackgroundColor.STAINLESS_GRINDED) {
                object3 = new TexturePaint(this.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (backgroundColor == BackgroundColor.CARBON) {
                object3 = new TexturePaint(this.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (backgroundColor == BackgroundColor.PUNCHED_SHEET) {
                object3 = new TexturePaint(this.punchedSheetTexture, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (backgroundColor == BackgroundColor.LINEN) {
                object3 = new TexturePaint(this.UTIL.createLinenTexture(color, double_.getBounds().width, double_.getBounds().height), double_.getBounds());
            } else if (backgroundColor == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)double_2).setLocation(0.0, double_.getMinY());
                ((Point2D)double_3).setLocation(0.0, double_.getMaxY());
                if (double_2.equals(double_3)) {
                    ((Point2D)double_3).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
                }
                object2 = new float[]{0.0f, 1.0f};
                object = new Color[]{this.UTIL.lighter(color, 0.15f), this.UTIL.darker(color, 0.15f)};
                object3 = new LinearGradientPaint(double_2, double_3, (float[])object2, (Color[])object);
            } else {
                object3 = new LinearGradientPaint(double_2, double_3, fArray, (Color[])object4);
            }
            graphics2D.setPaint((Paint)object3);
        }
        graphics2D.fill(double_);
        if (backgroundColor == BackgroundColor.NOISY_PLASTIC) {
            object4 = new Random();
            object3 = new Random();
            object2 = graphics2D.getClip();
            graphics2D.setClip(double_);
            int n4 = 0;
            while ((double)n4 < ((RectangularShape)double_).getHeight()) {
                int n5 = 0;
                while ((double)n5 < ((RectangularShape)double_).getWidth()) {
                    object = ((Random)object4).nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int n6 = 10 + object3.nextInt(10) - 5;
                    graphics2D.setColor(new Color(object.getRed(), object.getGreen(), object.getBlue(), n6));
                    graphics2D.drawLine((int)((double)n5 + double_.getMinX()), (int)((double)n4 + double_.getMinY()), (int)((double)n5 + double_.getMinX()), (int)((double)n4 + double_.getMinY()));
                    ++n5;
                }
                ++n4;
            }
            graphics2D.setClip((Shape)object2);
        }
        if (bl) {
            object4 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            object3 = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            object2 = new LinearGradientPaint(new Point2D.Double(double_.getMinX(), 0.0), new Point2D.Double(double_.getMaxX(), 0.0), (float[])object4, (Color[])object3);
            graphics2D.setPaint((Paint)object2);
            graphics2D.fill(double_);
        }
        object4 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        object3 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        object2 = new float[]{0.0f, 0.7f, 0.71f, 0.86f, 0.92f, 0.97f, 1.0f};
        object = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.03f), new Color(0.0f, 0.0f, 0.0f, 0.07f), new Color(0.0f, 0.0f, 0.0f, 0.15f), new Color(0.0f, 0.0f, 0.0f, 0.3f)};
        colorArray = new RadialGradientPaint((Point2D)object3, (float)(0.4158878504672897 * (double)n2), (float[])object2, (Color[])object);
        graphics2D.setPaint((Paint)colorArray);
        graphics2D.fill((Shape)object4);
        if (backgroundColor != BackgroundColor.TRANSPARENT) {
            graphics2D.fill((Shape)object4);
        }
        graphics2D.dispose();
        if (bufferedImage != null) {
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.drawImage((Image)this.radBackgroundImage, 0, 0, null);
            graphics2D2.dispose();
        }
        this.radWidth = n;
        this.radBackgroundColor = backgroundColor;
        this.radCustomBackground = paint;
        this.radTextureColor = color;
        return this.radBackgroundImage;
    }

    public BufferedImage createLinearBackground(int n, int n2, BackgroundColor backgroundColor) {
        return this.createLinearBackground(n, n2, backgroundColor, null);
    }

    public BufferedImage createLinearBackground(int n, int n2, BackgroundColor backgroundColor, Paint paint) {
        return this.createLinearBackground(n, n2, backgroundColor, paint, null, null);
    }

    public BufferedImage createLinearBackground(int n, int n2, BackgroundColor backgroundColor, Paint paint, Color color, BufferedImage bufferedImage) {
        Object object;
        Color[] colorArray;
        Object object2;
        Object object3;
        if (n <= 32 || n2 <= 32) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == n && this.linHeight == n2 && this.linBackgroundColor == backgroundColor && this.linCustomBackground.equals(paint) && this.linTextureColor.equals(color)) {
            if (bufferedImage != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.linBackgroundImage, 0, 0, null);
                graphics2D.dispose();
            }
            return this.linBackgroundImage;
        }
        this.linBackgroundImage.flush();
        this.linBackgroundImage = this.UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = this.linBackgroundImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = n;
        int n4 = n2;
        boolean bl = false;
        double d = n3 >= n4 ? (double)n4 * 0.05 : (double)n3 * 0.05;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        double d2 = n3 >= n4 ? d - (((RectangularShape)double_).getHeight() - (double)n4 - 2.0) / 2.0 : d - (((RectangularShape)double_).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        double d3 = n3 >= n4 ? (double)n4 * 0.02857143 : (double)n3 * 0.02857143;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, d3, d3);
        double d4 = d3 - 1.0;
        RoundRectangle2D.Double double_4 = new RoundRectangle2D.Double(((RectangularShape)double_3).getX() + 1.0, ((RectangularShape)double_3).getY() + 1.0, ((RectangularShape)double_3).getWidth() - 2.0, ((RectangularShape)double_3).getHeight() - 2.0, d4, d4);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        if (double_5.equals(double_6)) {
            ((Point2D)double_6).setLocation(0.0, ((Point2D)double_5).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Paint paint2 = null;
        if (paint != null && backgroundColor == BackgroundColor.CUSTOM) {
            graphics2D.setPaint(paint);
        } else {
            object3 = new Color[]{backgroundColor.GRADIENT_START_COLOR, backgroundColor.GRADIENT_FRACTION_COLOR, backgroundColor.GRADIENT_STOP_COLOR};
            if (backgroundColor == BackgroundColor.BRUSHED_METAL) {
                paint2 = new TexturePaint(this.UTIL.createBrushMetalTexture(color, double_4.getBounds().width, double_4.getBounds().height), double_4.getBounds());
            } else if (backgroundColor == BackgroundColor.STAINLESS) {
                paint2 = new TexturePaint(this.UTIL.createBrushMetalTexture(new Color(7237232), double_4.getBounds().width, double_4.getBounds().height, 5, 0.03f, true, 0.5f), double_4.getBounds());
            } else if (backgroundColor == BackgroundColor.STAINLESS_GRINDED) {
                paint2 = new TexturePaint(this.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (backgroundColor == BackgroundColor.CARBON) {
                paint2 = new TexturePaint(this.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (backgroundColor == BackgroundColor.PUNCHED_SHEET) {
                paint2 = new TexturePaint(this.punchedSheetTexture, new Rectangle(0, 0, 12, 12));
                bl = true;
            } else if (backgroundColor == BackgroundColor.LINEN) {
                paint2 = new TexturePaint(this.UTIL.createLinenTexture(color, double_4.getBounds().width, double_4.getBounds().height), double_4.getBounds());
            } else if (backgroundColor == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)double_5).setLocation(0.0, double_4.getMinY());
                ((Point2D)double_6).setLocation(0.0, double_4.getMaxY());
                if (double_5.equals(double_6)) {
                    ((Point2D)double_6).setLocation(0.0, ((Point2D)double_5).getY() + 1.0);
                }
                object2 = new float[]{0.0f, 1.0f};
                colorArray = new Color[]{this.UTIL.lighter(color, 0.15f), this.UTIL.darker(color, 0.15f)};
                paint2 = new LinearGradientPaint(double_5, double_6, (float[])object2, colorArray);
            } else {
                paint2 = new LinearGradientPaint(double_5, double_6, fArray, (Color[])object3);
            }
            graphics2D.setPaint(paint2);
        }
        graphics2D.fill(double_4);
        object3 = paint != null && backgroundColor == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(double_4, paint, 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(double_4, paint2, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)object3, double_4.getBounds().x, double_4.getBounds().y, null);
        if (backgroundColor == BackgroundColor.NOISY_PLASTIC) {
            object2 = new Random();
            colorArray = new Random();
            object = graphics2D.getClip();
            graphics2D.setClip(double_4);
            int n5 = 0;
            while ((double)n5 < ((RectangularShape)double_4).getHeight()) {
                int n6 = 0;
                while ((double)n6 < ((RectangularShape)double_4).getWidth()) {
                    Color color2 = ((Random)object2).nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int n7 = 10 + colorArray.nextInt(10) - 5;
                    graphics2D.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n7));
                    graphics2D.drawLine((int)((double)n6 + double_4.getMinX()), (int)((double)n5 + double_4.getMinY()), (int)((double)n6 + double_4.getMinX()), (int)((double)n5 + double_4.getMinY()));
                    ++n6;
                }
                ++n5;
            }
            graphics2D.setClip((Shape)object);
        }
        if (bl) {
            object2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.5f)};
            object = new LinearGradientPaint(new Point2D.Double(double_4.getMinX(), 0.0), new Point2D.Double(double_4.getMaxX(), 0.0), (float[])object2, colorArray);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(double_4);
        }
        graphics2D.dispose();
        if (bufferedImage != null) {
            object2 = bufferedImage.createGraphics();
            ((Graphics)object2).drawImage(this.linBackgroundImage, 0, 0, null);
            ((Graphics)object2).dispose();
        }
        this.linWidth = n;
        this.linHeight = n2;
        this.linBackgroundColor = backgroundColor;
        this.linCustomBackground = paint;
        this.linTextureColor = color;
        return this.linBackgroundImage;
    }

    public BufferedImage getPunchedSheetTexture() {
        return this.punchedSheetTexture;
    }

    public void recreatePunchedSheetTexture(Color color) {
        if (this.punchedSheetTexture != null) {
            this.punchedSheetTexture.flush();
        }
        this.punchedSheetTexture = this.UTIL.create_PUNCHED_SHEET_Image(12, color);
    }

    public String toString() {
        return "BackgroundImageFactory";
    }
}

