/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public enum PointerImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private PointerType radPointerType = PointerType.TYPE1;
    private ColorDef radPointerColor = null;
    private CustomColorDef radCustomPointerColor = new CustomColorDef(Color.RED);
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private BufferedImage radPointerImage = this.UTIL.createImage(1, 1, 3);
    private int radWidthShadow = 0;
    private PointerType radPointerTypeShadow = PointerType.TYPE1;
    private BufferedImage radPointerShadowImage = this.UTIL.createImage(1, 1, 3);

    public BufferedImage createStandardPointer(int n, PointerType pointerType, ColorDef colorDef, BackgroundColor backgroundColor) {
        return this.createStandardPointer(n, pointerType, colorDef, null, backgroundColor);
    }

    public BufferedImage createStandardPointer(int n, PointerType pointerType, ColorDef colorDef, CustomColorDef customColorDef, BackgroundColor backgroundColor) {
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == n && this.radPointerType == pointerType && this.radPointerColor == colorDef && this.radCustomPointerColor == customColorDef && this.backgroundColor == backgroundColor) {
            return this.radPointerImage;
        }
        this.radPointerImage.flush();
        this.radPointerImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radPointerImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = this.radPointerImage.getWidth();
        int n3 = this.radPointerImage.getHeight();
        switch (pointerType) {
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                float[] fArray = new float[]{0.0f, 0.36f, 0.3601f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{backgroundColor.LABEL_COLOR, backgroundColor.LABEL_COLOR, colorDef.LIGHT, colorDef.LIGHT} : new Color[]{backgroundColor.LABEL_COLOR, backgroundColor.LABEL_COLOR, customColorDef.LIGHT, customColorDef.LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                GeneralPath generalPath = new GeneralPath(new Rectangle2D.Double((double)n2 * 0.4953271028037383, (double)n3 * 0.1308411214953271, (double)n2 * 0.009345794392523364, (double)n3 * 0.37383177570093457));
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setColor(colorDef.LIGHT);
                } else {
                    graphics2D.setColor(customColorDef.LIGHT);
                }
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.1261682242990654);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1261682242990654);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_3 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.51f, 0.52f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.DARK, colorDef.DARK, colorDef.LIGHT, colorDef.LIGHT} : new Color[]{customColorDef.DARK, customColorDef.DARK, customColorDef.LIGHT, customColorDef.LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_3, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_4 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.LIGHT, colorDef.LIGHT, colorDef.MEDIUM, colorDef.MEDIUM} : new Color[]{customColorDef.LIGHT, customColorDef.LIGHT, customColorDef.MEDIUM, customColorDef.MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_4, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setColor(colorDef.DARK);
                } else {
                    graphics2D.setColor(customColorDef.DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.3878504672897196);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.3878504672897196);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.48598130841121495);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMaxY(), 0.0);
                Point2D.Double double_5 = new Point2D.Double(generalPath.getBounds2D().getMinY(), 0.0);
                float[] fArray = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.LIGHT, colorDef.MEDIUM, colorDef.MEDIUM, colorDef.LIGHT} : new Color[]{customColorDef.LIGHT, customColorDef.MEDIUM, customColorDef.MEDIUM, customColorDef.LIGHT};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_5, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setColor(colorDef.DARK);
                } else {
                    graphics2D.setColor(customColorDef.DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_6 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.DARK, colorDef.MEDIUM} : new Color[]{customColorDef.DARK, customColorDef.MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_6, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.4672897196261682, (double)n3 * 0.5, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_7 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.46f, 0.47f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.LIGHT, colorDef.LIGHT, colorDef.MEDIUM, colorDef.MEDIUM} : new Color[]{customColorDef.LIGHT, customColorDef.LIGHT, customColorDef.MEDIUM, customColorDef.MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_7, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setColor(colorDef.DARK);
                } else {
                    graphics2D.setColor(customColorDef.DARK);
                }
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2336448598130841);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.4392523364485981);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4392523364485981);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5280373831775701, (double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757, (double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.6074766355140186, (double)n2 * 0.48130841121495327, (double)n3 * 0.6074766355140186, (double)n2 * 0.5, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.6074766355140186, (double)n2 * 0.5233644859813084, (double)n3 * 0.6074766355140186, (double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757, (double)n2 * 0.5280373831775701, (double)n3 * 0.5280373831775701, (double)n2 * 0.5280373831775701, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_8 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.48f, 1.0f};
                Color[] colorArray = new Color[]{new Color(50, 50, 50, 255), new Color(102, 102, 102, 255), new Color(50, 50, 50, 255)};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_8, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(new Color(0x2E2E2E));
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.setWindingRule(0);
                generalPath2.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.21962616822429906);
                generalPath2.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.21962616822429906);
                generalPath2.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.13551401869158877);
                generalPath2.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.13551401869158877);
                generalPath2.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.21962616822429906);
                generalPath2.closePath();
                graphics2D.setColor(colorDef.MEDIUM);
                graphics2D.fill(generalPath2);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4439252336448598, (double)n3 * 0.49065420560747663, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5327102803738317, (double)n2 * 0.4672897196261682, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5560747663551402, (double)n2 * 0.5560747663551402, (double)n3 * 0.5327102803738317, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
                Point2D.Double double_9 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
                float[] fArray = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.LIGHT, colorDef.LIGHT, colorDef.MEDIUM, colorDef.MEDIUM} : new Color[]{customColorDef.LIGHT, customColorDef.LIGHT, customColorDef.MEDIUM, customColorDef.MEDIUM};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_9, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(colorDef.MEDIUM);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3);
                generalPath.curveTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3, 0.48130841121495327 * (double)n2, 0.5841121495327103 * (double)n3, 0.5 * (double)n2, 0.5841121495327103 * (double)n3);
                generalPath.curveTo(0.514018691588785 * (double)n2, 0.5841121495327103 * (double)n3, 0.5093457943925234 * (double)n2, 0.5 * (double)n3, 0.5093457943925234 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                if (colorDef != ColorDef.CUSTOM) {
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Double(0.0, generalPath.getBounds2D().getMinY()), new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY()), new float[]{0.0f, 1.0f}, new Color[]{colorDef.MEDIUM, colorDef.DARK});
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(colorDef.VERY_DARK);
                } else {
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Double(0.0, generalPath.getBounds2D().getMinY()), new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY()), new float[]{0.0f, 1.0f}, new Color[]{customColorDef.MEDIUM, customColorDef.DARK});
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(customColorDef.VERY_DARK);
                }
                graphics2D.setStroke(new BasicStroke(0.004672897f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.5046728971962616 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.16822429906542055 * (double)n3), new Point2D.Double(0.5 * (double)n2, 0.5046728971962616 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{colorDef.MEDIUM, colorDef.DARK}));
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(colorDef.VERY_DARK);
                } else {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.16822429906542055 * (double)n3), new Point2D.Double(0.5 * (double)n2, 0.5046728971962616 * (double)n3), new float[]{0.0f, 1.0f}, new Color[]{customColorDef.MEDIUM, customColorDef.DARK}));
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(customColorDef.VERY_DARK);
                }
                graphics2D.setStroke(new BasicStroke(0.004672897f * (float)n2, 0, 1));
                graphics2D.draw(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.1308411214953271 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3), new Point2D.Double(0.5 * (double)n2, 0.1308411214953271 * (double)n3), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{backgroundColor.LABEL_COLOR, backgroundColor.LABEL_COLOR, colorDef.MEDIUM, colorDef.MEDIUM}));
                } else {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3), new Point2D.Double(0.5 * (double)n2, 0.1308411214953271 * (double)n3), new float[]{0.0f, 0.849999f, 0.85f, 1.0f}, new Color[]{backgroundColor.LABEL_COLOR, backgroundColor.LABEL_COLOR, customColorDef.MEDIUM, customColorDef.MEDIUM}));
                }
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.1308411214953271 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                if (colorDef != ColorDef.CUSTOM) {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.48598130841121495 * (double)n2, 0.0), new Point2D.Double(0.5093457943925234 * (double)n3, 0.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{colorDef.VERY_DARK, colorDef.LIGHT, colorDef.VERY_DARK}));
                } else {
                    graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.48598130841121495 * (double)n2, 0.0), new Point2D.Double(0.5093457943925234 * (double)n3, 0.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{customColorDef.VERY_DARK, customColorDef.LIGHT, customColorDef.VERY_DARK}));
                }
                graphics2D.fill(generalPath);
                break;
            }
            default: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
                Point2D.Double double_10 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
                float[] fArray = new float[]{0.0f, 0.3f, 0.6f, 1.0f};
                Color[] colorArray = colorDef != ColorDef.CUSTOM ? new Color[]{colorDef.VERY_DARK, colorDef.MEDIUM, colorDef.MEDIUM, colorDef.VERY_DARK} : new Color[]{customColorDef.VERY_DARK, customColorDef.MEDIUM, customColorDef.MEDIUM, customColorDef.VERY_DARK};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_10, fArray, colorArray);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fill(generalPath);
                graphics2D.setColor(colorDef.LIGHT);
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
                graphics2D.draw(generalPath);
            }
        }
        graphics2D.dispose();
        this.radWidth = n;
        this.radPointerType = pointerType;
        this.radPointerColor = colorDef;
        this.backgroundColor = backgroundColor;
        this.radCustomPointerColor = customColorDef;
        return this.radPointerImage;
    }

    public BufferedImage createStandardPointerShadow(int n, PointerType pointerType) {
        if (n <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidthShadow == n && this.radPointerTypeShadow == pointerType) {
            return this.radPointerShadowImage;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        this.radPointerShadowImage.flush();
        this.radPointerShadowImage = this.UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = this.radPointerShadowImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = this.radPointerShadowImage.getWidth();
        int n3 = this.radPointerShadowImage.getHeight();
        switch (pointerType) {
            case TYPE1: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
                generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE2: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.3411214953271028);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.46261682242990654);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
                generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE3: {
                break;
            }
            case TYPE4: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.1261682242990654);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757);
                generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757);
                generalPath.lineTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.13551401869158877);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1261682242990654);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE5: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.4953271028037383);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.4953271028037383);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE6: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.3878504672897196);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.3878504672897196);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3177570093457944);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.3925233644859813);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.48598130841121495);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.48598130841121495);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE8: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5, (double)n2 * 0.5093457943925234, (double)n3 * 0.45794392523364486, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.45794392523364486, (double)n2 * 0.4672897196261682, (double)n3 * 0.5, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
                generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.5327102803738317);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE9: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841);
                generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2336448598130841);
                generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.4392523364485981);
                generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4392523364485981);
                generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841);
                generalPath.closePath();
                generalPath.moveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5280373831775701);
                generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.5280373831775701, (double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757, (double)n2 * 0.4766355140186916, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.6074766355140186, (double)n2 * 0.48130841121495327, (double)n3 * 0.6074766355140186, (double)n2 * 0.5, (double)n3 * 0.6074766355140186);
                generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.6074766355140186, (double)n2 * 0.5233644859813084, (double)n3 * 0.6074766355140186, (double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757);
                generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.602803738317757, (double)n2 * 0.5280373831775701, (double)n3 * 0.5280373831775701, (double)n2 * 0.5280373831775701, (double)n3 * 0.5280373831775701);
                generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.4719626168224299);
                generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.1308411214953271);
                generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.1308411214953271);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE10: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.4439252336448598, (double)n3 * 0.49065420560747663, (double)n2 * 0.4439252336448598, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.4439252336448598, (double)n3 * 0.5327102803738317, (double)n2 * 0.4672897196261682, (double)n3 * 0.5560747663551402, (double)n2 * 0.5, (double)n3 * 0.5560747663551402);
                generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.5560747663551402, (double)n2 * 0.5560747663551402, (double)n3 * 0.5327102803738317, (double)n2 * 0.5560747663551402, (double)n3 * 0.5);
                generalPath.curveTo((double)n2 * 0.5560747663551402, (double)n3 * 0.49065420560747663, (double)n2 * 0.5, (double)n3 * 0.14953271028037382, (double)n2 * 0.5, (double)n3 * 0.14953271028037382);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3);
                generalPath.curveTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3, 0.48130841121495327 * (double)n2, 0.5841121495327103 * (double)n3, 0.5 * (double)n2, 0.5841121495327103 * (double)n3);
                generalPath.curveTo(0.514018691588785 * (double)n2, 0.5841121495327103 * (double)n3, 0.5093457943925234 * (double)n2, 0.5 * (double)n3, 0.5093457943925234 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE12: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.5046728971962616 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.1308411214953271 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
            case TYPE14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                generalPath.moveTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5 * (double)n2, 0.1308411214953271 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.lineTo(0.5093457943925234 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.5093457943925234 * (double)n3);
                generalPath.lineTo(0.48598130841121495 * (double)n2, 0.16822429906542055 * (double)n3);
                generalPath.closePath();
                graphics2D.setColor(color);
                graphics2D.fill(generalPath);
                break;
            }
        }
        graphics2D.dispose();
        this.radWidthShadow = n;
        this.radPointerTypeShadow = pointerType;
        return this.radPointerShadowImage;
    }

    public String toString() {
        return "PointerImageFactory";
    }
}

