/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.proxy.client;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.IoStream;
import com.rusefi.io.commands.GetOutputsCommand;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.serial.StreamStatistics;
import com.rusefi.io.tcp.BinaryProtocolProxy;
import com.rusefi.io.tcp.ServerSocketReference;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.proxy.client.IncompatibleBackendException;
import com.rusefi.proxy.client.LocalApplicationProxyContext;
import com.rusefi.proxy.client.UpdateType;
import com.rusefi.server.ApplicationRequest;
import com.rusefi.server.rusEFISSLContext;
import com.rusefi.tools.online.HttpUtil;
import com.rusefi.tools.online.ProxyClient;
import com.rusefi.ui.StatusConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class LocalApplicationProxy
implements Closeable {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("gauge poking", true);
    private static final Logging log = Logging.getLogging(LocalApplicationProxy.class);
    public static final int SERVER_PORT_FOR_APPLICATIONS = HttpUtil.getIntProperty("applications.port", 8002);
    private final ApplicationRequest applicationRequest;
    private final ServerSocketReference serverHolder;
    private final IoStream authenticatorToProxyStream;

    public LocalApplicationProxy(ApplicationRequest applicationRequest, ServerSocketReference serverHolder, IoStream authenticatorToProxyStream) {
        this.applicationRequest = applicationRequest;
        this.serverHolder = serverHolder;
        this.authenticatorToProxyStream = authenticatorToProxyStream;
    }

    public IoStream getAuthenticatorToProxyStream() {
        return this.authenticatorToProxyStream;
    }

    public static HttpResponse requestSoftwareUpdate(int httpPort, ApplicationRequest applicationRequest, UpdateType type) throws IOException {
        HttpPost httpPost = new HttpPost(ProxyClient.getHttpAddress(httpPort) + "/update_connector_software");
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
        form.add(new BasicNameValuePair("json", applicationRequest.toJson()));
        form.add(new BasicNameValuePair("type", type.name()));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, Consts.UTF_8);
        httpPost.setEntity(entity);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        return httpclient.execute(httpPost);
    }

    public ApplicationRequest getApplicationRequest() {
        return this.applicationRequest;
    }

    public static ServerSocketReference startAndRun(LocalApplicationProxyContext context, ApplicationRequest applicationRequest, int jsonHttpPort, TcpIoStream.DisconnectListener disconnectListener, ConnectionListener connectionListener) throws IOException {
        String version = context.executeGet(ProxyClient.getHttpAddress(jsonHttpPort) + "/version");
        log.info("Server says version=" + version);
        if (!version.contains("0.0005")) {
            String message = "Unexpected backend version " + version + " while we want 0.0005";
            log.error(message);
            System.out.println(message);
            throw new IncompatibleBackendException(message);
        }
        TcpIoStream authenticatorToProxyStream = new TcpIoStream("authenticatorToProxyStream ", rusEFISSLContext.getSSLSocket(HttpUtil.RUSEFI_PROXY_HOSTNAME, context.serverPortForRemoteApplications()), disconnectListener);
        LocalApplicationProxy.sendHello(authenticatorToProxyStream, applicationRequest);
        AtomicLong lastActivity = new AtomicLong(System.currentTimeMillis());
        BinaryProtocolProxy.ClientApplicationActivityListener clientApplicationActivityListener = () -> lastActivity.set(System.currentTimeMillis());
        THREAD_FACTORY.newThread(() -> {
            try {
                while (true) {
                    BinaryProtocol.sleep(context.gaugePokingPeriod());
                    if (LocalApplicationProxy.isTimeForApplicationToConnect(lastActivity.get(), 2500)) {
                        byte[] commandPacket = new byte[5];
                        commandPacket[0] = 79;
                        System.arraycopy(GetOutputsCommand.createRequest(), 0, commandPacket, 1, 4);
                        authenticatorToProxyStream.sendAndGetPacket(commandPacket, "Gauge Poker");
                    }
                    if (!LocalApplicationProxy.isTimeForApplicationToConnect(lastActivity.get(), context.startUpIdle())) continue;
                    authenticatorToProxyStream.close();
                    disconnectListener.onDisconnect("Giving up connection");
                }
            }
            catch (IOException e) {
                log.error("Gauge poker", e);
                return;
            }
        }).start();
        ServerSocketReference serverHolder = BinaryProtocolProxy.createProxy(authenticatorToProxyStream, context.authenticatorPort(), clientApplicationActivityListener, StatusConsumer.ANONYMOUS);
        LocalApplicationProxy localApplicationProxy = new LocalApplicationProxy(applicationRequest, serverHolder, authenticatorToProxyStream);
        connectionListener.onConnected(localApplicationProxy, authenticatorToProxyStream);
        return serverHolder;
    }

    private static boolean isTimeForApplicationToConnect(long start, int idle) {
        return System.currentTimeMillis() - start > (long)idle;
    }

    public static void sendHello(IoStream authenticatorToProxyStream, ApplicationRequest applicationRequest) throws IOException {
        log.info("Pushing " + applicationRequest);
        new HelloCommand(applicationRequest.toJson()).handle(authenticatorToProxyStream);
    }

    public static void start() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void close() {
        this.serverHolder.close();
        byte[] request = new byte[]{122, 14};
        try {
            this.authenticatorToProxyStream.sendPacket(request);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.authenticatorToProxyStream.close();
    }

    public static interface ConnectionListener {
        public static final ConnectionListener VOID = (localApplicationProxy, authenticatorToProxyStream) -> {};

        public void onConnected(LocalApplicationProxy var1, StreamStatistics var2);
    }
}

