/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.Shadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class LightBulb
extends JComponent {
    public static final String STATE_PROPERTY = "state";
    private boolean on;
    private float alpha;
    private int direction;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 114, 114);
    private final Point2D CENTER;
    private Color glowColor;
    private BufferedImage offImage;
    private BufferedImage onImage;
    private BufferedImage bulbImage;
    private int horizontalAlignment;
    private int verticalAlignment;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = LightBulb.this.getWidth() <= LightBulb.this.getHeight() ? LightBulb.this.getWidth() : LightBulb.this.getHeight();
            Container container = LightBulb.this.getParent();
            if (container != null && container.getLayout() == null) {
                if (n < LightBulb.this.getMinimumSize().width || n < LightBulb.this.getMinimumSize().height) {
                    LightBulb.this.setSize(LightBulb.this.getMinimumSize());
                } else {
                    LightBulb.this.setSize(n, n);
                }
            } else if (n < LightBulb.this.getMinimumSize().width || n < LightBulb.this.getMinimumSize().height) {
                LightBulb.this.setPreferredSize(LightBulb.this.getMinimumSize());
            } else {
                LightBulb.this.setPreferredSize(new Dimension(n, n));
            }
            LightBulb.this.calcInnerBounds();
            LightBulb.this.init(((LightBulb)LightBulb.this).getInnerBounds().width, ((LightBulb)LightBulb.this).getInnerBounds().height);
        }
    };

    public LightBulb() {
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.offImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.onImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.bulbImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.alpha = 1.0f;
        this.direction = 1;
        this.glowColor = new Color(1.0f, 1.0f, 0.0f);
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        if (this.offImage != null) {
            this.offImage.flush();
        }
        this.offImage = this.createOffImage(n, n2);
        if (this.onImage != null) {
            this.onImage.flush();
        }
        this.onImage = this.createOnImage(n, n2, this.glowColor);
        if (this.bulbImage != null) {
            this.bulbImage.flush();
        }
        this.bulbImage = this.createBulbImage(n, n2);
        this.CENTER.setLocation((double)n / 2.0, (double)n2 / 2.0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        switch (this.direction) {
            case 5: {
                graphics2D.rotate(Math.PI, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
            case 3: {
                graphics2D.rotate(-1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
            case 7: {
                graphics2D.rotate(1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
            }
        }
        graphics2D.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.on) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.alpha));
            graphics2D.drawImage((Image)this.offImage, 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
            graphics2D.drawImage((Image)this.onImage, 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            graphics2D.drawImage((Image)this.offImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.bulbImage, 0, 0, null);
        graphics2D.dispose();
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean bl) {
        boolean bl2 = this.on;
        this.on = bl;
        this.propertySupport.firePropertyChange(STATE_PROPERTY, bl2, this.on);
        this.repaint(this.getInnerBounds());
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.repaint(this.getInnerBounds());
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        switch (n) {
            case 5: {
                this.direction = 5;
                break;
            }
            case 3: {
                this.direction = 3;
                break;
            }
            case 7: {
                this.direction = 7;
                break;
            }
            default: {
                this.direction = 1;
            }
        }
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color color) {
        this.glowColor = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void calcInnerBounds() {
        Insets insets = this.getInsets();
        this.INNER_BOUNDS.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 24 || dimension.height < 24) {
            dimension = new Dimension(24, 24);
        }
        return dimension;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        int n = dimension.width < 24 ? 24 : dimension.width;
        int n2 = dimension.height < 24 ? 24 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMinimumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension.width > 1080 || dimension.height > 1080) {
            dimension = new Dimension(1080, 1080);
        }
        return dimension;
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        int n = dimension.width > 1080 ? 1080 : dimension.width;
        int n2 = dimension.height > 1080 ? 1080 : dimension.height;
        int n3 = n <= n2 ? n : n2;
        super.setMaximumSize(new Dimension(n3, n3));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setPreferredSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = n <= n2 ? n : n2;
        super.setSize(n3, n3);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = dimension.width <= dimension.height ? dimension.width : dimension.height;
        super.setSize(new Dimension(n, n));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (rectangle.width <= rectangle.height) {
            int n;
            switch (this.verticalAlignment) {
                case 1: {
                    n = rectangle.y;
                    break;
                }
                case 3: {
                    n = rectangle.y + (rectangle.height - rectangle.width);
                    break;
                }
                default: {
                    n = rectangle.y + (rectangle.height - rectangle.width) / 2;
                }
            }
            super.setBounds(rectangle.x, n, rectangle.width, rectangle.width);
        } else {
            int n;
            switch (this.horizontalAlignment) {
                case 2: {
                    n = rectangle.x;
                    break;
                }
                case 4: {
                    n = rectangle.x + (rectangle.width - rectangle.height);
                    break;
                }
                default: {
                    n = rectangle.x + (rectangle.width - rectangle.height) / 2;
                }
            }
            super.setBounds(n, rectangle.y, rectangle.height, rectangle.height);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= n4) {
            int n5;
            switch (this.verticalAlignment) {
                case 1: {
                    n5 = n2;
                    break;
                }
                case 3: {
                    n5 = n2 + (n4 - n3);
                    break;
                }
                default: {
                    n5 = n2 + (n4 - n3) / 2;
                }
            }
            super.setBounds(n, n5, n3, n3);
        } else {
            int n6;
            switch (this.horizontalAlignment) {
                case 2: {
                    n6 = n;
                    break;
                }
                case 4: {
                    n6 = n + (n3 - n4);
                    break;
                }
                default: {
                    n6 = n + (n3 - n4) / 2;
                }
            }
            super.setBounds(n6, n2, n4, n4);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    private BufferedImage createImage(int n, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, n3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
        return bufferedImage;
    }

    public BufferedImage createOffImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.2894736842105263 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.curveTo(0.2894736842105263 * (double)n3, 0.5614035087719298 * (double)n4, 0.38596491228070173 * (double)n3, 0.6052631578947368 * (double)n4, 0.38596491228070173 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath.curveTo(0.38596491228070173 * (double)n3, 0.7456140350877193 * (double)n4, 0.5877192982456141 * (double)n3, 0.7456140350877193 * (double)n4, 0.5877192982456141 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath.curveTo(0.5877192982456141 * (double)n3, 0.6052631578947368 * (double)n4, 0.6929824561403509 * (double)n3, 0.5614035087719298 * (double)n4, 0.6929824561403509 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.curveTo(0.6929824561403509 * (double)n3, 0.32456140350877194 * (double)n4, 0.6052631578947368 * (double)n3, 0.22807017543859648 * (double)n4, 0.5 * (double)n3, 0.22807017543859648 * (double)n4);
        generalPath.curveTo(0.38596491228070173 * (double)n3, 0.22807017543859648 * (double)n4, 0.2894736842105263 * (double)n3, 0.32456140350877194 * (double)n4, 0.2894736842105263 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.closePath();
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.2894736842105263 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.7017543859649122 * (double)n4), new float[]{0.0f, 0.99f, 1.0f}, new Color[]{new Color(0.93333334f, 0.93333334f, 0.93333334f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f)});
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setPaint(new Color(0.8f, 0.8f, 0.8f, 1.0f));
        graphics2D.setStroke(new BasicStroke(0.01010101f * (float)n3, 0, 1));
        graphics2D.draw(generalPath);
        graphics2D.drawImage((Image)Shadow.INSTANCE.createInnerShadow(generalPath, linearGradientPaint, 0, 0.35f, new Color(0, 0, 0, 50), 10, 45), generalPath.getBounds().x, generalPath.getBounds().y, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createOnImage(int n, int n2, Color color) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.05263157894736842 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.curveTo(0.05263157894736842 * (double)n3, 0.19298245614035087 * (double)n4, 0.24561403508771928 * (double)n3, 0.0, 0.49122807017543857 * (double)n3, 0.0);
        generalPath.curveTo(0.7368421052631579 * (double)n3, 0.0, 0.9298245614035088 * (double)n3, 0.19298245614035087 * (double)n4, 0.9298245614035088 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.curveTo(0.9298245614035088 * (double)n3, 0.6842105263157895 * (double)n4, 0.7368421052631579 * (double)n3, 0.8771929824561403 * (double)n4, 0.49122807017543857 * (double)n3, 0.8771929824561403 * (double)n4);
        generalPath.curveTo(0.24561403508771928 * (double)n3, 0.8771929824561403 * (double)n4, 0.05263157894736842 * (double)n3, 0.6842105263157895 * (double)n4, 0.05263157894736842 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath.closePath();
        float[] fArray = new float[]{0.0f, 0.08f, 0.09f, 0.24f, 0.25f, 0.51f, 0.88f, 1.0f};
        float f = (float)color.getRed() * 1.0f / 255.0f;
        float f2 = (float)color.getGreen() * 1.0f / 255.0f;
        float f3 = (float)color.getBlue() * 1.0f / 255.0f;
        Color[] colorArray = new Color[]{new Color(f, f2, f3, 1.0f), new Color(f, f2, f3, 0.95f), new Color(f, f2, f3, 0.9f), new Color(f, f2, f3, 0.7f), new Color(f, f2, f3, 0.55f), new Color(f, f2, f3, 0.25f), new Color(f, f2, f3, 0.1f), new Color(f, f2, f3, 0.0f)};
        graphics2D.setPaint(new RadialGradientPaint(new Point2D.Double(0.4824561403508772 * (double)n3, 0.43859649122807015 * (double)n4), 0.44298247f * (float)n3, fArray, colorArray));
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo(0.2894736842105263 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath2.curveTo(0.2894736842105263 * (double)n3, 0.5614035087719298 * (double)n4, 0.38596491228070173 * (double)n3, 0.6052631578947368 * (double)n4, 0.38596491228070173 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath2.curveTo(0.38596491228070173 * (double)n3, 0.7456140350877193 * (double)n4, 0.5877192982456141 * (double)n3, 0.7456140350877193 * (double)n4, 0.5877192982456141 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath2.curveTo(0.5877192982456141 * (double)n3, 0.6052631578947368 * (double)n4, 0.6929824561403509 * (double)n3, 0.5614035087719298 * (double)n4, 0.6929824561403509 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath2.curveTo(0.6929824561403509 * (double)n3, 0.32456140350877194 * (double)n4, 0.6052631578947368 * (double)n3, 0.22807017543859648 * (double)n4, 0.5 * (double)n3, 0.22807017543859648 * (double)n4);
        generalPath2.curveTo(0.38596491228070173 * (double)n3, 0.22807017543859648 * (double)n4, 0.2894736842105263 * (double)n3, 0.32456140350877194 * (double)n4, 0.2894736842105263 * (double)n3, 0.43859649122807015 * (double)n4);
        generalPath2.closePath();
        float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color[] colorArray2 = this.glowColor.getRed() == this.glowColor.getGreen() && this.glowColor.getGreen() == this.glowColor.getBlue() ? new Color[]{new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.6f)), new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.4f))} : new Color[]{new Color(Color.HSBtoRGB(fArray2[0], 0.6f, fArray2[2])), new Color(Color.HSBtoRGB(fArray2[0], 0.4f, fArray2[2]))};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.2894736842105263 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.7017543859649122 * (double)n4), new float[]{0.0f, 1.0f}, colorArray2);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath2);
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(0.01010101f * (float)n3, 0, 1));
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createBulbImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (n <= 0 || n2 <= 0) {
            return graphicsConfiguration.createCompatibleImage(1, 1, 3);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo(0.3508771929824561 * (double)n3, 0.3333333333333333 * (double)n4);
        generalPath.curveTo(0.3508771929824561 * (double)n3, 0.2807017543859649 * (double)n4, 0.41228070175438597 * (double)n3, 0.23684210526315788 * (double)n4, 0.5 * (double)n3, 0.23684210526315788 * (double)n4);
        generalPath.curveTo(0.5789473684210527 * (double)n3, 0.23684210526315788 * (double)n4, 0.6403508771929824 * (double)n3, 0.2807017543859649 * (double)n4, 0.6403508771929824 * (double)n3, 0.3333333333333333 * (double)n4);
        generalPath.curveTo(0.6403508771929824 * (double)n3, 0.38596491228070173 * (double)n4, 0.5789473684210527 * (double)n3, 0.4298245614035088 * (double)n4, 0.5 * (double)n3, 0.4298245614035088 * (double)n4);
        generalPath.curveTo(0.41228070175438597 * (double)n3, 0.4298245614035088 * (double)n4, 0.3508771929824561 * (double)n3, 0.38596491228070173 * (double)n4, 0.3508771929824561 * (double)n3, 0.3333333333333333 * (double)n4);
        generalPath.closePath();
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.24561403508771928 * (double)n4), new Point2D.Double(0.5 * (double)n3, 0.4298245614035088 * (double)n4), new float[]{0.0f, 0.99f, 1.0f}, new Color[]{Color.WHITE, new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f)}));
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath2.curveTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4, 0.4298245614035088 * (double)n3, 0.7280701754385965 * (double)n4, 0.49122807017543857 * (double)n3, 0.7280701754385965 * (double)n4);
        generalPath2.curveTo(0.5614035087719298 * (double)n3, 0.7280701754385965 * (double)n4, 0.6052631578947368 * (double)n3, 0.7368421052631579 * (double)n4, 0.6052631578947368 * (double)n3, 0.7368421052631579 * (double)n4);
        generalPath2.lineTo(0.6052631578947368 * (double)n3, 0.7631578947368421 * (double)n4);
        generalPath2.lineTo(0.5964912280701754 * (double)n3, 0.7807017543859649 * (double)n4);
        generalPath2.lineTo(0.6052631578947368 * (double)n3, 0.7982456140350878 * (double)n4);
        generalPath2.lineTo(0.5964912280701754 * (double)n3, 0.8157894736842105 * (double)n4);
        generalPath2.lineTo(0.6052631578947368 * (double)n3, 0.8333333333333334 * (double)n4);
        generalPath2.lineTo(0.5964912280701754 * (double)n3, 0.8508771929824561 * (double)n4);
        generalPath2.lineTo(0.6052631578947368 * (double)n3, 0.868421052631579 * (double)n4);
        generalPath2.lineTo(0.5964912280701754 * (double)n3, 0.8859649122807017 * (double)n4);
        generalPath2.lineTo(0.6052631578947368 * (double)n3, 0.8947368421052632 * (double)n4);
        generalPath2.curveTo(0.6052631578947368 * (double)n3, 0.8947368421052632 * (double)n4, 0.5701754385964912 * (double)n3, 0.956140350877193 * (double)n4, 0.5350877192982456 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath2.curveTo(0.5263157894736842 * (double)n3, 0.9912280701754386 * (double)n4, 0.5175438596491229 * (double)n3, (double)n4, 0.5 * (double)n3, (double)n4);
        generalPath2.curveTo(0.4824561403508772 * (double)n3, (double)n4, 0.47368421052631576 * (double)n3, (double)n4, 0.4649122807017544 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath2.curveTo(0.42105263157894735 * (double)n3, 0.9473684210526315 * (double)n4, 0.39473684210526316 * (double)n3, 0.9035087719298246 * (double)n4, 0.39473684210526316 * (double)n3, 0.9035087719298246 * (double)n4);
        generalPath2.lineTo(0.39473684210526316 * (double)n3, 0.8947368421052632 * (double)n4);
        generalPath2.lineTo(0.38596491228070173 * (double)n3, 0.8859649122807017 * (double)n4);
        generalPath2.lineTo(0.39473684210526316 * (double)n3, 0.868421052631579 * (double)n4);
        generalPath2.lineTo(0.38596491228070173 * (double)n3, 0.8508771929824561 * (double)n4);
        generalPath2.lineTo(0.39473684210526316 * (double)n3, 0.8333333333333334 * (double)n4);
        generalPath2.lineTo(0.38596491228070173 * (double)n3, 0.8157894736842105 * (double)n4);
        generalPath2.lineTo(0.39473684210526316 * (double)n3, 0.7982456140350878 * (double)n4);
        generalPath2.lineTo(0.37719298245614036 * (double)n3, 0.7894736842105263 * (double)n4);
        generalPath2.lineTo(0.39473684210526316 * (double)n3, 0.7719298245614035 * (double)n4);
        generalPath2.lineTo(0.37719298245614036 * (double)n3, 0.7631578947368421 * (double)n4);
        generalPath2.lineTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath2.closePath();
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.47368421052631576 * (double)n3, 0.7280701754385965 * (double)n4), new Point2D.Double(0.4847023065774619 * (double)n3, 0.9383079722290332 * (double)n4), new float[]{0.0f, 0.04f, 0.19f, 0.24f, 0.31f, 0.4f, 0.48f, 0.56f, 0.64f, 0.7f, 0.78f, 1.0f}, new Color[]{new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.8509804f, 0.84705883f, 0.8392157f, 1.0f), new Color(0.89411765f, 0.8980392f, 0.8784314f, 1.0f), new Color(0.5921569f, 0.6f, 0.5882353f, 1.0f), new Color(0.9843137f, 1.0f, 1.0f, 1.0f), new Color(0.5058824f, 0.52156866f, 0.5176471f, 1.0f), new Color(0.9607843f, 0.96862745f, 0.95686275f, 1.0f), new Color(0.58431375f, 0.5921569f, 0.5803922f, 1.0f), new Color(0.9490196f, 0.9490196f, 0.9411765f, 1.0f), new Color(0.50980395f, 0.5294118f, 0.5137255f, 1.0f), new Color(0.9882353f, 0.9882353f, 0.9882353f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f)}));
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath3.curveTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4, 0.4298245614035088 * (double)n3, 0.7280701754385965 * (double)n4, 0.49122807017543857 * (double)n3, 0.7280701754385965 * (double)n4);
        generalPath3.curveTo(0.5614035087719298 * (double)n3, 0.7280701754385965 * (double)n4, 0.6052631578947368 * (double)n3, 0.7368421052631579 * (double)n4, 0.6052631578947368 * (double)n3, 0.7368421052631579 * (double)n4);
        generalPath3.lineTo(0.6052631578947368 * (double)n3, 0.7631578947368421 * (double)n4);
        generalPath3.lineTo(0.5964912280701754 * (double)n3, 0.7807017543859649 * (double)n4);
        generalPath3.lineTo(0.6052631578947368 * (double)n3, 0.7982456140350878 * (double)n4);
        generalPath3.lineTo(0.5964912280701754 * (double)n3, 0.8157894736842105 * (double)n4);
        generalPath3.lineTo(0.6052631578947368 * (double)n3, 0.8333333333333334 * (double)n4);
        generalPath3.lineTo(0.5964912280701754 * (double)n3, 0.8508771929824561 * (double)n4);
        generalPath3.lineTo(0.6052631578947368 * (double)n3, 0.868421052631579 * (double)n4);
        generalPath3.lineTo(0.5964912280701754 * (double)n3, 0.8859649122807017 * (double)n4);
        generalPath3.lineTo(0.6052631578947368 * (double)n3, 0.8947368421052632 * (double)n4);
        generalPath3.curveTo(0.6052631578947368 * (double)n3, 0.8947368421052632 * (double)n4, 0.5701754385964912 * (double)n3, 0.956140350877193 * (double)n4, 0.5350877192982456 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath3.curveTo(0.5263157894736842 * (double)n3, 0.9912280701754386 * (double)n4, 0.5175438596491229 * (double)n3, (double)n4, 0.5 * (double)n3, (double)n4);
        generalPath3.curveTo(0.4824561403508772 * (double)n3, (double)n4, 0.47368421052631576 * (double)n3, (double)n4, 0.4649122807017544 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath3.curveTo(0.42105263157894735 * (double)n3, 0.9473684210526315 * (double)n4, 0.39473684210526316 * (double)n3, 0.9035087719298246 * (double)n4, 0.39473684210526316 * (double)n3, 0.9035087719298246 * (double)n4);
        generalPath3.lineTo(0.39473684210526316 * (double)n3, 0.8947368421052632 * (double)n4);
        generalPath3.lineTo(0.38596491228070173 * (double)n3, 0.8859649122807017 * (double)n4);
        generalPath3.lineTo(0.39473684210526316 * (double)n3, 0.868421052631579 * (double)n4);
        generalPath3.lineTo(0.38596491228070173 * (double)n3, 0.8508771929824561 * (double)n4);
        generalPath3.lineTo(0.39473684210526316 * (double)n3, 0.8333333333333334 * (double)n4);
        generalPath3.lineTo(0.38596491228070173 * (double)n3, 0.8157894736842105 * (double)n4);
        generalPath3.lineTo(0.39473684210526316 * (double)n3, 0.7982456140350878 * (double)n4);
        generalPath3.lineTo(0.37719298245614036 * (double)n3, 0.7894736842105263 * (double)n4);
        generalPath3.lineTo(0.39473684210526316 * (double)n3, 0.7719298245614035 * (double)n4);
        generalPath3.lineTo(0.37719298245614036 * (double)n3, 0.7631578947368421 * (double)n4);
        generalPath3.lineTo(0.37719298245614036 * (double)n3, 0.7456140350877193 * (double)n4);
        generalPath3.closePath();
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.37719298245614036 * (double)n3, 0.7894736842105263 * (double)n4), new Point2D.Double(0.6052631578947368 * (double)n3, 0.7894736842105263 * (double)n4), new float[]{0.0f, 0.15f, 0.85f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.4f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)}));
        graphics2D.fill(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.setWindingRule(0);
        generalPath4.moveTo(0.42105263157894735 * (double)n3, 0.9473684210526315 * (double)n4);
        generalPath4.curveTo(0.43859649122807015 * (double)n3, 0.956140350877193 * (double)n4, 0.4473684210526316 * (double)n3, 0.9736842105263158 * (double)n4, 0.4649122807017544 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath4.curveTo(0.47368421052631576 * (double)n3, (double)n4, 0.4824561403508772 * (double)n3, (double)n4, 0.5 * (double)n3, (double)n4);
        generalPath4.curveTo(0.5175438596491229 * (double)n3, (double)n4, 0.5263157894736842 * (double)n3, 0.9912280701754386 * (double)n4, 0.5350877192982456 * (double)n3, 0.9912280701754386 * (double)n4);
        generalPath4.curveTo(0.543859649122807 * (double)n3, 0.9824561403508771 * (double)n4, 0.5614035087719298 * (double)n3, 0.956140350877193 * (double)n4, 0.5789473684210527 * (double)n3, 0.9473684210526315 * (double)n4);
        generalPath4.curveTo(0.5526315789473685 * (double)n3, 0.9385964912280702 * (double)n4, 0.5263157894736842 * (double)n3, 0.9385964912280702 * (double)n4, 0.5 * (double)n3, 0.9385964912280702 * (double)n4);
        generalPath4.curveTo(0.47368421052631576 * (double)n3, 0.9385964912280702 * (double)n4, 0.4473684210526316 * (double)n3, 0.9385964912280702 * (double)n4, 0.42105263157894735 * (double)n3, 0.9473684210526315 * (double)n4);
        generalPath4.closePath();
        graphics2D.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)n3, 0.9385964912280702 * (double)n4), new Point2D.Double(0.5 * (double)n3, n4), new float[]{0.0f, 0.61f, 0.71f, 0.83f, 1.0f}, new Color[]{new Color(0.019607844f, 0.039215688f, 0.023529412f, 1.0f), new Color(0.02745098f, 0.023529412f, 0.007843138f, 1.0f), new Color(0.6f, 0.57254905f, 0.53333336f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        graphics2D.fill(generalPath4);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "LightBulb";
    }
}

