/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlUtil {
    public static void writeXml(Object instance, Class<?> modelClass, String fileName) throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance(modelClass);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        StringWriter xmlWriter = new StringWriter();
        marshaller.marshal(instance, xmlWriter);
        System.out.println(xmlWriter.toString());
        System.out.println("Writing " + fileName);
        FileWriter writer = new FileWriter(fileName);
        marshaller.marshal(instance, writer);
        System.out.println("Marshalling finished " + fileName);
        writer.close();
    }

    public static <T> T readModel(Class<?> modelClass, String fileName) throws JAXBException {
        File xmlFile = new File(fileName);
        JAXBContext jaxbContext = JAXBContext.newInstance(modelClass);
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (T)jaxbUnmarshaller.unmarshal(xmlFile);
    }

    private static void setParserImpl() {
        System.setProperty("org.xml.sax.driver", "com.sun.org.apache.xerces.internal.parsers.SAXParser");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    static {
        XmlUtil.setParserImpl();
    }
}

