/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.engine;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.engine.NameUtil;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.waves.EngineReport;
import com.rusefi.waves.RevolutionLog;
import com.rusefi.waves.TimeAxisTranslator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;

public class UpDownImage
extends JPanel {
    private static final int TIMESCALE_MULT = 2000;
    private static final int LINE_SIZE = 20;
    private static final int GAP_POSITIONS = 5;
    public static final Color TIME_SCALE_COLOR = Color.red;
    public static final Color ENGINE_CYCLE_COLOR = new Color(0, 153, 0);
    private static final BasicStroke TIME_SCALE_STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{7.0f, 21.0f}, 0.0f);
    private static final BasicStroke ENGINE_CYCLE_STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{21.0f, 7.0f}, 0.0f);
    public EngineReport engineReport;
    private StringBuilder revolutions;
    private final String name;
    private TimeAxisTranslator translator;
    private RevolutionLog time2rpm = RevolutionLog.parseRevolutions(null);
    private String pin = "NO PIN";
    private Color signalBody = Color.lightGray;
    private Color signalBorder = Color.GRAY;
    private boolean renderText = true;
    private final PinNameSource pinNameSource;
    private final TimeAxisTranslator _translator = new TimeAxisTranslator(){

        @Override
        public int timeToScreen(double time, int width) {
            return UpDownImage.this.engineReport.getTimeAxisTranslator().timeToScreen(time, width);
        }

        @Override
        public double screenToTime(int screen, int width) {
            return UpDownImage.this.engineReport.getTimeAxisTranslator().screenToTime(screen, width);
        }

        @Override
        public int getMaxTime() {
            return UpDownImage.this.engineReport.getTimeAxisTranslator().getMaxTime();
        }

        @Override
        public int getMinTime() {
            return UpDownImage.this.engineReport.getTimeAxisTranslator().getMinTime();
        }

        public String toString() {
            return "TimeAxisTranslator";
        }
    };

    public void setRenderText(boolean renderText) {
        this.renderText = renderText;
    }

    public UpDownImage(String name, PinNameSource pinNameSource) {
        this(EngineReport.MOCK, name, pinNameSource);
        this.setToolTip();
        String pin = pinNameSource.getPinByName(name);
        if (pin != null) {
            this.setPhysicalPin(pin);
        }
    }

    public void setSignalBody(Color signalBody) {
        this.signalBody = signalBody;
    }

    public void setSignalBorder(Color signalBorder) {
        this.signalBorder = signalBorder;
    }

    public void setToolTip() {
        String secondLine = this.pinNameSource.isSimulationMode() ? "" : "Physical pin: " + this.pin;
        UiUtils.setToolTip(this, "Channel " + NameUtil.getUiName(this.name), secondLine);
    }

    public UpDownImage(EngineReport wr, String name) {
        this(wr, name, PinNameSource.VOID);
    }

    public UpDownImage(EngineReport wr, String name, PinNameSource pinNameSource) {
        this.name = name;
        this.pinNameSource = pinNameSource;
        this.setWaveReport(wr, null);
        this.setOpaque(true);
        this.translator = this.createTranslator();
    }

    public UpDownImage setTranslator(TimeAxisTranslator translator) {
        this.translator = translator;
        return this;
    }

    public TimeAxisTranslator createTranslator() {
        return this._translator;
    }

    public void setWaveReport(EngineReport wr, StringBuilder revolutions) {
        this.engineReport = wr;
        this.propagateDwellIntoSensor(wr);
        this.revolutions = revolutions;
    }

    private void propagateDwellIntoSensor(EngineReport wr) {
        Sensor sensor = NameUtil.name2sensor.get(this.name);
        if (sensor == null) {
            return;
        }
        if (!wr.getList().isEmpty()) {
            EngineReport.UpDown last = wr.getList().get(wr.getList().size() - 1);
            SensorCentral.getInstance().setValue(last.getDuration(), sensor);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        if (this.renderText) {
            this.paintScaleLines(g2, d);
        }
        this.drawStartOfRevolution(g2, d);
        d.height = (int)(0.95 * (double)d.height);
        AtomicInteger gapIndex = new AtomicInteger();
        for (EngineReport.UpDown upDown : this.engineReport.getList()) {
            this.paintUpDown(d, upDown, g, gapIndex);
        }
        g2.setColor(Color.black);
        int line = 0;
        if (!this.renderText) {
            return;
        }
        Object mouseOverText = NameUtil.getUiName(this.name);
        if (this.pin != null) {
            mouseOverText = (String)mouseOverText + "/" + this.pin;
        }
        g.drawString((String)mouseOverText, 5, ++line * 20);
        if (d.height > 40) {
            g.drawString(this.engineReport.getList().size() + " events", 5, ++line * 20);
        }
    }

    private void drawStartOfRevolution(Graphics2D g2, Dimension d) {
        if (this.revolutions == null) {
            return;
        }
        RevolutionLog time2rpm = RevolutionLog.parseRevolutions(this.revolutions);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(ENGINE_CYCLE_STROKE);
        for (int time : time2rpm.keySet()) {
            int x = this.translator.timeToScreen(time, d.width);
            g2.setColor(ENGINE_CYCLE_COLOR);
            g2.drawLine(x, 0, x, d.height);
            if (!this.isShowTdcLabel()) continue;
            g2.rotate(1.5707963267948966);
            g2.drawString("#1 TDC", 0, -x - 3);
            g2.rotate(-1.5707963267948966);
        }
        g2.setStroke(oldStroke);
    }

    protected boolean isShowTdcLabel() {
        return false;
    }

    private void paintScaleLines(Graphics2D g2, Dimension d) {
        int fromMs = this.translator.getMinTime() / 2000;
        int toMs = this.translator.getMaxTime() / 2000;
        if ((double)(toMs - fromMs) > d.getWidth() / 5.0) {
            return;
        }
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(TIME_SCALE_STROKE);
        g2.setColor(TIME_SCALE_COLOR);
        for (int ms = fromMs + 1; ms <= toMs; ++ms) {
            int tick = ms * 2000;
            int x = this.translator.timeToScreen(tick, d.width);
            g2.drawLine(x, 0, x, d.height);
        }
        g2.setStroke(oldStroke);
    }

    private void paintUpDown(Dimension d, EngineReport.UpDown upDown, Graphics g, AtomicInteger gapIndex) {
        int x1 = this.translator.timeToScreen(upDown.upTime, d.width);
        int x2 = this.translator.timeToScreen(upDown.downTime, d.width);
        g.setColor(this.signalBody);
        g.fillRect(x1, 0, x2 - x1, d.height);
        g.setColor(this.signalBorder);
        g.drawLine(x1, 0, x2, 0);
        g.drawLine(x1, 0, x1, d.height);
        g.drawLine(x2, 0, x2, d.height);
        g.drawLine(x1, d.height, x2, d.height);
        if (d.height < 25) {
            return;
        }
        if (!Double.isNaN(upDown.prevGap)) {
            gapIndex.set(gapIndex.incrementAndGet() % 5);
            g.drawString(String.format("gap %.2f", upDown.prevGap), x1, d.height / 2 + gapIndex.get() * g.getFont().getSize());
        }
        if (!Double.isNaN(upDown.gap)) {
            gapIndex.set(gapIndex.incrementAndGet() % 5);
            g.drawString(String.format("gap %.2f", upDown.gap), x2, d.height / 2 + gapIndex.get() * g.getFont().getSize());
        }
        if (!this.renderText) {
            return;
        }
        int duration = upDown.getDuration();
        if (duration != 0 && upDown.upTriggerCycleIndex == -1) {
            g.setColor(Color.red);
            String durationString = String.format(" %.2fms", (double)duration / 100.0);
            g.drawString(durationString, x1, 15);
        }
        if (upDown.upTriggerCycleIndex != -1) {
            g.setColor(Color.darkGray);
            g.drawString("" + upDown.upTriggerCycleIndex, x1, (int)(0.25 * (double)d.height));
        }
        if (upDown.downTriggerCycleIndex != -1 && upDown.upTriggerCycleIndex != upDown.downTriggerCycleIndex) {
            g.setColor(Color.darkGray);
            g.drawString("" + upDown.downTriggerCycleIndex, x2, (int)(0.25 * (double)d.height));
        }
        if (d.height < 50) {
            return;
        }
        int offset = 3;
        g.setColor(Color.black);
        double fromAngle = this.time2rpm.getCrankAngleByTime(upDown.upTime);
        String fromAngleStr = RevolutionLog.angle2string(fromAngle);
        g.drawString(fromAngleStr, x1 + offset, (int)(0.5 * (double)d.height));
        double toAngle = this.time2rpm.getCrankAngleByTime(upDown.downTime);
        String toAngleStr = RevolutionLog.angle2string(toAngle);
        g.drawString(toAngleStr, x1 + offset, (int)(0.75 * (double)d.height));
    }

    public void setRevolutions(StringBuilder revolutions) {
        this.time2rpm = RevolutionLog.parseRevolutions(revolutions);
    }

    public void setPhysicalPin(String pin) {
        this.pin = pin;
        this.setToolTip();
    }

    @Override
    public String toString() {
        return "UpDownImage{} " + super.toString();
    }

    static interface PinNameSource {
        public static final PinNameSource VOID = new PinNameSource(){

            @Override
            public String getPinByName(String name) {
                return null;
            }

            @Override
            public boolean isSimulationMode() {
                return false;
            }
        };

        public String getPinByName(String var1);

        public boolean isSimulationMode();
    }
}

