/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.MaintenanceUtil;
import com.rusefi.maintenance.OpenbltJni;
import com.rusefi.maintenance.StLinkFlasher;
import com.rusefi.maintenance.UpdateStatusWindow;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgramSelector {
    private static final String AUTO_DFU = "Auto Update";
    private static final String MANUAL_DFU = "Manual DFU Update";
    private static final String DFU_SWITCH = "Switch to DFU Mode";
    private static final String OPENBLT_SWITCH = "Switch to OpenBLT Mode";
    private static final String OPENBLT_MANUAL = "Manual OpenBLT Update";
    private static final String OPENBLT_AUTO = "Auto OpenBLT Update";
    private static final String DFU_ERASE = "Full Chip Erase";
    private static final String INSTALL_OPENBLT = "Install OpenBLT";
    private static final String ST_LINK = "ST-LINK Update";
    private static final String OPENBLT_CAN = "OpenBLT via CAN";
    private static final String HELP = "https://github.com/rusefi/rusefi/wiki/HOWTO-Update-Firmware";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel noHardware = new JLabel("Nothing detected");
    private final JPanel controls = new JPanel(new FlowLayout());
    private final JComboBox<String> mode = new JComboBox();

    public ProgramSelector(final JComboBox<SerialPortScanner.PortResult> comboPorts) {
        this.content.add((Component)this.controls, "North");
        this.content.add((Component)this.noHardware, "South");
        this.controls.setVisible(false);
        this.controls.add(this.mode);
        String persistedMode = PersistentConfiguration.getConfig().getRoot().getProperty(this.getClass().getSimpleName());
        if (Arrays.asList(AUTO_DFU, MANUAL_DFU, OPENBLT_CAN, OPENBLT_SWITCH, OPENBLT_MANUAL, OPENBLT_AUTO, DFU_ERASE, DFU_SWITCH).contains(persistedMode)) {
            this.mode.setSelectedItem(persistedMode);
        }
        final JButton updateFirmware = ProgramSelector.createUpdateFirmwareButton();
        this.controls.add(updateFirmware);
        updateFirmware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Consumer<UpdateOperationCallbacks> job;
                String selectedMode = (String)ProgramSelector.this.mode.getSelectedItem();
                SerialPortScanner.PortResult selectedPort = (SerialPortScanner.PortResult)comboPorts.getSelectedItem();
                PersistentConfiguration.getConfig().getRoot().setProperty(this.getClass().getSimpleName(), selectedMode);
                String jobName = null;
                Objects.requireNonNull(selectedMode);
                switch (selectedMode) {
                    case "Auto Update": {
                        jobName = "DFU update";
                        job = callbacks -> DfuFlasher.doAutoDfu(comboPorts, selectedPort.port, callbacks);
                        break;
                    }
                    case "Manual DFU Update": {
                        jobName = "DFU update";
                        job = DfuFlasher::runDfuProgramming;
                        break;
                    }
                    case "Install OpenBLT": {
                        jobName = "OpenBLT Initial Programming";
                        job = DfuFlasher::runOpenBltInitialProgramming;
                        break;
                    }
                    case "ST-LINK Update": {
                        job = updateOperationCallbacks -> StLinkFlasher.doUpdateFirmware(MaintenanceUtil.FIRMWARE_BIN_FILE, updateFirmware);
                        break;
                    }
                    case "Switch to DFU Mode": {
                        jobName = "DFU switch";
                        job = callbacks -> ProgramSelector.rebootToDfu(comboPorts, selectedPort.port, callbacks);
                        break;
                    }
                    case "Switch to OpenBLT Mode": {
                        jobName = "OpenBLT switch";
                        job = callbacks -> ProgramSelector.rebootToOpenblt(comboPorts, selectedPort.port, callbacks);
                        break;
                    }
                    case "OpenBLT via CAN": {
                        jobName = ProgramSelector.OPENBLT_CAN;
                        job = x$0 -> ProgramSelector.this.flashOpenBltCan((UpdateOperationCallbacks)x$0);
                        break;
                    }
                    case "Manual OpenBLT Update": {
                        jobName = "OpenBLT via Serial";
                        job = callbacks -> ProgramSelector.this.flashOpenbltSerialJni(selectedPort.port, (UpdateOperationCallbacks)callbacks);
                        break;
                    }
                    case "Auto OpenBLT Update": {
                        jobName = "OpenBLT via Serial";
                        job = callbacks -> ProgramSelector.this.flashOpenbltSerialAutomatic(comboPorts, selectedPort.port, (UpdateOperationCallbacks)callbacks);
                        break;
                    }
                    case "Full Chip Erase": {
                        jobName = "DFU erase";
                        job = DfuFlasher::runDfuEraseAsync;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("How did you " + selectedMode);
                    }
                }
                UpdateStatusWindow callbacks2 = new UpdateStatusWindow(FrameHelper.appendBundleName(jobName + " 20240531"));
                Consumer<UpdateOperationCallbacks> job2 = job;
                ExecHelper.submitAction(() -> job2.accept(callbacks2), "mx");
            }
        });
    }

    private static void rebootToDfu(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_dfu");
    }

    private static void rebootToOpenblt(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_openblt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flashOpenBltCan(UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            this.showError32bitJava();
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = this.makeOpenbltCallbacks(callbacks);
        try {
            OpenbltJni.flashCan(FindFileHelper.findSrecFile(), cb);
            callbacks.log("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.log("Error: " + e);
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    private void flashOpenbltSerialAutomatic(JComponent parent, String ecuPort, UpdateOperationCallbacks callbacks) {
        String[] portsBefore = LinkManager.getCommPorts();
        ProgramSelector.rebootToOpenblt(parent, ecuPort, callbacks);
        BinaryProtocol.sleep(3000L);
        String[] portsAfter = LinkManager.getCommPorts();
        if (!"auto".equals(ecuPort)) {
            if (Arrays.stream(portsAfter).anyMatch(ecuPort::equals)) {
                callbacks.log("Looks like your ECU didn't reboot to OpenBLT");
                callbacks.error();
                return;
            }
        }
        ArrayList<String> newItems = new ArrayList<String>();
        for (String s : portsAfter) {
            if (Arrays.stream(portsBefore).anyMatch(s::equals)) continue;
            newItems.add(s);
        }
        if (newItems.size() == 0) {
            callbacks.log("Looks like your ECU disappeared during the update process. Please try again.");
            callbacks.error();
            return;
        }
        if (newItems.size() > 1) {
            callbacks.log("Unable to find ECU after reboot as multiple serial ports appeared. Before: " + portsBefore.length + " After: " + portsAfter.length);
            callbacks.error();
            return;
        }
        String openbltPort = (String)newItems.get(0);
        callbacks.log("Serial port " + openbltPort + " appeared, programming firmware...");
        this.flashOpenbltSerialJni(openbltPort, callbacks);
    }

    private OpenbltJni.OpenbltCallbacks makeOpenbltCallbacks(final UpdateOperationCallbacks callbacks) {
        return new OpenbltJni.OpenbltCallbacks(){

            @Override
            public void log(String line) {
                callbacks.log(line);
            }

            @Override
            public void updateProgress(int percent) {
                callbacks.log("Progress: " + percent + "%");
            }

            @Override
            public void error(String line) {
                throw new RuntimeException(line);
            }

            @Override
            public void setPhase(String title, boolean hasProgress) {
                callbacks.log("Phase: " + title);
            }
        };
    }

    private void showError32bitJava() {
        JOptionPane.showMessageDialog(this.content, "64 bit java required. 32 bit java not supported!", "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flashOpenbltSerialJni(String port, UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            this.showError32bitJava();
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = this.makeOpenbltCallbacks(callbacks);
        try {
            String fileName = FindFileHelper.findSrecFile();
            callbacks.log("flashSerial " + fileName);
            OpenbltJni.flashSerial(fileName, port, cb);
            callbacks.log("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.log("Error: " + e.toString());
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    @NotNull
    public static JComponent createHelpButton() {
        return new URLLabel("HOWTO Update Firmware", HELP);
    }

    public JPanel getControl() {
        return this.content;
    }

    public void apply(SerialPortScanner.AvailableHardware currentHardware) {
        this.noHardware.setVisible(currentHardware.isEmpty());
        this.controls.setVisible(!currentHardware.isEmpty());
        boolean hasSerialPorts = !currentHardware.getKnownPorts().isEmpty();
        boolean hasDfuDevice = currentHardware.isDfuFound();
        this.mode.removeAllItems();
        if (FileLog.isWindows()) {
            boolean requireBlt = FindFileHelper.isObfuscated();
            if (hasSerialPorts && !requireBlt) {
                this.mode.addItem(AUTO_DFU);
            }
            if (hasDfuDevice) {
                this.mode.addItem(MANUAL_DFU);
                this.mode.addItem(DFU_ERASE);
                if (DfuFlasher.haveBootloaderBinFile()) {
                    this.mode.addItem(INSTALL_OPENBLT);
                }
            }
            if (!requireBlt) {
                this.mode.addItem(DFU_SWITCH);
            }
            if (currentHardware.isStLinkConnected()) {
                this.mode.addItem(ST_LINK);
            }
            if (currentHardware.isPCANConnected()) {
                this.mode.addItem(OPENBLT_CAN);
            }
        }
        if (hasSerialPorts) {
            this.mode.addItem(OPENBLT_AUTO);
            this.mode.addItem(OPENBLT_SWITCH);
            this.mode.addItem(OPENBLT_MANUAL);
        }
        UiUtils.trueLayout(this.mode);
        UiUtils.trueLayout(this.content);
    }

    @NotNull
    public static JButton createUpdateFirmwareButton() {
        return new JButton("Update Firmware", AutoupdateUtil.loadIcon("upload48.png"));
    }
}

