/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniFileReader;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.tune.xml.Constant;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;

public class EnumIniField
extends IniField {
    private final FieldType type;
    private final EnumKeyValueMap enums;
    private final int bitPosition;
    private final int bitSize0;

    public EnumIniField(String name, int offset, FieldType type, EnumKeyValueMap enums, int bitPosition, int bitSize0) {
        super(name, offset);
        this.type = type;
        this.enums = enums;
        this.bitPosition = bitPosition;
        this.bitSize0 = bitSize0;
    }

    @Override
    public int getSize() {
        return this.type.getStorageSize();
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    public int getBitSize0() {
        return this.bitSize0;
    }

    public EnumKeyValueMap getEnums() {
        return this.enums;
    }

    public FieldType getType() {
        return this.type;
    }

    @Override
    public String getValue(ConfigurationImage image) {
        int ordinal = this.getByteBuffer(image).getInt();
        if ((ordinal = EnumIniField.getBitRange(ordinal, this.bitPosition, this.bitSize0 + 1)) >= this.enums.size()) {
            throw new IllegalStateException("Ordinal out of range " + ordinal + " in " + this.getName());
        }
        return "\"" + this.enums.get(ordinal) + "\"";
    }

    @NotNull
    private ByteBuffer getByteBuffer(ConfigurationImage image) {
        return image.getByteBuffer(this.getOffset(), 4);
    }

    public static boolean isQuoted(String q) {
        int len = q.length();
        return len >= 2 && q.charAt(0) == '\"' && q.charAt(len - 1) == '\"';
    }

    @Override
    public void setValue(ConfigurationImage image, Constant constant) {
        String v = constant.getValue();
        int ordinal = this.enums.indexOf(EnumIniField.isQuoted(v) ? ObjectName.unquote(v) : v);
        if (ordinal == -1) {
            throw new IllegalArgumentException("Not found " + v);
        }
        int value = this.getByteBuffer(image).getInt();
        value = EnumIniField.setBitRange(value, ordinal, this.bitPosition, this.bitSize0 + 1);
        this.getByteBuffer(image).putInt(value);
    }

    public String toString() {
        return "EnumIniField{name=" + this.getName() + ", offset=" + this.getOffset() + ", type=" + this.type + ", enums=" + this.enums + ", bitPosition=" + this.bitPosition + ", bitSize=" + this.bitSize0 + "}";
    }

    public static int setBitRange(int value, int ordinal, int bitPosition, int bitSize) {
        if (ordinal >= 1 << bitSize) {
            throw new IllegalArgumentException("Ordinal overflow " + ordinal + " does not fit in " + bitSize + " bit(s)");
        }
        int num = (1 << bitSize) - 1 << bitPosition;
        int clearBitRange = value & ~num;
        return clearBitRange + (ordinal << bitPosition);
    }

    public static boolean getBit(int ordinal, int bitPosition) {
        return EnumIniField.getBitRange(ordinal, bitPosition, 1) == 1;
    }

    public static int getBitRange(int ordinal, int bitPosition, int bitSize) {
        ordinal >>= bitPosition;
        return ordinal &= (1 << bitSize) - 1;
    }

    public static EnumIniField parse(LinkedList<String> list, RawIniFile.Line line, IniFileModel iniFileModel) {
        String name = list.get(0);
        FieldType type = FieldType.parseTs(list.get(2));
        int offset = Integer.parseInt(list.get(3));
        String bitRange = list.get(4);
        ParseBitRange parseBitRange = new ParseBitRange().invoke(bitRange);
        int bitPosition = parseBitRange.getBitPosition();
        int bitSize0 = parseBitRange.getBitSize0();
        EnumKeyValueMap enums = EnumKeyValueMap.valueOf(line.getRawText(), iniFileModel);
        return new EnumIniField(name, offset, type, enums, bitPosition, bitSize0);
    }

    public static int ordinalIndexOf(String str, String substr, int n) {
        int pos = str.indexOf(substr);
        while (--n > 0 && pos != -1) {
            pos = str.indexOf(substr, pos + 1);
        }
        return pos;
    }

    @NotNull
    public static String getEnumValuesSection(String rawText) {
        int interestingIndex = EnumIniField.ordinalIndexOf(rawText, ",", 4);
        return rawText.substring(interestingIndex + 1).trim();
    }

    public static class EnumKeyValueMap {
        private static final String STARTS_WITH_NUMBERS_OPTIONAL_SPACES_AND_EQUALS = "^\\d+\\s*=.*";
        private static final Pattern IS_KEY_VALUE_SYNTAX = Pattern.compile("^\\d+\\s*=.*");
        private final Map<Integer, String> keyValues;

        public EnumKeyValueMap(Map<Integer, String> keyValues) {
            this.keyValues = keyValues;
        }

        public static EnumKeyValueMap valueOf(String rawText, IniFileModel iniFileModel) {
            TreeMap<Integer, String> keyValues = new TreeMap<Integer, String>();
            boolean isKeyValueSyntax = EnumKeyValueMap.isKeyValueSyntax(rawText);
            int offset = 5;
            String[] tokens = IniFileReader.splitTokens(rawText);
            if (isKeyValueSyntax) {
                for (int i = 0; i < tokens.length - offset; i += 2) {
                    keyValues.put(Integer.valueOf(tokens[i + offset]), tokens[i + offset + 1]);
                }
            } else {
                String firstValue = tokens[offset];
                String trimmed = firstValue.trim();
                if (trimmed.startsWith("$")) {
                    String key = trimmed.substring(1);
                    List<String> elements = iniFileModel.defines.get(key);
                    Objects.requireNonNull(elements, "Elements for " + key);
                    for (int i = 0; i < elements.size(); ++i) {
                        keyValues.put(i, elements.get(i));
                    }
                } else {
                    for (int i = 0; i < tokens.length - offset; ++i) {
                        keyValues.put(i, tokens[i + offset]);
                    }
                }
            }
            return new EnumKeyValueMap(keyValues);
        }

        public static boolean isKeyValueSyntax(String rawText) {
            String interestingPart = EnumIniField.getEnumValuesSection(rawText);
            return IS_KEY_VALUE_SYNTAX.matcher(interestingPart).matches();
        }

        public int size() {
            return this.keyValues.size();
        }

        public String get(int ordinal) {
            return this.keyValues.get(ordinal);
        }

        public int indexOf(String value) {
            for (Map.Entry<Integer, String> e : this.keyValues.entrySet()) {
                if (!e.getValue().equals(value)) continue;
                return e.getKey();
            }
            throw new IllegalArgumentException("Nothing for " + value);
        }
    }

    public static class ParseBitRange {
        private int bitPosition;
        private int bitSize0;

        public int getBitPosition() {
            return this.bitPosition;
        }

        public int getBitSize0() {
            return this.bitSize0;
        }

        public ParseBitRange invoke(String bitRange) {
            String[] bitPositions = (bitRange = bitRange.replaceAll("[\\]\\[:]", " ").trim()).split(" ");
            if (bitPositions.length != 2) {
                throw new IllegalStateException("Bit position " + bitRange);
            }
            this.bitPosition = Integer.parseInt(bitPositions[0]);
            this.bitSize0 = Integer.parseInt(bitPositions[1]) - this.bitPosition;
            return this;
        }
    }
}

