/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune;

public class AfrDataPoint {
    private final double afr;
    private final int rpm;
    private final double engineLoad;
    private final int rpmIndex;
    private final int engineLoadIndex;

    public AfrDataPoint(double afr, int rpmIndex, int engineLoadIndex, int rpm, double engineLoad) {
        this.rpm = rpm;
        this.engineLoad = engineLoad;
        if (rpmIndex < 0 || rpmIndex >= 8) {
            throw new IllegalStateException("rpmIndex " + rpmIndex);
        }
        if (engineLoadIndex < 0 || engineLoadIndex >= 4) {
            throw new IllegalStateException("engineLoadIndex " + engineLoadIndex);
        }
        this.afr = afr;
        this.rpmIndex = rpmIndex;
        this.engineLoadIndex = engineLoadIndex;
    }

    public static AfrDataPoint valueOf(double afr, int rpm, double engineLoad) {
        int rpmIndex = (int)((double)rpm / 7000.0 * 8.0);
        if (rpmIndex < 0 || rpmIndex >= 8) {
            return null;
        }
        int engineLoadIndex = (int)(engineLoad / 120.0 * 4.0);
        return new AfrDataPoint(afr, rpmIndex, engineLoadIndex, rpm, engineLoad);
    }

    int getRpmIndex() {
        return this.rpmIndex;
    }

    public int getEngineLoadIndex() {
        return this.engineLoadIndex;
    }

    public int PRESS_RT_32() {
        return this.getEngineLoadIndex();
    }

    public int RPM_RT_32() {
        return this.getRpmIndex();
    }

    public double getAfr() {
        return this.afr;
    }

    public int getRpm() {
        return this.rpm;
    }

    public double getEngineLoad() {
        return this.engineLoad;
    }

    public String toString() {
        return "AfrDataPoint{afr=" + this.afr + ", rpm=" + this.rpm + ", engineLoad=" + this.engineLoad + "}";
    }
}

