/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.lua;

import com.rusefi.ui.lua.DocumentSizeFilter;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;

public class TextEditor {
    private final JPanel area = new JPanel(new BorderLayout());
    private final JTextArea textArea = new JTextArea();
    private final JLabel sizeLabel = new JLabel();
    private final JLabel locationLabel = new JLabel();

    public TextEditor() {
        this.textArea.setTabSize(2);
        AbstractDocument pDoc = (AbstractDocument)this.textArea.getDocument();
        pDoc.setDocumentFilter(new DocumentSizeFilter(13500));
        pDoc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextEditor.this.updateSize();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextEditor.this.updateSize();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextEditor.this.updateSize();
            }
        });
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int offset = TextEditor.this.textArea.getCaretPosition();
                try {
                    int line = TextEditor.this.textArea.getLineOfOffset(offset);
                    TextEditor.this.locationLabel.setText(Integer.toString(line + 1));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        JScrollPane textAreaScroll = new JScrollPane(this.textArea, 22, 30);
        this.area.add((Component)textAreaScroll, "Center");
        JPanel bottomArea = new JPanel(new BorderLayout());
        this.area.add((Component)bottomArea, "South");
        bottomArea.add((Component)this.locationLabel, "West");
        bottomArea.add((Component)this.sizeLabel, "East");
        this.installUndoRedoKeystrokes();
        UiUtils.installPopupMenu(this.createPopupMenu(), this.textArea);
    }

    @NotNull
    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(UiUtils.createCopyMenu(this.textArea));
        return menu;
    }

    private void updateSize() {
        this.sizeLabel.setText(this.textArea.getText().length() + "/13500");
    }

    private void installUndoRedoKeystrokes() {
        KeyStroke undoKeyStroke = KeyStroke.getKeyStroke(90, 2);
        KeyStroke redoKeyStroke = KeyStroke.getKeyStroke(89, 2);
        final UndoManager undoManager = new UndoManager();
        Document document = this.textArea.getDocument();
        document.addUndoableEditListener(e -> undoManager.addEdit(e.getEdit()));
        TextEditor.installKeyAction(undoKeyStroke, "undoKeyStroke", this.textArea, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        TextEditor.installKeyAction(redoKeyStroke, "redoKeyStroke", this.textArea, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
    }

    public static void installKeyAction(KeyStroke undoKeyStroke, String actionName, JComponent control, AbstractAction action) {
        control.getInputMap(2).put(undoKeyStroke, actionName);
        control.getActionMap().put(actionName, action);
    }

    public JComponent getControl() {
        return this.area;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }
}

