/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.light;

import com.devexperts.logging.Logging;
import com.rusefi.IoUtil;
import com.rusefi.autodetect.PortDetector;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionWatchdog;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.light.InternetStatus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class LightweightGUI {
    private static final Logging log = Logging.getLogging(LightweightGUI.class);
    private final JPanel connectedPanel = new JPanel();
    private final JLabel connectedLabel = new JLabel();

    public LightweightGUI(UIContext uiContext) {
        FrameHelper frameHelper = new FrameHelper();
        frameHelper.getFrame().setTitle("rusEFI Lightweight 20240531");
        JPanel topPanel = new JPanel(new FlowLayout(2));
        this.connectedPanel.add(this.connectedLabel);
        topPanel.add(this.connectedPanel);
        topPanel.add(new InternetStatus().getContent());
        JPanel leftPanel = new JPanel(new VerticalFlowLayout());
        leftPanel.add(new JLabel(BundleUtil.readBundleFullName()));
        JLabel firmwareVersion = new JLabel();
        SensorCentral.getInstance().addListener(Sensor.FIRMWARE_VERSION, value -> firmwareVersion.setText(Integer.toString((int)value)));
        leftPanel.add(firmwareVersion);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)topPanel, "North");
        content.add((Component)leftPanel, "West");
        content.add((Component)LightweightGUI.createLogoUrlPanel(), "East");
        frameHelper.showFrame(content, true);
    }

    public static void start() {
        final UIContext uiContext = new UIContext();
        final LightweightGUI gui = new LightweightGUI(uiContext);
        gui.setConnectedUI(false);
        new Thread(() -> LightweightGUI.waitForDeviceAndStart(uiContext.getLinkManager())).start();
        ConnectionStatusLogic.INSTANCE.addListener(new ConnectionStatusLogic.Listener(){

            @Override
            public void onConnectionStatus(final boolean isConnected) {
                uiContext.sensorLogger.init();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        gui.setConnectedUI(isConnected);
                    }
                });
            }
        });
    }

    private static JPanel createLogoUrlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("rusEFI (c) 2012-2024"), "South");
        JLabel logo = LogoHelper.createLogoLabel();
        if (logo != null) {
            panel.add((Component)logo, "Center");
        }
        return panel;
    }

    private void setConnectedUI(boolean isConnected) {
        this.connectedLabel.setText(isConnected ? "Connected" : "NOT CONNECTED");
        this.connectedPanel.setBackground(isConnected ? Color.green : Color.red);
    }

    public static void waitForDeviceAndStart(LinkManager linkManager) {
        String autoDetectedPort = LightweightGUI.detectPortUntilDetected();
        System.out.println("First time port detected: " + autoDetectedPort);
        linkManager.startAndConnect(autoDetectedPort, ConnectionStateListener.VOID);
        ConnectionWatchdog.init(linkManager);
    }

    private static String detectPortUntilDetected() {
        while (true) {
            String port = PortDetector.autoDetectSerial(null).getSerialPort();
            System.out.println("Detected " + port);
            if (port != null) {
                return port;
            }
            IoUtil.sleepSeconds(1);
        }
    }
}

