/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import tel.schich.javacan.BcmCanChannel;
import tel.schich.javacan.IsotpCanChannel;
import tel.schich.javacan.IsotpCanChannelImpl;
import tel.schich.javacan.IsotpSocketAddress;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.RawCanChannel;
import tel.schich.javacan.RawCanChannelImpl;
import tel.schich.javacan.SocketCAN;

public class CanChannels {
    private CanChannels() {
    }

    public static RawCanChannel newRawChannel() throws IOException {
        int fd = SocketCAN.createRawSocket();
        return new RawCanChannelImpl(fd);
    }

    public static RawCanChannel newRawChannel(NetworkDevice device) throws IOException {
        RawCanChannel ch = CanChannels.newRawChannel();
        ch.bind(device);
        return ch;
    }

    public static RawCanChannel newRawChannel(String device) throws IOException {
        return CanChannels.newRawChannel(NetworkDevice.lookup(device));
    }

    public static BcmCanChannel newBcmChannel() throws IOException {
        int fd = SocketCAN.createBcmSocket();
        return new BcmCanChannel(fd);
    }

    public static BcmCanChannel newBcmChannel(NetworkDevice device) throws IOException {
        BcmCanChannel ch = CanChannels.newBcmChannel();
        ch.connect(device);
        return ch;
    }

    public static BcmCanChannel newBcmChannel(String device) throws IOException {
        return CanChannels.newBcmChannel(NetworkDevice.lookup(device));
    }

    public static IsotpCanChannel newIsotpChannel() throws IOException {
        int fd = SocketCAN.createIsotpSocket();
        return new IsotpCanChannelImpl(fd);
    }

    public static IsotpCanChannel newIsotpChannel(NetworkDevice device, IsotpSocketAddress rx, IsotpSocketAddress tx) throws IOException {
        IsotpCanChannel ch = CanChannels.newIsotpChannel();
        ch.bind(device, rx, tx);
        return ch;
    }

    public static IsotpCanChannel newIsotpChannel(String device, IsotpSocketAddress rx, IsotpSocketAddress tx) throws IOException {
        return CanChannels.newIsotpChannel(NetworkDevice.lookup(device), rx, tx);
    }

    public static IsotpCanChannel newIsotpChannel(NetworkDevice device, int rx, int tx) throws IOException {
        return CanChannels.newIsotpChannel(device, IsotpSocketAddress.isotpAddress(rx), IsotpSocketAddress.isotpAddress(tx));
    }

    public static IsotpCanChannel newIsotpChannel(String device, int rx, int tx) throws IOException {
        return CanChannels.newIsotpChannel(NetworkDevice.lookup(device), rx, tx);
    }
}

