/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

public class Histogram {
    private final float MIN_VALUE;
    private final float MINOR_TICKMARK_SPACING;
    private final double[] FREQUENCE;
    private double max;
    private int n;

    public Histogram(double MIN_VALUE, double MAX_VALUE, double MINOR_TICKMARK_SPACING) {
        this.MIN_VALUE = (float)MIN_VALUE;
        this.MINOR_TICKMARK_SPACING = (float)MINOR_TICKMARK_SPACING;
        this.n = (int)((MAX_VALUE - MIN_VALUE) / MINOR_TICKMARK_SPACING);
        this.FREQUENCE = new double[this.n];
    }

    public void addDataPoint(int INDEX) {
        int n = INDEX > this.n - 1 ? this.n - 1 : INDEX;
        this.FREQUENCE[n] = this.FREQUENCE[n] + 1.0;
        this.max = this.FREQUENCE[INDEX] > this.max ? this.FREQUENCE[INDEX] : this.max;
    }

    public void addDataPoint(double VALUE) {
        int index = Math.round((float)VALUE / this.MINOR_TICKMARK_SPACING) - Math.round(this.MIN_VALUE / this.MINOR_TICKMARK_SPACING);
        this.addDataPoint(index);
    }

    public double[] getData() {
        return (double[])this.FREQUENCE.clone();
    }
}

