/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Orientation;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.Random;

public class LinenFilter
implements BufferedImageOp {
    private int radius = 65;
    private float amount = 0.6f;
    private float shine = 0.3f;
    private Orientation orientation = Orientation.HORIZONTAL;
    private int color = -9934744;
    private Random randomNumbers;

    @Override
    public BufferedImage filter(BufferedImage SOURCE, BufferedImage destination) {
        int WIDTH = SOURCE.getWidth();
        int HEIGHT = SOURCE.getHeight();
        if (destination == null) {
            destination = this.createCompatibleDestImage(SOURCE, null);
        }
        int[] IN_PIXELS_HOR = new int[WIDTH];
        int[] OUT_PIXELS_HOR = new int[WIDTH];
        this.randomNumbers = new Random(0L);
        int ALPHA = this.color & 0xFF000000;
        int RED = this.color >> 16 & 0xFF;
        int GREEN = this.color >> 8 & 0xFF;
        int BLUE = this.color & 0xFF;
        switch (this.orientation) {
            case VERTICAL: {
                int[] IN_PIXELS_VER = new int[HEIGHT];
                int[] OUT_PIXELS_VER = new int[HEIGHT];
                this.randomNumbers = new Random(0L);
                for (int x = 0; x < WIDTH; ++x) {
                    for (int y = 0; y < HEIGHT; ++y) {
                        int tr = RED;
                        int tg = GREEN;
                        int tb = BLUE;
                        if (this.shine != 0.0f) {
                            int f = (int)((double)(255.0f * this.shine) * Math.sin((double)x / (double)WIDTH * Math.PI));
                            tr += f;
                            tg += f;
                            tb += f;
                        }
                        int n = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                        IN_PIXELS_VER[y] = ALPHA | LinenFilter.clamp(tr + n) << 16 | LinenFilter.clamp(tg + n) << 8 | LinenFilter.clamp(tb + n);
                    }
                    if (this.radius != 0) {
                        this.blurVertical(IN_PIXELS_VER, OUT_PIXELS_VER, HEIGHT, this.radius);
                        this.setRGB(destination, x, 0, 1, HEIGHT, OUT_PIXELS_VER);
                        continue;
                    }
                    this.setRGB(destination, x, 0, 1, HEIGHT, IN_PIXELS_VER);
                }
                break;
            }
            default: {
                for (int y = 0; y < HEIGHT; ++y) {
                    for (int x = 0; x < WIDTH; ++x) {
                        int tr = RED;
                        int tg = GREEN;
                        int tb = BLUE;
                        if (this.shine != 0.0f) {
                            int f = (int)((double)(255.0f * this.shine) * Math.sin((double)x / (double)WIDTH * Math.PI));
                            tr += f;
                            tg += f;
                            tb += f;
                        }
                        int n = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                        IN_PIXELS_HOR[x] = ALPHA | LinenFilter.clamp(tr + n) << 16 | LinenFilter.clamp(tg + n) << 8 | LinenFilter.clamp(tb + n);
                    }
                    if (this.radius != 0) {
                        this.blurHorizontal(IN_PIXELS_HOR, OUT_PIXELS_HOR, WIDTH, this.radius);
                        this.setRGB(destination, 0, y, WIDTH, 1, OUT_PIXELS_HOR);
                        continue;
                    }
                    this.setRGB(destination, 0, y, WIDTH, 1, IN_PIXELS_HOR);
                }
            }
        }
        return destination;
    }

    private int random(int x) {
        if ((x += (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount)) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        return x;
    }

    private static int clamp(int C) {
        int ret = C < 0 ? 0 : (C > 255 ? 255 : C);
        return ret;
    }

    private static int mod(int a, int B) {
        int N;
        if ((a -= (N = a / B) * B) < 0) {
            return a + B;
        }
        return a;
    }

    public void blurHorizontal(int[] IN, int[] OUT, int WIDTH, int RADIUS) {
        int WIDTH_MINUS_1 = WIDTH - 1;
        int R2 = 2 * RADIUS + 1;
        int tr = 0;
        int tg = 0;
        int tb = 0;
        for (int i = -RADIUS; i <= RADIUS; ++i) {
            int rgb = IN[LinenFilter.mod(i, WIDTH)];
            tr += rgb >> 16 & 0xFF;
            tg += rgb >> 8 & 0xFF;
            tb += rgb & 0xFF;
        }
        for (int x = 0; x < WIDTH; ++x) {
            int i2;
            OUT[x] = 0xFF000000 | tr / R2 << 16 | tg / R2 << 8 | tb / R2;
            int i1 = x + RADIUS + 1;
            if (i1 > WIDTH_MINUS_1) {
                i1 = LinenFilter.mod(i1, WIDTH);
            }
            if ((i2 = x - RADIUS) < 0) {
                i2 = LinenFilter.mod(i2, WIDTH);
            }
            int rgb1 = IN[i1];
            int rgb2 = IN[i2];
            tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
            tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
            tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
        }
    }

    public void blurVertical(int[] IN, int[] OUT, int HEIGHT, int RADIUS) {
        int HEIGHT_MINUS_1 = HEIGHT - 1;
        int R2 = 2 * RADIUS + 1;
        int tr = 0;
        int tg = 0;
        int tb = 0;
        for (int i = -RADIUS; i <= RADIUS; ++i) {
            int rgb = IN[LinenFilter.mod(i, HEIGHT)];
            tr += rgb >> 16 & 0xFF;
            tg += rgb >> 8 & 0xFF;
            tb += rgb & 0xFF;
        }
        for (int y = 0; y < HEIGHT; ++y) {
            int i2;
            OUT[y] = 0xFF000000 | tr / R2 << 16 | tg / R2 << 8 | tb / R2;
            int i1 = y + RADIUS + 1;
            if (i1 > HEIGHT_MINUS_1) {
                i1 = LinenFilter.mod(i1, HEIGHT);
            }
            if ((i2 = y - RADIUS) < 0) {
                i2 = LinenFilter.mod(i2, HEIGHT);
            }
            int rgb1 = IN[i1];
            int rgb2 = IN[i2];
            tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
            tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
            tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
        }
    }

    public void setRadius(int RADIUS) {
        this.radius = RADIUS;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmount(float AMOUNT) {
        this.amount = AMOUNT;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setColor(int COLOR) {
        this.color = COLOR;
    }

    public int getColor() {
        return this.color;
    }

    public void setShine(float SHINE) {
        this.shine = SHINE;
    }

    public float getShine() {
        return this.shine;
    }

    public void setOrientation(Orientation ORIENTATION) {
        this.orientation = ORIENTATION;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage SOURCE, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = SOURCE.getColorModel();
        }
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(SOURCE.getWidth(), SOURCE.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage SOURCE) {
        return new Rectangle(0, 0, SOURCE.getWidth(), SOURCE.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D SOURCE_POINT, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(SOURCE_POINT.getX(), SOURCE_POINT.getY());
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setRGB(BufferedImage IMAGE, int X, int Y, int WIDTH, int HEIGHT, int[] PIXELS) {
        int type = IMAGE.getType();
        if (type == 2 || type == 1) {
            IMAGE.getRaster().setDataElements(X, Y, WIDTH, HEIGHT, PIXELS);
        } else {
            IMAGE.setRGB(X, Y, WIDTH, HEIGHT, PIXELS, 0, WIDTH);
        }
    }

    public String toString() {
        return "Texture/Brushed Metal...";
    }
}

