/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.FileLog;
import com.rusefi.Launcher;
import com.rusefi.autodetect.PortDetector;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.core.FindFileHelper;
import com.rusefi.io.BootloaderHelper;
import com.rusefi.io.IoStream;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.io.serial.BufferedSerialIoStream;
import com.rusefi.maintenance.ExecHelper;
import com.rusefi.maintenance.MaintenanceUtil;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfuFlasher {
    public static final String BOOTLOADER_BIN_FILE = FindFileHelper.INPUT_FILES_PATH + "/openblt.bin";
    private static final String DFU_CMD_TOOL_LOCATION = Launcher.TOOLS_PATH + File.separator + "STM32_Programmer_CLI/bin";
    private static final String DFU_CMD_TOOL = "STM32_Programmer_CLI.exe";
    private static final String WMIC_DFU_QUERY_COMMAND = "wmic path win32_pnpentity where \"Caption like '%STM32%' and Caption like '%Bootloader%'\" get Caption,ConfigManagerErrorCode /format:list";

    public static boolean haveBootloaderBinFile() {
        return new File(BOOTLOADER_BIN_FILE).exists();
    }

    public static void doAutoDfu(JComponent parent, String port, UpdateOperationCallbacks callbacks) {
        if (port == null) {
            JOptionPane.showMessageDialog(parent, "Failed to locate serial ports");
            return;
        }
        AtomicBoolean isSignatureValidated = DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_dfu");
        if (isSignatureValidated == null) {
            return;
        }
        if (isSignatureValidated.get()) {
            if (!FileLog.isWindows()) {
                callbacks.appendLine("Switched to DFU mode!");
                callbacks.appendLine("rusEFI console can only program on Windows");
                return;
            }
            DfuFlasher.submitAction(() -> {
                DfuFlasher.timeForDfuSwitch(callbacks);
                DfuFlasher.executeDFU(callbacks, FindFileHelper.FIRMWARE_BIN_FILE);
            });
        } else {
            callbacks.logLine("Please use manual DFU to change bundle type.");
        }
    }

    private static void submitAction(Runnable r) {
        ExecHelper.submitAction(r, DfuFlasher.class + " thread");
    }

    @Nullable
    public static AtomicBoolean rebootToDfu(JComponent parent, String port, UpdateOperationCallbacks callbacks, String command) {
        AtomicBoolean isSignatureValidated = new AtomicBoolean(true);
        if (!PortDetector.isAutoPort(port)) {
            callbacks.logLine("Using selected " + port + "\n");
            try (IoStream stream = BufferedSerialIoStream.openPort(port);){
                AtomicReference signature = new AtomicReference();
                SerialAutoChecker.checkResponse(stream, callbackContext -> {
                    signature.set(callbackContext.getSignature());
                    return null;
                });
                if (signature.get() == null) {
                    callbacks.appendLine("");
                    callbacks.appendLine("");
                    callbacks.appendLine("");
                    callbacks.appendLine("Make sure TUNERSTUDIO IS DISCONNECTED FROM ECU");
                    callbacks.appendLine("");
                    callbacks.appendLine("");
                    callbacks.appendLine("");
                    callbacks.appendLine("*** ERROR *** rusEFI has not responded on selected " + port + "\nMaybe try automatic serial port detection?");
                    callbacks.error();
                    AtomicBoolean atomicBoolean = null;
                    return atomicBoolean;
                }
                boolean isSignatureValidatedLocal = BootloaderHelper.sendBootloaderRebootCommand(parent, (String)signature.get(), stream, callbacks, command);
                isSignatureValidated.set(isSignatureValidatedLocal);
            }
        } else {
            callbacks.logLine("Auto-detecting port...\n");
            port = PortDetector.autoDetectSerial(callbackContext -> {
                boolean isSignatureValidatedLocal = BootloaderHelper.sendBootloaderRebootCommand(parent, callbackContext.getSignature(), callbackContext.getStream(), callbacks, command);
                isSignatureValidated.set(isSignatureValidatedLocal);
                return null;
            }).getSerialPort();
            if (port == null) {
                callbacks.appendLine("*** ERROR *** rusEFI serial port not detected");
                callbacks.error();
                return null;
            }
            callbacks.appendLine("Detected rusEFI on " + port + "\n");
        }
        return isSignatureValidated;
    }

    public static void runDfuEraseAsync(UpdateOperationCallbacks callbacks) {
        DfuFlasher.submitAction(() -> {
            DfuFlasher.runDfuErase(callbacks);
            Toolkit.getDefaultToolkit().beep();
        });
    }

    private static void runDfuErase(UpdateOperationCallbacks callbacks) {
        try {
            ExecHelper.executeCommand(DFU_CMD_TOOL_LOCATION, DfuFlasher.getDfuEraseCommand(), DFU_CMD_TOOL, callbacks);
        }
        catch (FileNotFoundException e) {
            callbacks.logLine(e.toString());
            callbacks.error();
        }
    }

    public static void runDfuProgramming(UpdateOperationCallbacks callbacks) {
        DfuFlasher.submitAction(() -> DfuFlasher.executeDFU(callbacks, FindFileHelper.FIRMWARE_BIN_FILE));
    }

    public static void runOpenBltInitialProgramming(UpdateOperationCallbacks callbacks) {
        DfuFlasher.submitAction(() -> DfuFlasher.executeDFU(callbacks, BOOTLOADER_BIN_FILE));
    }

    private static void executeDFU(UpdateOperationCallbacks callbacks, String firmwareBinFile) {
        String errorResponse;
        boolean driverIsHappy = DfuFlasher.detectSTM32BootloaderDriverState(callbacks);
        if (!driverIsHappy) {
            callbacks.appendLine("*** DRIVER ERROR? *** Did you have a chance to try 'Install Drivers' button on top of rusEFI console start screen?");
            callbacks.error();
            return;
        }
        StringBuffer stdout = new StringBuffer();
        try {
            errorResponse = ExecHelper.executeCommand(DFU_CMD_TOOL_LOCATION, DfuFlasher.getDfuWriteCommand(firmwareBinFile), DFU_CMD_TOOL, callbacks, stdout);
        }
        catch (FileNotFoundException e) {
            callbacks.logLine("ERROR: " + e);
            callbacks.error();
            return;
        }
        if (stdout.toString().contains("Download verified successfully")) {
            callbacks.logLine("SUCCESS!");
            callbacks.logLine("Please power cycle device to exit DFU mode");
            callbacks.done();
        } else if (stdout.toString().contains("Target device not found")) {
            callbacks.appendLine("ERROR: Device not connected or STM32 Bootloader driver not installed?");
            DfuFlasher.appendWindowsVersion(callbacks);
            callbacks.appendLine("ERROR: Please try installing drivers using 'Install Drivers' button on rusEFI splash screen");
            callbacks.appendLine("ERROR: Alternatively please install drivers using Device Manager pointing at 'drivers/silent_st_drivers/DFU_Driver' folder");
            DfuFlasher.appendDeviceReport(callbacks);
            callbacks.error();
        } else {
            DfuFlasher.appendWindowsVersion(callbacks);
            DfuFlasher.appendDeviceReport(callbacks);
            callbacks.logLine(stdout.length() + " / " + errorResponse.length());
            callbacks.error();
        }
    }

    public static boolean detectSTM32BootloaderDriverState(UpdateOperationCallbacks callbacks) {
        return MaintenanceUtil.detectDevice(callbacks, WMIC_DFU_QUERY_COMMAND, "ConfigManagerErrorCode=0");
    }

    private static void appendWindowsVersion(UpdateOperationCallbacks callbacks) {
        callbacks.logLine("ERROR: does not look like DFU has worked!");
    }

    private static void appendDeviceReport(UpdateOperationCallbacks callbacks) {
        for (String line : DfuFlasher.getDevicesReport()) {
            if (line.contains("STM Device in DFU Mode")) {
                callbacks.logLine(" ******************************************************************");
                callbacks.logLine(" ************* YOU NEED TO REMOVE LEGACY DFU DRIVER ***************");
                callbacks.logLine(" ******************************************************************");
            }
            callbacks.logLine("Devices: " + line);
        }
    }

    private static void timeForDfuSwitch(UpdateOperationCallbacks callbacks) {
        callbacks.logLine("Giving time for USB enumeration...");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getDfuWriteCommand(String fileName) throws FileNotFoundException {
        String quotedAbsolutePath = DfuFlasher.quote(new File(fileName).getAbsolutePath());
        return DFU_CMD_TOOL_LOCATION + "/" + DFU_CMD_TOOL + " -c port=usb1 -w " + quotedAbsolutePath + " 0x08000000 -v -s";
    }

    private static String quote(String absolutePath) {
        return "\"" + absolutePath + "\"";
    }

    private static String getDfuEraseCommand() {
        return DFU_CMD_TOOL_LOCATION + "/" + DFU_CMD_TOOL + " -c port=usb1 -e all";
    }

    @NotNull
    static List<String> getDevicesReport() {
        ArrayList<String> report = new ArrayList<String>();
        try {
            String line;
            Process powerShellProcess = Runtime.getRuntime().exec("powershell \"Get-PnpDevice -PresentOnly\"");
            powerShellProcess.getOutputStream().close();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
            while ((line = stdout.readLine()) != null) {
                String lowerCase = line.toLowerCase();
                if (!lowerCase.contains("stm32") && !lowerCase.contains("dfu") && !lowerCase.contains("rusefi")) continue;
                report.add(line);
            }
            stdout.close();
            return report;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

