/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.EnumSet;
import peak.can.basic.TPCANMessageType;

public class TPCANMsg
implements Cloneable {
    @Deprecated
    public static final byte MSGTYPE_STANDARD = TPCANMessageType.PCAN_MESSAGE_STANDARD.getValue();
    @Deprecated
    public static final byte MSGTYPE_RTR = TPCANMessageType.PCAN_MESSAGE_RTR.getValue();
    @Deprecated
    public static final byte MSGTYPE_EXTENDED = TPCANMessageType.PCAN_MESSAGE_EXTENDED.getValue();
    private int _id;
    private byte _type;
    private byte _length;
    private byte[] _data;

    public TPCANMsg() {
        this._data = new byte[8];
    }

    public TPCANMsg(byte length) {
        this._data = new byte[length];
    }

    public TPCANMsg(int id, byte type, byte length, byte[] data) {
        this._id = id;
        this._type = type;
        this._length = length;
        this._data = new byte[length];
        System.arraycopy(data, 0, this._data, 0, length);
    }

    public TPCANMsg(int id, EnumSet<TPCANMessageType> type, byte length, byte[] data) {
        this._id = id;
        this._type = TPCANMessageType.getValue(type);
        this._length = length;
        this._data = new byte[length];
        System.arraycopy(data, 0, this._data, 0, length);
    }

    public void setID(int id) {
        this._id = id;
    }

    public void setData(byte[] data, byte length) {
        this._length = length;
        System.arraycopy(data, 0, this._data, 0, length);
    }

    public void setLength(byte length) {
        this._length = length;
    }

    public void setType(byte type) {
        this._type = type;
    }

    public void setType(TPCANMessageType type) {
        this._type = type.getValue();
    }

    public void setType(EnumSet<TPCANMessageType> type) {
        this._type = TPCANMessageType.getValue(type);
    }

    public int getID() {
        return this._id;
    }

    public byte[] getData() {
        return this._data;
    }

    public byte getLength() {
        return this._length;
    }

    public byte getType() {
        return this._type;
    }

    public Object clone() {
        TPCANMsg msg = null;
        try {
            msg = (TPCANMsg)super.clone();
            msg._data = (byte[])this._data.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e.getMessage());
        }
        return msg;
    }
}

