/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.util;

import com.devexperts.logging.Logging;
import com.rusefi.util.IoUtils;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.regex.Pattern;

public class LazyFileImpl
implements LazyFile {
    private static final Logging log = Logging.getLogging(LazyFileImpl.class);
    private final String filename;
    private final StringBuffer content = new StringBuffer();
    private final StringBuffer contentWithoutTag = new StringBuffer();

    public LazyFileImpl(String filename) {
        this.filename = filename;
    }

    @Override
    public void write(String line) {
        String[] lines;
        this.content.append(line);
        for (String subLine : lines = line.split("\\r?\\n")) {
            if (subLine.toLowerCase().contains(LazyFile.LAZY_FILE_TAG_LOWER)) continue;
            this.contentWithoutTag.append(subLine);
        }
    }

    public static String unifySpaces(String line) {
        line = line.replace("\r", "");
        return line.replaceAll("\n[\n]*", "");
    }

    @Override
    public void close() throws IOException {
        String newContent;
        if ("test_file_name".equals(this.filename)) {
            return;
        }
        String fileContent = LazyFileImpl.unifySpaces(this.readCurrentContent(this.filename));
        if (fileContent.equals(newContent = LazyFileImpl.unifySpaces(this.contentWithoutTag.toString()))) {
            log.info(this.getClass().getSimpleName() + ": Not updating " + this.filename + " since looks to be the same content, new content size=" + this.contentWithoutTag.length());
            return;
        }
        for (int i = 0; i < Math.min(fileContent.length(), newContent.length()); ++i) {
            if (fileContent.charAt(i) == newContent.charAt(i)) continue;
            log.info(this.getClass().getSimpleName() + " " + this.filename + ": Not same at " + i);
            if (i <= 15 || i >= fileContent.length() - 6 || i >= newContent.length() - 6) break;
            log.info("file       " + fileContent.substring(i - 15, i + 5));
            log.info("newContent " + newContent.substring(i - 15, i + 5));
            break;
        }
        Files.createDirectories(Paths.get(new File(this.filename).getParent(), new String[0]), new FileAttribute[0]);
        PrintWriter fw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), IoUtils.CHARSET));
        ((Writer)fw).write(this.content.toString());
        ((Writer)fw).close();
    }

    private String readCurrentContent(String filename) throws IOException {
        String line;
        if ("test_file_name".equals(filename)) {
            return "";
        }
        if (!new File(filename).exists()) {
            log.info(filename + " does not exist considering empty current content");
            return "";
        }
        Scanner in = new Scanner(Paths.get(filename, new String[0]), IoUtils.CHARSET.name());
        Pattern pat = Pattern.compile(".*\\R|.+\\z");
        StringBuilder sb = new StringBuilder();
        while ((line = in.findWithinHorizon(pat, 0)) != null) {
            if (line.toLowerCase().contains(LazyFile.LAZY_FILE_TAG_LOWER)) continue;
            sb.append(line);
        }
        return sb.toString();
    }
}

