/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.FileLogger;
import com.rusefi.FileLog;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.jetbrains.annotations.Nullable;

public enum AutotestLogging {
    INSTANCE;

    public static String currentLogName;
    @Nullable
    private OutputStream fileLog;
    public static boolean suspendLogging;

    public synchronized void logLine(String fullLine) {
        String withDate = FileLog.getDate() + "<EOT>: " + fullLine;
        System.out.println(withDate);
        if (suspendLogging) {
            return;
        }
        if (this.fileLog == null) {
            return;
        }
        try {
            this.fileLog.write((withDate + "\r\n").getBytes());
            this.fileLog.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private FileOutputStream openLog() throws FileNotFoundException {
        FileLogger.createFolderIfNeeded();
        String shortFileName = this.name() + "_rfi_report_" + FileLogger.date;
        currentLogName = shortFileName + ".csv";
        String fullFileName = "logs/" + currentLogName;
        AutotestLogging.rlog("Writing to " + fullFileName);
        return new FileOutputStream(fullFileName, true);
    }

    public void start() {
        if (this.fileLog != null) {
            return;
        }
        try {
            this.fileLog = this.openLog();
        }
        catch (FileNotFoundException e) {
            return;
        }
    }

    public synchronized void close() {
        if (this.fileLog == null) {
            return;
        }
        try {
            AutotestLogging.rlog("Closing file...");
            this.fileLog.close();
            this.fileLog = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void rlog(String msg) {
        System.out.println("rlog " + msg);
    }

    public void log(Throwable exception) {
        if (this.fileLog == null) {
            throw new NullPointerException("fileLog while " + exception);
        }
        OutputStreamWriter os = new OutputStreamWriter(this.fileLog);
        exception.printStackTrace(new PrintWriter(os));
    }
}

