/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import java.util.ArrayList;

public class ProtocolCommand {
    private final byte[] bytes;

    public ProtocolCommand(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static ProtocolCommand parse(String meta) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int i = 0; i < meta.length(); ++i) {
            char c = meta.charAt(i);
            if (c == '\\') {
                char next = meta.charAt(i + 1);
                if (next != 'x') {
                    throw new IllegalArgumentException("Unexpected symbol: " + next);
                }
                String hex = meta.substring(i + 2, i + 4);
                result.add(Byte.parseByte(hex, 16));
                i += 3;
                continue;
            }
            result.add((byte)c);
        }
        byte[] bytes = new byte[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            bytes[i] = (Byte)result.get(i);
        }
        return new ProtocolCommand(bytes);
    }
}

