/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.rusefi.AvailableHardware;
import com.rusefi.CompatibilityOptional;
import com.rusefi.CompatibilitySet;
import com.rusefi.ConnectivityContext;
import com.rusefi.FileLog;
import com.rusefi.PortResult;
import com.rusefi.SerialPortType;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.DfuAutoJob;
import com.rusefi.maintenance.jobs.DfuManualJob;
import com.rusefi.maintenance.jobs.OpenBltAutoJob;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.maintenance.jobs.PrintUnitLabelJob;
import com.rusefi.maintenance.jobs.UploadTuneJob;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.LogoLabelPopupMenu;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import com.rusefi.ui.basic.UnitLabelPrinter;
import com.rusefi.ui.basic.UpdateCalibrations;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicUpdaterPanel {
    private static final Logging log = Logging.getLogging(BasicUpdaterPanel.class);
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final String panamaUrl = ConnectionAndMeta.getProperties().getProperty("panama_url");
    private final JLabel statusMessage = new JLabel();
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private LogoLabelPopupMenu logoLabelPopupMenu = null;
    private final ConnectivityContext connectivityContext;
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final UpdateOperationCallbacks updateOperationCallbacks;
    private final UpdateCalibrations updateCalibrations;
    private volatile Optional<AsyncJob> updateFirmwareJob = Optional.empty();
    private volatile Optional<PortResult> ecuPortToUse = Optional.empty();

    BasicUpdaterPanel(ConnectivityContext connectivityContext, boolean showUrlLabel, UpdateOperationCallbacks updateOperationCallbacks) {
        this.connectivityContext = connectivityContext;
        this.singleAsyncJobExecutor = new SingleAsyncJobExecutor(updateOperationCallbacks, () -> SwingUtilities.invokeLater(this::refreshButtons));
        this.updateOperationCallbacks = updateOperationCallbacks;
        this.updateCalibrations = new UpdateCalibrations(this.singleAsyncJobExecutor);
        if (FileLog.isWindows()) {
            Optional<JPanel> newReleaseNotification = StartupFrame.newReleaseAnnounce("rusefi_updater.exe", "center", () -> 0);
            if (newReleaseNotification.isPresent()) {
                this.content.add(newReleaseNotification.get());
            }
            this.content.add(ToolButtons.createShowDeviceManagerButton());
            this.content.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            this.updateFirmwareButton.setEnabled(false);
            this.statusMessage.setForeground(Color.red);
            this.content.add(this.statusMessage);
            this.content.add(this.updateFirmwareButton);
        } else {
            this.content.add(new JLabel("Sorry only works on Windows"));
        }
        this.content.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            this.logoLabelPopupMenu = new LogoLabelPopupMenu(this::uploadTune, this::printUnitLabel, this.panamaUrl != null);
            logoLabel.setComponentPopupMenu(this.logoLabelPopupMenu);
            this.content.add(logoLabel);
        }
        if (showUrlLabel) {
            this.content.add(LogoHelper.createUrlLabel());
        }
        this.updateCalibrationsButton.addActionListener(this::onUpdateCalibrationsButtonClicked);
        this.updateCalibrationsButton.setEnabled(false);
        if (ConnectionAndMeta.showUpdateCalibrations()) {
            this.content.add(this.updateCalibrationsButton);
        }
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    public void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
    }

    public void onHardwareUpdated(AvailableHardware currentHardware) {
        this.hideStatusMessage();
        this.updateUpdateFirmwareJob(currentHardware);
        this.updateEcuPortToUse(currentHardware);
    }

    private void updateUpdateFirmwareJob(AvailableHardware currentHardware) {
        log.info("updateUpdateFirmwareJob " + currentHardware);
        if (currentHardware.isDfuFound()) {
            this.setUpdateFirmwareJob(new DfuManualJob());
        } else {
            Set<SerialPortType> portTypesToUpdateFirmware = this.isObfuscated ? CompatibilitySet.of(SerialPortType.EcuWithOpenblt, SerialPortType.OpenBlt) : CompatibilitySet.of(SerialPortType.Ecu, SerialPortType.EcuWithOpenblt);
            List<PortResult> portsToUpdateFirmware = currentHardware.getKnownPorts(portTypesToUpdateFirmware);
            switch (portsToUpdateFirmware.size()) {
                case 0: {
                    this.resetUpdateFirmwareJob("ECU not found");
                    break;
                }
                case 1: {
                    PortResult portToUpdateFirmware = portsToUpdateFirmware.get(0);
                    AsyncJobWithContext job = null;
                    SerialPortType portType = portToUpdateFirmware.type;
                    switch (portType) {
                        case Ecu: {
                            job = new DfuAutoJob(portToUpdateFirmware, this.updateFirmwareButton, this.connectivityContext);
                            break;
                        }
                        case EcuWithOpenblt: {
                            job = new OpenBltAutoJob(portToUpdateFirmware, this.updateFirmwareButton, this.connectivityContext);
                            break;
                        }
                        case OpenBlt: {
                            job = new OpenBltManualJob(portToUpdateFirmware, this.updateFirmwareButton);
                            break;
                        }
                        default: {
                            log.error(String.format("Unexpected port type: %s", new Object[]{portType}));
                        }
                    }
                    this.setUpdateFirmwareJob(job);
                    break;
                }
                default: {
                    this.resetUpdateFirmwareJob(String.format("Multiple ECUs found on: %s", portsToUpdateFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
                }
            }
        }
    }

    private void setUpdateFirmwareJob(AsyncJob updateFirmwareJob) {
        this.updateFirmwareJob = Optional.of(updateFirmwareJob);
        this.hideStatusMessage();
        this.refreshButtons();
        Optional<Object> updateFirmwareButtonText = Optional.empty();
        if (updateFirmwareJob instanceof OpenBltAutoJob) {
            updateFirmwareButtonText = Optional.of("Auto Update Firmware");
        } else if (updateFirmwareJob instanceof OpenBltManualJob) {
            updateFirmwareButtonText = Optional.of("Blt Update Firmware");
        } else if (updateFirmwareJob instanceof DfuAutoJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware");
        } else if (updateFirmwareJob instanceof DfuManualJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware via DFU");
        } else {
            log.error(String.format("Unexpected job type: %s", updateFirmwareJob.getClass().getSimpleName()));
        }
        updateFirmwareButtonText.ifPresent(this.updateFirmwareButton::setText);
    }

    private void resetUpdateFirmwareJob(String reason) {
        this.updateFirmwareJob = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updateEcuPortToUse(AvailableHardware currentHardware) {
        List<PortResult> ecuPortsToUse = currentHardware.getKnownPorts(CompatibilitySet.of(SerialPortType.Ecu, SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUse.size()) {
            case 0: {
                this.resetEcuPortToUse();
                log.info("No ECU ports to use found");
                break;
            }
            case 1: {
                this.setEcuPortToUse(ecuPortsToUse.get(0));
                break;
            }
            default: {
                this.resetEcuPortToUse();
                log.info(String.format("Multiple ECU ports to use found on: %s", ecuPortsToUse.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setEcuPortToUse(PortResult port) {
        this.ecuPortToUse = Optional.of(port);
        SwingUtilities.invokeLater(() -> {
            this.refreshButtons();
            if (port.getFirmwareHash().isPresent()) {
                this.updateOperationCallbacks.logLine("Detected " + port.getFirmwareHash().get());
            }
        });
    }

    private void resetEcuPortToUse() {
        this.ecuPortToUse = Optional.empty();
        SwingUtilities.invokeLater(() -> {
            this.updateCalibrationsButton.setEnabled(false);
            if (this.logoLabelPopupMenu != null) {
                this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(false, false);
            }
        });
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.updateFirmwareJob, value -> this.singleAsyncJobExecutor.startJob((AsyncJob)value, this.updateFirmwareButton), () -> log.error("Update firmware job is is not defined."));
        this.refreshButtons();
    }

    private void onUpdateCalibrationsButtonClicked(ActionEvent actionEvent) {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse, port -> this.updateCalibrations.updateCalibrationsAction((PortResult)port, this.updateCalibrationsButton, this.connectivityContext), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.updateFirmwareButton.setEnabled(this.updateFirmwareJob.isPresent() && this.singleAsyncJobExecutor.isNotInProgress());
        Optional<PortResult> ecuPort = this.ecuPortToUse;
        boolean isEcuPortJobPossible = ecuPort.isPresent() && this.singleAsyncJobExecutor.isNotInProgress();
        this.updateCalibrationsButton.setEnabled(isEcuPortJobPossible);
        if (this.logoLabelPopupMenu != null) {
            this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(isEcuPortJobPossible, ecuPort.map(port -> this.existsAnyOfUnitIdentifierFields(port.calibrations.getIniFile())).orElse(false));
        }
    }

    private boolean existsAnyOfUnitIdentifierFields(IniFileModel iniFile) {
        for (String fieldName : UnitLabelPrinter.UNIT_IDENTIFIER_FIELD_NAMES) {
            if (!iniFile.findIniField(fieldName).isPresent()) continue;
            return true;
        }
        return false;
    }

    private void disableButtons() {
        this.updateFirmwareButton.setEnabled(false);
        this.updateCalibrationsButton.setEnabled(false);
        if (this.logoLabelPopupMenu != null) {
            this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(false, false);
        }
    }

    private void uploadTune() {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse, port -> this.singleAsyncJobExecutor.startJob(new UploadTuneJob(this.connectivityContext, (PortResult)port, this.panamaUrl), this.logoLabelPopupMenu), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    private void printUnitLabel() {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse, port -> this.singleAsyncJobExecutor.startJob(new PrintUnitLabelJob(this.connectivityContext, (PortResult)port, this.logoLabelPopupMenu), this.logoLabelPopupMenu), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    public Component getContent() {
        return this.content;
    }
}

