/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autoupdate;

import com.devexperts.logging.FileLogger;
import com.devexperts.logging.Logging;
import com.rusefi.autoupdate.ConsoleExeFileLocator;
import com.rusefi.autoupdate.ObsoleteFilesArchiver;
import com.rusefi.autoupdate.ReportedIOException;
import com.rusefi.core.FileUtil;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.rusEFIVersion;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.ErrorMessageHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class Autoupdate {
    private static final Logging log = Logging.getLogging(Autoupdate.class);
    private static final int AUTOUPDATE_VERSION = 20250602;
    private static final String TITLE = Autoupdate.getTitle();
    private static final String COM_RUSEFI_LAUNCHER = "com.rusefi.Launcher";
    private static final String consoleJarZipEntry = String.format("console/%s", ConnectionAndMeta.getRusEfiConsoleJarName());
    private static final Predicate<ZipEntry> isConsoleJar = zipEntry -> consoleJarZipEntry.equals(zipEntry.getName());

    private static String getTitle() {
        try {
            return ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties()) + " Bundle Updater " + 20250602;
        }
        catch (Throwable e) {
            log.error("Error", e);
            return "Title error: " + e;
        }
    }

    public static void main(String[] args) {
        try {
            FileLogger.init();
            log.info("Version 20250602");
            log.info("Compiled " + new Date(rusEFIVersion.classBuildTimeMillis(Autoupdate.class)));
            log.info("Current folder " + new File(".").getCanonicalPath());
            log.info("Source " + new File(Autoupdate.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getCanonicalPath());
            Autoupdate.autoupdate(args);
        }
        catch (Throwable e) {
            log.error("Autoupdate Error", e);
            String stackTrace = Autoupdate.extracted(e);
            ErrorMessageHelper.showErrorDialog(stackTrace, "Autoupdate Error " + TITLE);
            System.exit(-1);
        }
    }

    private static String extracted(Throwable e) {
        StringBuilder sb = new StringBuilder(e.toString());
        for (StackTraceElement ste : e.getStackTrace()) {
            sb.append("\n\tat ");
            sb.append(ste);
        }
        return sb.toString();
    }

    private static void autoupdate(String[] args) {
        BundleUtil.BundleInfo bundleInfo = BundleUtil.readBundleFullNameNotNull();
        if (BundleUtil.BundleInfo.isUndefined(bundleInfo)) {
            log.error("ERROR: Autoupdate: unable to perform without bundleFullName");
            System.exit(-1);
        }
        @NotNull String firstArgument = args.length > 0 ? args[0] : "";
        Optional<DownloadedAutoupdateFileInfo> downloadedAutoupdateFile = Autoupdate.downloadFreshZipFile(firstArgument, bundleInfo);
        downloadedAutoupdateFile.ifPresent(downloadedFile -> ObsoleteFilesArchiver.INSTANCE.archiveObsoleteFiles());
        String consoleExeFileName = new ConsoleExeFileLocator().getConsoleExeFileName();
        Autoupdate.safeUnzipMakingSureClassloaderIsHappy(downloadedAutoupdateFile);
        Autoupdate.startConsoleAsANewProcess(consoleExeFileName, args);
    }

    private static Optional<DownloadedAutoupdateFileInfo> downloadFreshZipFile(String firstArgument, BundleUtil.BundleInfo bundleInfo) {
        Optional<DownloadedAutoupdateFileInfo> downloadedAutoupdateFile;
        if (firstArgument.equalsIgnoreCase("release")) {
            log.info("Release update requested");
            downloadedAutoupdateFile = Autoupdate.downloadAutoupdateZipFile(bundleInfo, "https://github.com/rusefi/rusefi/releases/latest/download/");
        } else {
            downloadedAutoupdateFile = Autoupdate.doDownload(bundleInfo);
        }
        return downloadedAutoupdateFile;
    }

    private static void safeUnzipMakingSureClassloaderIsHappy(Optional<DownloadedAutoupdateFileInfo> downloadedAutoupdateFile) {
        downloadedAutoupdateFile.ifPresent(Autoupdate::unzipFreshConsole);
        downloadedAutoupdateFile.ifPresent(autoupdateFile -> {
            block2: {
                try {
                    String pathname = "..";
                    log.info("unzipping everything else into " + pathname);
                    FileUtil.unzip(autoupdateFile.zipFileName, new File(pathname), isConsoleJar.negate());
                    String srecFile = FindFileHelper.findSrecFile();
                    new File(srecFile == null ? FindFileHelper.FIRMWARE_BIN_FILE : srecFile).setLastModified(autoupdateFile.lastModified);
                }
                catch (IOException e) {
                    log.error("Error unzipping autoupdate from bundle: " + e);
                    if (AutoupdateUtil.runHeadless) break block2;
                    ErrorMessageHelper.showErrorDialog("Error unzipping autoupdate from bundle: " + e, "Error");
                }
            }
        });
    }

    private static void unzipFreshConsole(DownloadedAutoupdateFileInfo autoupdateFile) {
        block2: {
            try {
                log.info("unzipFreshConsole " + autoupdateFile.zipFileName + " only " + consoleJarZipEntry);
                FileUtil.unzip(autoupdateFile.zipFileName, new File(".."), isConsoleJar);
            }
            catch (IOException e) {
                log.error("Error unzipping bundle without autoupdate: " + e);
                if (AutoupdateUtil.runHeadless) break block2;
                ErrorMessageHelper.showErrorDialog("Error unzipping bundle without autoupdate: " + e, "Error");
            }
        }
    }

    private static Optional<DownloadedAutoupdateFileInfo> doDownload(BundleUtil.BundleInfo bundleInfo) {
        if (bundleInfo.isMaster()) {
            log.info("Snapshot requested");
            return Autoupdate.downloadAutoupdateZipFile(bundleInfo, ConnectionAndMeta.getBaseUrl() + "/autoupdate/");
        }
        String branchName = Autoupdate.selectBranchName(bundleInfo);
        return Autoupdate.downloadAutoupdateZipFile(bundleInfo, ConnectionAndMeta.getBaseUrl() + "/lts/" + branchName + "/autoupdate/");
    }

    private static String selectBranchName(BundleUtil.BundleInfo bundleInfo) {
        String branchName = bundleInfo.getBranchName();
        String nextBranchName = bundleInfo.getNextBranchName();
        if (nextBranchName != null && !nextBranchName.isBlank() && JOptionPane.showConfirmDialog(null, String.format("A new version `%s` is available!\nWould you like to update from `%s` to `%s` now?", nextBranchName, branchName, nextBranchName), "Release selection", 0) == 0) {
            return nextBranchName;
        }
        return branchName;
    }

    private static URLClassLoader prepareClassLoaderToStartConsole() {
        URLClassLoader jarClassLoader;
        String consoleJarFileName = ConnectionAndMeta.getRusEfiConsoleJarName();
        if (!new File(consoleJarFileName).exists()) {
            throw log.log(new RuntimeException("Looks like corrupted installation: " + consoleJarFileName + " not found"));
        }
        try {
            jarClassLoader = AutoupdateUtil.getClassLoaderByJar(consoleJarFileName);
        }
        catch (MalformedURLException e) {
            log.error("Failed to start", e);
            throw new IllegalStateException("Problem with " + consoleJarFileName, e);
        }
        try {
            Autoupdate.hackProperties(jarClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw log.log(new IllegalStateException("Class not found: " + e, e));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw log.log(new IllegalStateException("Failed to update properties: " + e, e));
        }
        return jarClassLoader;
    }

    private static void startConsoleAsANewProcess(String consoleExeFileName, String[] args) {
        block4: {
            if (!Files.exists(Paths.get(consoleExeFileName, new String[0]), new LinkOption[0])) {
                log.error(String.format("File `%s` to launch isn't found", consoleExeFileName));
                if (!AutoupdateUtil.runHeadless) {
                    ErrorMessageHelper.showErrorDialog(String.format("File `%s` to launch isn't found.", consoleExeFileName), "Error");
                }
                return;
            }
            log.info(String.format("File `%s` to launch is found", consoleExeFileName));
            CharSequence[] processBuilderArgs = new String[args.length + 1];
            processBuilderArgs[0] = consoleExeFileName;
            System.arraycopy(args, 0, processBuilderArgs, 1, args.length);
            try {
                log.info(String.format("We're starting `%s` process", consoleExeFileName));
                new ProcessBuilder((String[])processBuilderArgs).start();
                log.info(String.format("Process `%s` is started", consoleExeFileName));
            }
            catch (IOException e) {
                String command = String.join((CharSequence)" ", processBuilderArgs);
                log.error(String.format("Failed to run `$s` command", command), e);
                if (AutoupdateUtil.runHeadless) break block4;
                ErrorMessageHelper.showErrorDialog(String.format("Error running `%s` command.\nPlease try to run it manually again.", command), "Error");
            }
        }
    }

    private static void hackProperties(URLClassLoader jarClassLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> uiProperties = Class.forName("com.rusefi.UiProperties", true, jarClassLoader);
        for (Method m : uiProperties.getMethods()) {
            System.out.println(m);
        }
        Method setter = uiProperties.getMethod("setProperties", Properties.class);
        setter.invoke(null, ConnectionAndMeta.getProperties());
    }

    private static Optional<DownloadedAutoupdateFileInfo> downloadAutoupdateZipFile(BundleUtil.BundleInfo info, String baseUrl) {
        block4: {
            try {
                String suffix = FindFileHelper.isObfuscated() ? "_obfuscated_public" : "";
                String zipFileName = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties()) + "_bundle_" + info.getTarget() + suffix + "_autoupdate.zip";
                ConnectionAndMeta connectionAndMeta = new ConnectionAndMeta(zipFileName).invoke(baseUrl);
                log.info("Remote file " + zipFileName);
                log.info("Server has " + connectionAndMeta.getCompleteFileSize() + " from " + new Date(connectionAndMeta.getLastModified()));
                if (AutoupdateUtil.hasExistingFile(zipFileName, connectionAndMeta.getCompleteFileSize(), connectionAndMeta.getLastModified())) {
                    log.info("We already have latest update " + new Date(connectionAndMeta.getLastModified()));
                    return Optional.empty();
                }
                long completeFileSize = connectionAndMeta.getCompleteFileSize();
                long lastModified = connectionAndMeta.getLastModified();
                log.info(info + " " + completeFileSize + " bytes, last modified " + new Date(lastModified));
                AutoupdateUtil.downloadAutoupdateFile(zipFileName, connectionAndMeta, TITLE);
                File file = new File(zipFileName);
                file.setLastModified(lastModified);
                log.info("Downloaded " + file.length() + " bytes, lastModified=" + lastModified);
                return Optional.of(new DownloadedAutoupdateFileInfo(zipFileName, lastModified));
            }
            catch (ReportedIOException e) {
                log.error("Error downloading bundle: " + e);
            }
            catch (IOException e) {
                log.error("Error downloading bundle: " + e);
                if (AutoupdateUtil.runHeadless) break block4;
                ErrorMessageHelper.showErrorDialog("Error downloading " + e, "Error");
            }
        }
        return Optional.empty();
    }

    private static class DownloadedAutoupdateFileInfo {
        final String zipFileName;
        final long lastModified;

        DownloadedAutoupdateFileInfo(String zipFileName, long lastModified) {
            this.zipFileName = zipFileName;
            this.lastModified = lastModified;
        }
    }
}

