/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.MandatoryLineMissing;
import com.opensr5.ini.RawIniFile;
import java.util.ArrayList;
import java.util.List;

public class IniFileMetaInfoImpl
implements IniFileMetaInfo {
    public static final int DEFAULT_BLOCKING_FACTOR = 16000;
    private final int nPages;
    private final String signature;
    private final List<String> pageReadCommands;
    private final List<String> crc32CheckCommands;
    private int totalSize;
    private final List<Integer> pageSizes = new ArrayList<Integer>();
    private final int ochBlockSize;
    private final int blockingFactor;

    public IniFileMetaInfoImpl(RawIniFile file) {
        try {
            this.nPages = file.getSimpleIntegerProperty("nPages", 1);
            this.ochBlockSize = file.getSimpleIntegerProperty("ochBlockSize");
            this.blockingFactor = file.getSimpleIntegerProperty("blockingFactor", 16000);
            this.signature = file.getValues("signature").get(0);
            List<String> individualPageSizes = file.getValues("pageSize");
            if (individualPageSizes.size() != this.nPages) {
                throw new IllegalStateException("Unexpected individual sizes: " + individualPageSizes);
            }
            for (String value : individualPageSizes) {
                int size = Integer.parseInt(value);
                this.pageSizes.add(size);
                this.totalSize += size;
            }
            this.pageReadCommands = file.getValues("pageReadCommand");
            this.crc32CheckCommands = file.getValues("crc32CheckCommand");
        }
        catch (MandatoryLineMissing e) {
            throw new RuntimeException("While reading " + file.msg, e);
        }
    }

    @Override
    public int getnPages() {
        return this.nPages;
    }

    @Override
    public int getOchBlockSize() {
        return this.ochBlockSize;
    }

    @Override
    public int getBlockingFactor() {
        return this.blockingFactor;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getPageReadCommand(int pageIndex) {
        return this.pageReadCommands.get(pageIndex);
    }

    @Override
    public String getCrc32CheckCommand(int pageIndex) {
        return this.crc32CheckCommands.get(pageIndex);
    }

    @Override
    public int getPageSize(int pageIndex) {
        return this.pageSizes.get(pageIndex);
    }
}

