/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.opensr5.io.DataListener;
import com.rusefi.NamedThreadFactory;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.BaudRateHolder;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SerialIoStream
extends AbstractIoStream {
    static final Logging log = Logging.getLogging(SerialIoStream.class);
    @Nullable
    protected final SerialPort sp;
    protected final String port;
    private boolean withListener;

    public SerialIoStream(@NotNull SerialPort sp, String port) {
        this.sp = sp;
        this.port = Objects.requireNonNull(port);
    }

    @Nullable
    protected static SerialPort openSerial(String port) {
        SerialPort serialPort = SerialPort.getCommPort(port);
        serialPort.setBaudRate(BaudRateHolder.INSTANCE.baudRate);
        boolean openedOk = serialPort.openPort(0);
        if (!openedOk) {
            log.error("Error opening " + port + " maybe no permissions?");
            return null;
        }
        return serialPort;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        log.info(this.port + ": Closing port...");
        super.close();
        this.sp.closePort();
        log.info(this.port + ": Closed port.");
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.sp == null) {
            throw new IOException("Port was never opened");
        }
        int written = this.sp.writeBytes(bytes, bytes.length);
        if (written != bytes.length) {
            throw new IOException("write failed: wrote " + written + " but expected " + bytes.length);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.port;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void setInputListener(final DataListener listener) {
        if (this.withListener) {
            throw new IllegalStateException("Not possible to change listener");
        }
        this.withListener = true;
        if (this.sp == null) {
            return;
        }
        this.sp.addDataListener(new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                if (event.getEventType() != 1) {
                    return;
                }
                int bytesAvailable = SerialIoStream.this.sp.bytesAvailable();
                if (bytesAvailable <= 0) {
                    return;
                }
                byte[] data = new byte[bytesAvailable];
                int numRead = SerialIoStream.this.sp.readBytes(data, data.length);
                if (numRead != bytesAvailable) {
                    byte[] dataSmaller = new byte[numRead];
                    System.arraycopy(data, 0, dataSmaller, 0, numRead);
                    data = dataSmaller;
                }
                listener.onDataArrived(data);
            }
        });
    }

    static {
        log.info("Using com.fazecast.jSerialComm " + SerialPort.getVersion());
        SerialPortThreadFactory.set(new NamedThreadFactory("ECU SerialIoStream jSerialComm"));
    }
}

