/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.livedata;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.CodeWalkthrough;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.BinaryProtocolState;
import com.rusefi.config.Field;
import com.rusefi.enums.live_data_e;
import com.rusefi.livedata.ParseResult;
import com.rusefi.livedata.generated.CPP14Lexer;
import com.rusefi.livedata.generated.CPP14Parser;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.livedata.Range;
import com.rusefi.ui.livedata.SourceCodePainter;
import com.rusefi.ui.livedata.VariableValueSource;
import com.rusefi.ui.livedocs.LiveDocHolder;
import com.rusefi.ui.livedocs.LiveDocsRegistry;
import com.rusefi.ui.livedocs.RefreshActions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveDataParserPanel {
    private static final Logging log = Logging.getLogging(LiveDataParserPanel.class);
    private final JPanel content = new JPanel(new BorderLayout());
    private ParseResult parseResult = ParseResult.VOID;
    private final UIContext uiContext;
    private final JTextPane text = new JTextPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            BinaryProtocol binaryProtocol = LiveDataParserPanel.this.uiContext.getLinkManager().getConnector().getBinaryProtocol();
            if (binaryProtocol == null) {
                return;
            }
            BinaryProtocolState bps = binaryProtocol.getBinaryProtocolState();
            if (bps == null) {
                return;
            }
            ConfigurationImage ci = bps.getConfigurationImage();
            if (ci == null) {
                return;
            }
            g.setColor(Color.red);
            for (Token setting : LiveDataParserPanel.this.parseResult.getConfigTokens()) {
                Rectangle r;
                Field field = Field.findFieldOrNull(null, "", setting.getText());
                if (field == null || field.getType().isString()) continue;
                Double value = field.getValue(ci);
                try {
                    r = this.getUI().modelToView(LiveDataParserPanel.this.text, setting.getStopIndex());
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException(e);
                }
                if (r == null) {
                    return;
                }
                g.drawString(((Object)value).toString(), r.x, r.y);
            }
        }
    };
    private final VariableValueSource valueSource;
    private final String fileName;
    private String sourceCode;

    public LiveDataParserPanel(UIContext uiContext, VariableValueSource valueSource, String fileName) {
        this.uiContext = uiContext;
        this.valueSource = valueSource;
        this.fileName = fileName;
        JScrollPane rightScrollPane = new JScrollPane(this.text, 20, 30);
        this.content.add(rightScrollPane);
        try {
            this.sourceCode = LiveDataParserPanel.getContent(this.getClass(), fileName);
            this.text.setText(this.sourceCode);
            this.refresh();
        }
        catch (IOException | URISyntaxException e) {
            log.warn("Error reading: " + e);
        }
    }

    public ParseResult getParseResult() {
        return this.parseResult;
    }

    public JTextPane getText() {
        return this.text;
    }

    @NotNull
    public static String getContent(Class<?> clazz, String fileName) throws IOException, URISyntaxException {
        String contentOrNull = LiveDataParserPanel.getContentOrNull(clazz, fileName);
        if (contentOrNull == null) {
            return fileName + " getResourceAsStream not found";
        }
        return contentOrNull;
    }

    @Nullable
    public static String getContentOrNull(Class<?> clazz, String fileName) throws IOException {
        InputStream cpp = clazz.getResourceAsStream("/c_sources/" + fileName);
        if (cpp == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(cpp));){
            String line;
            while ((line = br.readLine()) != null) {
                result.append(line).append("\n");
            }
        }
        return result.toString();
    }

    @NotNull
    public static ParseTree getParseTree(String sourceCode) {
        ANTLRInputStream in;
        try {
            in = new ANTLRInputStream(new ByteArrayInputStream(sourceCode.getBytes()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        CPP14Parser parser = new CPP14Parser(new CommonTokenStream(new CPP14Lexer(in)));
        return parser.translationUnit();
    }

    public JPanel getContent() {
        return this.content;
    }

    public void refresh() {
        ParseTree tree = LiveDataParserPanel.getParseTree(this.sourceCode);
        final StyleContext sc = StyleContext.getDefaultStyleContext();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        final DefaultStyledDocument styledDocument = new DefaultStyledDocument();
        try {
            styledDocument.insertString(0, this.sourceCode, attributes);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        final AttributeSet oldSet = styledDocument.getCharacterElement(0).getAttributes();
        styledDocument.setCharacterAttributes(0, this.sourceCode.length(), sc.getEmptySet(), true);
        try {
            this.parseResult = CodeWalkthrough.applyVariables(this.valueSource, this.sourceCode, new SourceCodePainter(){

                @Override
                public void paintBackground(Color color, Range range) {
                    AttributeSet s = sc.addAttribute(oldSet, StyleConstants.Background, color);
                    styledDocument.setCharacterAttributes(range.getStart(), range.getLength(), s, false);
                }

                @Override
                public void paintForeground(Color color, Range range) {
                    AttributeSet s = sc.addAttribute(oldSet, StyleConstants.Foreground, color);
                    styledDocument.setCharacterAttributes(range.getStart(), range.getLength(), s, false);
                }
            }, tree);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("While " + this.fileName, e);
        }
        this.text.setDocument(styledDocument);
    }

    @NotNull
    public static LiveDataParserPanel createLiveDataParserPanel(UIContext uiContext, live_data_e live_data_e2, Field[] values, String fileName) {
        final AtomicReference reference = new AtomicReference();
        final LiveDataParserPanel livePanel = new LiveDataParserPanel(uiContext, name -> {
            byte[] bytes = (byte[])reference.get();
            if (bytes == null) {
                return null;
            }
            Field f = Field.findFieldOrNull(null, "", name);
            if (f == null) {
                return null;
            }
            double number = f.getValue(new ConfigurationImage(bytes));
            if (log.debugEnabled()) {
                log.debug("getValue(" + name + "): " + number);
            }
            return new VariableValueSource.VariableState(f, number);
        }, fileName);
        RefreshActions refreshAction = new RefreshActions(){

            @Override
            public void refresh(byte[] response) {
                if (log.debugEnabled()) {
                    log.debug("Got data " + response.length + " bytes");
                }
                reference.set(response);
                livePanel.refresh();
            }
        };
        LiveDocsRegistry.INSTANCE.register(new LiveDocHolder(live_data_e2, refreshAction){

            @Override
            public boolean isVisible() {
                JPanel panel = livePanel.getContent();
                boolean isVisible = !panel.getVisibleRect().isEmpty();
                return isVisible && LiveDataParserPanel.isRecursivelyVisible(panel);
            }
        });
        return livePanel;
    }

    private static boolean isRecursivelyVisible(Container c) {
        Container parent = c.getParent();
        return c.isVisible() && (parent == null || LiveDataParserPanel.isRecursivelyVisible(parent));
    }
}

