/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.commands;

import com.devexperts.logging.Logging;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;

public class BurnCommand {
    private static final Logging log = Logging.getLogging(BurnCommand.class);
    private static final byte[] PAGE_0 = new byte[2];

    public static boolean execute(BinaryProtocol bp) {
        byte[] page = bp.isSinglePageController() ? null : PAGE_0;
        byte[] response = bp.executeCommand('B', page, "burn");
        boolean isExpectedBurnResponseCode = IoHelper.checkResponseCode(response, (byte)4);
        if (response == null) {
            log.warn("empty BURN response on " + bp.getStream());
            return false;
        }
        boolean isExpectedBurnResponseLength = response.length == 1;
        return isExpectedBurnResponseCode && isExpectedBurnResponseLength;
    }
}

