/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.CompatibilitySet;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.tune.xml.Msq;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class BinsIniFieldMigratorStrategy {
    private static final int BINS_INI_FIELD_COLS = 1;
    private static final double BINS_INI_FIELD_MULTIPLIER = 1.0;
    private static final String BINS_INI_FIELD_DIGITS = "0";
    private static final FieldType BINS_INI_FIELD_TYPE = FieldType.UINT16;
    private final String iniFieldName;
    private final int prevCount;
    private final int newCount;

    BinsIniFieldMigratorStrategy(String binsIniFieldName, int prevBinsCount, int newBinsCount) {
        this.iniFieldName = binsIniFieldName;
        this.prevCount = prevBinsCount;
        this.newCount = newBinsCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    Optional<String> tryMigrateBins(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<Long> recommendedStep;
        Optional<String> result = Optional.empty();
        Optional<ArrayIniField> prevValidatedBinsIniField = this.getValidatedBinsArrayIniField(prevField, callbacks);
        Optional<ArrayIniField> newValidatedBinsIniField = this.getValidatedBinsArrayIniField(newField, callbacks);
        if (!prevValidatedBinsIniField.isPresent()) return result;
        if (!newValidatedBinsIniField.isPresent()) return result;
        ArrayIniField prevBinsField = prevValidatedBinsIniField.get();
        ArrayIniField newBinsField = newValidatedBinsIniField.get();
        int binsToAddCount = newBinsField.getRows() - prevBinsField.getRows();
        if (0 >= binsToAddCount) return result;
        List<String> prevValues = Arrays.stream(prevBinsField.getValues(prevValue)).map(e -> e[0]).collect(Collectors.toList());
        List<Long> prevLongValues = prevValues.stream().map(Double::parseDouble).map(Math::round).collect(Collectors.toList());
        long lastValue = (Long)prevLongValues.get(prevLongValues.size() - 1);
        String max = newBinsField.getMax();
        if (max != null) {
            long maxPossibleStep = (long)((Double.parseDouble(max) - (double)lastValue) / (double)binsToAddCount);
            if (1L > maxPossibleStep) {
                callbacks.logLine(String.format("WARNING! `%s` ini-field cannot be propagated with increasing values, because max value is %s", this.iniFieldName, max));
                return Optional.empty();
            }
            recommendedStep = Optional.of(BinsIniFieldMigratorStrategy.chooseStep(prevLongValues, maxPossibleStep));
        } else {
            long valueBeforeLast = (Long)prevLongValues.get(prevLongValues.size() - 2);
            recommendedStep = Optional.of(lastValue - valueBeforeLast);
        }
        if (!recommendedStep.isPresent()) return result;
        String[][] newValues = this.expandValues(prevValues, lastValue, recommendedStep);
        return Optional.of(newBinsField.formatValue(newValues));
    }

    private String[] @NotNull [] expandValues(List<String> prevValues, long lastValue, Optional<Long> recommendedStep) {
        String[][] newValues = new String[this.newCount][1];
        for (int i = 0; i < this.prevCount; ++i) {
            newValues[i] = new String[]{prevValues.get(i)};
        }
        long lastBin = lastValue;
        for (int i = this.prevCount; i < this.newCount; ++i) {
            newValues[i] = new String[]{String.format(Msq.TS_INTEGRATION_LOCALE, "%.1f", (double)(lastBin += recommendedStep.get().longValue()))};
        }
        return newValues;
    }

    private Optional<ArrayIniField> getValidatedBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to be `ArrayIniField` instead of %s", this.iniFieldName, field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != BINS_INI_FIELD_TYPE) {
            callbacks.logLine(String.format("WARNING! Type of `%s` ini-field is expected to be `%s` instead of `%s`", new Object[]{this.iniFieldName, BINS_INI_FIELD_TYPE, arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to contain %d columns instead of %d", this.iniFieldName, 1, arrayFieldCols));
            return Optional.empty();
        }
        double arrayFieldMultiplier = arrayField.getMultiplier();
        if (arrayFieldMultiplier != 1.0) {
            callbacks.logLine(String.format("WARNING! Multiplier of `%s` ini-field is expected to be %f instead of %f", this.iniFieldName, 1.0, arrayFieldMultiplier));
            return Optional.empty();
        }
        String arrayFieldDigits = arrayField.getDigits();
        if (!BINS_INI_FIELD_DIGITS.equals(arrayFieldDigits)) {
            callbacks.logLine(String.format("WARNING! Digits of `%s` ini-field is expected to be `%s` instead of `%s`", this.iniFieldName, BINS_INI_FIELD_DIGITS, arrayFieldDigits));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (CompatibilitySet.of(this.prevCount, this.newCount).contains(arrayFieldRows)) {
            return Optional.of(arrayField);
        }
        callbacks.logLine(String.format("WARNING! `%s` ini-field is expected to contain %d or %d rows instead of %d", this.iniFieldName, this.prevCount, this.newCount, arrayFieldRows));
        return Optional.empty();
    }

    private static long chooseStep(List<Long> bins, long maxPossibleStep) {
        Long lastBin = null;
        Long lastStep = null;
        Long maxStep = null;
        for (long bin : bins) {
            if (lastBin != null && (lastStep = Long.valueOf(bin - lastBin)) <= maxPossibleStep && (maxStep == null || maxStep < lastStep)) {
                maxStep = lastStep;
            }
            lastBin = bin;
        }
        if (lastStep != null) {
            if (lastStep <= maxPossibleStep) {
                return lastStep;
            }
            if (maxStep != null) {
                return maxStep;
            }
        }
        return maxPossibleStep;
    }
}

