/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.duplicates;

import com.devexperts.logging.Logging;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class ConsoleBundleUtil {
    private static final Logging log = Logging.getLogging(ConsoleBundleUtil.class);
    private static final String DEVELOPMENT = "development";
    private static final String BRANCH_REF_FILE = "release.txt";

    public static List<@NotNull String> readBundleFullName() {
        File f = new File(BRANCH_REF_FILE);
        if (!f.exists()) {
            log.error("release.txt not found");
            return null;
        }
        try {
            return Files.readAllLines(f.toPath());
        }
        catch (IOException | InvalidPathException e) {
            log.error("Error reading bundle name", e);
            return null;
        }
    }

    @NotNull
    public static BundleInfo readBundleFullNameNotNull() {
        List<@NotNull String> info = ConsoleBundleUtil.readBundleFullName();
        if (info == null) {
            return BundleInfo.UNKNOWN;
        }
        return ConsoleBundleUtil.parse(info);
    }

    public static String getBundleTarget() {
        return ConsoleBundleUtil.readBundleFullNameNotNull().getTarget();
    }

    public static BundleInfo parse(List<@NotNull String> info) {
        TreeMap<String, String> keyValues = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String line : info) {
            String[] pair = line.split("=", 2);
            keyValues.put(pair[0], pair[1]);
        }
        String target = (String)keyValues.get("platform");
        String branchName = (String)keyValues.get("release");
        String nextBranchName = (String)keyValues.get("nextRelease");
        if (target == null || branchName == null) {
            log.info("release.txt says " + keyValues);
            return BundleInfo.UNKNOWN;
        }
        return new BundleInfo(branchName, nextBranchName, target);
    }

    public static class BundleInfo {
        static final BundleInfo UNKNOWN = new BundleInfo("unknown", null, "unknown");
        private final String branchName;
        private final String nextBranchName;
        private final String target;

        public BundleInfo(String branchName, String nextBranchName, String target) {
            this.branchName = Objects.requireNonNull(branchName, "branchName");
            this.nextBranchName = nextBranchName;
            this.target = Objects.requireNonNull(target, "target");
        }

        public static boolean isUndefined(BundleInfo bundleInfo) {
            return bundleInfo == UNKNOWN;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getNextBranchName() {
            return this.nextBranchName;
        }

        public boolean isMaster() {
            return ConsoleBundleUtil.DEVELOPMENT.equals(this.branchName);
        }

        public String getTarget() {
            return this.target;
        }

        public String toString() {
            return "BundleInfo{branchName='" + this.branchName + '\'' + "nextBranchName='" + this.nextBranchName + '\'' + ", target='" + this.target + '\'' + '}';
        }

        public String getUiLabel() {
            return this.target + "." + this.branchName;
        }
    }
}

