/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Locale;
import java.util.Optional;

public enum CrankingIdleMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String CRANKING_IAC_POSITION_CURVE = "cltCrankingCorr";
    public static final String CRANKING_IAC_POSITION_BASE = "crankingIACposition";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevCrankingIdlePosition = context.getPrevIniFile().findIniField(CRANKING_IAC_POSITION_BASE);
        Optional<IniField> updatedCrankingIdlePosition = context.getUpdatedIniFile().findIniField(CRANKING_IAC_POSITION_BASE);
        Optional<IniField> prevCrankingCurve = context.getPrevIniFile().findIniField(CRANKING_IAC_POSITION_CURVE);
        Optional<IniField> updatedCrankingCurve = context.getUpdatedIniFile().findIniField(CRANKING_IAC_POSITION_CURVE);
        if (!prevCrankingIdlePosition.isPresent() || updatedCrankingIdlePosition.isPresent() || !prevCrankingCurve.isPresent() || !updatedCrankingCurve.isPresent()) {
            return;
        }
        Constant prevCrankingCurveData = context.getPrevTune().getConstantsAsMap().get(CRANKING_IAC_POSITION_CURVE);
        Constant updatedCrankingCurveData = context.getUpdatedTune().getConstantsAsMap().get(CRANKING_IAC_POSITION_CURVE);
        Constant prevIacBasePosition = context.getPrevTune().getConstantsAsMap().get(CRANKING_IAC_POSITION_BASE);
        if (prevCrankingCurveData != null && updatedCrankingCurveData != null && prevIacBasePosition != null) {
            ArrayIniField prevTableField = (ArrayIniField)prevCrankingCurve.get();
            ArrayIniField updatedCrankingCurveField = (ArrayIniField)updatedCrankingCurve.get();
            String[][] migratedValues = prevTableField.getValues(prevCrankingCurveData.getValue());
            Double prevCrankingPosition = Double.parseDouble(prevIacBasePosition.getValue());
            for (int row = 0; row < migratedValues.length; ++row) {
                for (int column = 0; column < migratedValues[0].length; ++column) {
                    Double migratedIACPosition = Double.parseDouble(migratedValues[row][column]) * prevCrankingPosition;
                    migratedValues[row][column] = CrankingIdleMigrator.formatArrayValue(migratedIACPosition, prevTableField.getDigits());
                }
            }
            context.addMigration(CRANKING_IAC_POSITION_CURVE, IniFieldMigrationUtils.generateConstant(updatedCrankingCurveField, updatedCrankingCurveField.formatValue(migratedValues)));
        }
    }

    private static String formatArrayValue(double value, String digits) {
        int numDigits = Integer.parseInt(digits);
        return String.format(Locale.US, "%." + numDigits + "f", value);
    }
}

