/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import com.rusefi.core.Pair;
import com.rusefi.core.RusEfiSignature;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class SignatureHelper {
    private static final Logging log = Logging.getLogging(SignatureHelper.class);
    private static final String LOCAL_INI_CACHE_FOLDER = FileUtil.RUSEFI_SETTINGS_FOLDER + "ini_database";
    private static final String PREFIX = "rusEFI ";
    private static final char SLASH = '/';
    private static final String EXTRA_INI_SOURCE = System.getProperty("extra_local_ini_file_name");

    public static Pair<String, String> getUrl(String signature) {
        RusEfiSignature s = SignatureHelper.parse(signature);
        if (s == null) {
            return null;
        }
        String fileName = s.getHash() + ".ini";
        return new Pair<String, String>("https://rusefi.com/online/ini/rusefi/" + s.getBranch() + '/' + s.getYear() + '/' + s.getMonth() + '/' + s.getDay() + '/' + s.getBundleTarget() + '/' + fileName, fileName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String downloadIfNotAvailable(Pair<String, String> p) {
        if (p == null) {
            return null;
        }
        new File(LOCAL_INI_CACHE_FOLDER).mkdirs();
        String localIniFile = LOCAL_INI_CACHE_FOLDER + File.separator + (String)p.second;
        File file = new File(localIniFile);
        if (file.exists() && file.length() > 10000L) {
            log.info("Found cached at " + LOCAL_INI_CACHE_FOLDER);
            return localIniFile;
        }
        if (EXTRA_INI_SOURCE != null) {
            return EXTRA_INI_SOURCE;
        }
        log.info(".ini not found in " + LOCAL_INI_CACHE_FOLDER + "(" + localIniFile + "), trying to download " + (String)p.first);
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL((String)p.first).openConnection();
            int statusCode = httpURLConnection.getResponseCode();
            if (statusCode >= 300) {
                log.info("Unexpected code " + statusCode);
                return null;
            }
            try (BufferedInputStream in = new BufferedInputStream(httpURLConnection.getInputStream());){
                String string;
                try (FileOutputStream fileOutputStream = new FileOutputStream(localIniFile);){
                    int bytesRead;
                    byte[] dataBuffer = new byte[32768];
                    while ((bytesRead = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
                        fileOutputStream.write(dataBuffer, 0, bytesRead);
                    }
                    string = localIniFile;
                }
                return string;
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static RusEfiSignature parse(String signature) {
        if (signature == null || !signature.startsWith(PREFIX)) {
            return null;
        }
        String signatureWithoutPrefix = signature.substring(PREFIX.length()).trim();
        String[] elements = signatureWithoutPrefix.split("\\.");
        if (elements.length != 6) {
            return null;
        }
        String branch = elements[0];
        String year = elements[1];
        String month = elements[2];
        String day = elements[3];
        String bundleTarget = elements[4];
        String hash = elements[5];
        return new RusEfiSignature(branch, year, month, day, bundleTarget, hash);
    }
}

