/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.DialogModel;
import com.opensr5.ini.GaugeCategoryModel;
import com.opensr5.ini.GaugeModel;
import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniMemberNotFound;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class ImmutableIniFileModel
implements IniFileModel {
    private final String signature;
    private final int blockingFactor;
    private final Map<String, List<String>> defines;
    private final Map<String, IniField> allIniFields;
    private final Map<String, IniField> secondaryIniFields;
    private final Map<String, IniField> allOutputChannels;
    private final Map<String, String> protocolMeta;
    private final IniFileMetaInfo metaInfo;
    private final String iniFilePath;
    private final Map<String, String> tooltips;
    private final Map<String, DialogModel.Field> fieldsInUiOrder;
    private final Map<String, String> xBinsByZBins;
    private final Map<String, String> yBinsByZBins;
    private final Map<String, DialogModel> dialogs;
    private final Map<String, GaugeCategoryModel> gaugeCategories;
    private final Map<String, GaugeModel> gauges;

    private static <V> Map<String, V> copyWithCaseInsensitiveKeys(Map<String, V> source) {
        TreeMap<String, V> result = new TreeMap<String, V>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(source);
        return Collections.unmodifiableMap(result);
    }

    public ImmutableIniFileModel(String signature, int blockingFactor, Map<String, List<String>> defines, Map<String, IniField> allIniFields, Map<String, IniField> secondaryIniFields, Map<String, IniField> allOutputChannels, Map<String, String> protocolMeta, IniFileMetaInfo metaInfo, String iniFilePath, Map<String, String> tooltips, Map<String, DialogModel.Field> fieldsInUiOrder, Map<String, String> xBinsByZBins, Map<String, String> yBinsByZBins, Map<String, DialogModel> dialogs, Map<String, GaugeCategoryModel> gaugeCategories, Map<String, GaugeModel> gauges) {
        this.signature = signature;
        this.blockingFactor = blockingFactor;
        this.defines = Collections.unmodifiableMap(new TreeMap<String, List<String>>(defines));
        this.allIniFields = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(allIniFields);
        this.secondaryIniFields = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(secondaryIniFields);
        this.allOutputChannels = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(allOutputChannels);
        this.protocolMeta = Collections.unmodifiableMap(new TreeMap<String, String>(protocolMeta));
        this.metaInfo = metaInfo;
        this.iniFilePath = iniFilePath;
        this.tooltips = Collections.unmodifiableMap(new TreeMap<String, String>(tooltips));
        this.fieldsInUiOrder = Collections.unmodifiableMap(new LinkedHashMap<String, DialogModel.Field>(fieldsInUiOrder));
        this.xBinsByZBins = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(xBinsByZBins);
        this.yBinsByZBins = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(yBinsByZBins);
        this.dialogs = Collections.unmodifiableMap(new TreeMap<String, DialogModel>(dialogs));
        this.gaugeCategories = Collections.unmodifiableMap(new LinkedHashMap<String, GaugeCategoryModel>(gaugeCategories));
        this.gauges = ImmutableIniFileModel.copyWithCaseInsensitiveKeys(gauges);
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public int getBlockingFactor() {
        if (this.blockingFactor == 0) {
            throw new IllegalStateException("blockingFactor not found in " + this.iniFilePath);
        }
        return this.blockingFactor;
    }

    @Override
    public Map<String, List<String>> getDefines() {
        return this.defines;
    }

    @Override
    public Map<String, IniField> getAllIniFields() {
        return this.allIniFields;
    }

    @Override
    public Map<String, IniField> getSecondaryIniFields() {
        return this.secondaryIniFields;
    }

    @Override
    public Optional<IniField> findIniField(String key) {
        return Optional.ofNullable(this.allIniFields.get(key));
    }

    @Override
    public IniField getIniField(Field field) {
        return this.getIniField(field.getName());
    }

    @Override
    public IniField getIniField(String key) {
        IniField result = this.allIniFields.get(key);
        return Objects.requireNonNull(result, () -> key + " field not found");
    }

    @Override
    public IniField getOutputChannel(String key) throws IniMemberNotFound {
        IniField result = this.allOutputChannels.get(key);
        if (result == null) {
            throw new IniMemberNotFound(key + " field not found");
        }
        return result;
    }

    @Override
    public Map<String, String> getProtocolMeta() {
        return this.protocolMeta;
    }

    @Override
    public IniFileMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public String getIniFilePath() {
        return this.iniFilePath;
    }

    @Override
    public Map<String, String> getTooltips() {
        return this.tooltips;
    }

    @Override
    public Map<String, DialogModel.Field> getFieldsInUiOrder() {
        return this.fieldsInUiOrder;
    }

    @Override
    public String getXBin(String tableName) {
        return this.xBinsByZBins.get(tableName);
    }

    @Override
    public Set<String> getTables() {
        return this.xBinsByZBins.keySet();
    }

    @Override
    public String getYBin(String tableName) {
        return this.yBinsByZBins.get(tableName);
    }

    @Override
    public Map<String, DialogModel> getDialogs() {
        return this.dialogs;
    }

    @Override
    public IniField findByOffset(int i) {
        for (IniField field : this.allIniFields.values()) {
            if (i < field.getOffset() || i >= field.getOffset() + field.getSize()) continue;
            return field;
        }
        return null;
    }

    @Override
    public Map<String, GaugeCategoryModel> getGaugeCategories() {
        return this.gaugeCategories;
    }

    @Override
    public Map<String, GaugeModel> getGauges() {
        return this.gauges;
    }

    @Override
    public GaugeModel getGauge(String name) {
        return this.gauges.get(name);
    }
}

