/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniLocator;
import com.rusefi.core.FileUtil;
import com.rusefi.ini.reader.IniFileReader;
import com.rusefi.ini.reader.IniFileReaderUtil;
import com.rusefi.ts.TsHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class PrimeTunerStudioCache {
    private static final String ECU_DEF_FOLDER = TsHelper.TS_ROOT + "TunerStudio" + File.separator + "config" + File.separator + "ecuDef" + File.separator;
    private static final Logging log = Logging.getLogging(PrimeTunerStudioCache.class);

    public static void prime(IniFileModel iniFileModel, String localIniFile) {
        if (!new File(ECU_DEF_FOLDER).isDirectory()) {
            log.warn("Not found " + ECU_DEF_FOLDER);
            return;
        }
        log.info("Trying to prime " + ECU_DEF_FOLDER);
        String ecuDefLocalFileName = iniFileModel.getSignature().replaceAll(" ", "");
        String fullEcuDefFileName = ECU_DEF_FOLDER + ecuDefLocalFileName + ".ini";
        if (new File(fullEcuDefFileName).exists()) {
            log.info(fullEcuDefFileName + " already present");
            return;
        }
        try {
            FileUtil.copyFile(localIniFile, fullEcuDefFileName);
        }
        catch (IOException e) {
            log.error("While trying to prime", e);
        }
        log.info("Done " + fullEcuDefFileName);
    }

    public static void primeWithLocalFile() {
        IniFileModel iniFileModel;
        @Nullable String localIniFile = IniLocator.findIniFile(".");
        if (localIniFile == null && (localIniFile = IniLocator.findIniFile(IniFileReader.INI_FILE_PATH)) == null) {
            log.warn("No .ini");
            return;
        }
        try {
            iniFileModel = IniFileReaderUtil.readIniFile(localIniFile);
        }
        catch (FileNotFoundException e) {
            log.warn("error " + e);
            return;
        }
        PrimeTunerStudioCache.prime(iniFileModel, localIniFile);
    }
}

