/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class EnumGenerator {
    private static final Logging log = Logging.getLogging(EnumGenerator.class);

    public static class Parser {
        public static String TS_TEXT_DEFINE_SUFFIX = "_list";
        private static final ParsedData parsedData = new ParsedData();

        private static JSONObject getRootObjFromJsonFile(FileReader reader) {
            try {
                JSONParser parser = new JSONParser();
                return (JSONObject)parser.parse(reader);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error parsing JSON file", e);
            }
        }

        public Parser(FileReader reader) {
            JSONObject rootObj = Parser.getRootObjFromJsonFile(reader);
            for (Object kObj : rootObj.keySet()) {
                String key = String.valueOf(kObj);
                JSONObject enumDefinitionObj = (JSONObject)rootObj.get(kObj);
                if (!key.equals("enum")) {
                    throw new RuntimeException("Unexpected key '" + key + "' in definition file on top level!");
                }
                EnumDefinition parsedDefinition = new EnumDefinition(enumDefinitionObj);
                log.info("Adding Enum definition: " + parsedDefinition.name + " (" + parsedDefinition.type + "): ");
                Parser.parsedData.enumDefs.add(parsedDefinition);
                Parser.generateDefinitionTsTextRepresentations(parsedDefinition);
                Parser.generateDefinitionCustomTypes(parsedDefinition);
                Parser.generateDefinitionTsEnumValueToIndexMap(parsedDefinition);
            }
        }

        public List<String> getDefinitions(Definitions definition) {
            switch (definition) {
                case TsTextRepresentations: {
                    return Parser.parsedData.tsTextRepresentations;
                }
                case TsEnumValueToIndexMap: {
                    return Parser.parsedData.tsEnumValueToIndexMap;
                }
                case CustomTypes: {
                    return Parser.parsedData.customTypes;
                }
            }
            throw new RuntimeException("Unknown definition: " + (Object)((Object)definition));
        }

        public Map<String, EnumDefinition> getEnumDefinitions() {
            HashMap<String, EnumDefinition> enumDefsMap = new HashMap<String, EnumDefinition>();
            for (EnumDefinition enumDef : Parser.parsedData.enumDefs) {
                enumDefsMap.put(enumDef.name, enumDef);
            }
            return enumDefsMap;
        }

        private static void generateDefinitionTsTextRepresentations(EnumDefinition parsedDefinition) {
            StringBuilder sb = new StringBuilder();
            sb.append(parsedDefinition.name).append("_list").append(":");
            for (EnumDefinition.EnumEntry entry : parsedDefinition.entries) {
                sb.append("\"").append(entry.valueTs).append("\"").append(",");
            }
            sb.setLength(sb.length() - 1);
            Parser.parsedData.tsTextRepresentations.add(sb.toString());
        }

        private static void generateDefinitionTsEnumValueToIndexMap(EnumDefinition parsedDefinition) {
            StringBuilder sb = new StringBuilder();
            for (EnumDefinition.EnumEntry entry : parsedDefinition.entries) {
                String enumValueToIndexDefine = parsedDefinition.name + "_" + entry.valueCpp + " " + entry.index;
                Parser.parsedData.tsEnumValueToIndexMap.add(enumValueToIndexDefine);
                sb.append(enumValueToIndexDefine).append("\n");
            }
        }

        private static void generateDefinitionCustomTypes(EnumDefinition enumDef) {
            String enumValueLengthStr = "";
            int enumValueLength = 0;
            enumValueLengthStr = Objects.equals(enumDef.type, "uint8_t") || Objects.equals(enumDef.type, "uint16_t") || Objects.equals(enumDef.type, "uint32_t") ? enumValueLengthStr + "U" : enumValueLengthStr + "S";
            if (Objects.equals(enumDef.type, "uint8_t") || Objects.equals(enumDef.type, "int8_t") || Objects.equals(enumDef.type, "char")) {
                enumValueLengthStr = enumValueLengthStr + "08";
                enumValueLength = 1;
            }
            if (Objects.equals(enumDef.type, "uint16_t") || Objects.equals(enumDef.type, "int16_t")) {
                enumValueLengthStr = enumValueLengthStr + "16";
                enumValueLength = 2;
            }
            if (Objects.equals(enumDef.type, "uint32_t") || Objects.equals(enumDef.type, "int32_t")) {
                enumValueLengthStr = enumValueLengthStr + "32";
                enumValueLength = 4;
            }
            StringBuilder customType = new StringBuilder();
            int totalElements = enumDef.entries.size();
            int bitsOutOf32ForMaxIndex = 32 - Integer.numberOfLeadingZeros(totalElements);
            customType.append(enumDef.name).append(" ").append(enumValueLength).append(" bits, ").append(enumValueLengthStr).append(", @OFFSET@, [0:").append(bitsOutOf32ForMaxIndex - 1).append("], ").append("@@").append(enumDef.name).append(TS_TEXT_DEFINE_SUFFIX).append("@@");
            Parser.parsedData.customTypes.add(customType.toString());
        }

        private static class ParsedData {
            List<String> tsTextRepresentations = new ArrayList<String>();
            List<String> tsEnumValueToIndexMap = new ArrayList<String>();
            List<String> customTypes = new ArrayList<String>();
            List<EnumDefinition> enumDefs = new ArrayList<EnumDefinition>();

            private ParsedData() {
            }
        }

        public static enum Definitions {
            TsTextRepresentations,
            TsEnumValueToIndexMap,
            CustomTypes;

        }

        public static class EnumDefinition {
            public String name;
            public String type;
            public String comment;
            public List<EnumEntry> entries = new ArrayList<EnumEntry>();
            private static final List<String> supportedEntries = List.of("name", "type", "comment", "entries");
            private static final Set<String> allowedTypes = Set.of("char", "uint8_t", "uint16_t", "uint32_t", "int8_t", "int16_t", "int32_t");

            EnumDefinition(JSONObject value) throws RuntimeException {
                if (value == null) {
                    throw new RuntimeException("Enum obj is null!");
                }
                for (Object key : value.keySet()) {
                    String keyStr = String.valueOf(key);
                    if (supportedEntries.contains(keyStr)) continue;
                    throw new RuntimeException("Enum obj has unsupported key '" + keyStr + "'!");
                }
                this.name = (String)value.get("name");
                this.type = (String)value.get("type");
                this.comment = (String)value.get("comment");
                if (this.name == null || this.name.isEmpty()) {
                    log.error("Enum name is empty!");
                }
                if (this.type == null || this.type.isEmpty()) {
                    log.error("Enum " + this.name + " has no type!");
                } else if (!allowedTypes.contains(this.type)) {
                    throw new RuntimeException("Enum type '" + this.type + "' is not allowed. Allowed types are: " + allowedTypes);
                }
                JSONArray entriesRaw = (JSONArray)value.get("entries");
                if (entriesRaw == null || entriesRaw.isEmpty()) {
                    throw new RuntimeException("Enum " + this.name + " has no entries!");
                }
                for (Object obj : entriesRaw) {
                    try {
                        this.entries.add(new EnumEntry((JSONObject)obj));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error parsing enum (" + this.name + ") entry", e);
                    }
                }
            }

            public static class EnumEntry {
                List<String> supportedEntries = List.of("i", "v", "n", "c");
                public long index;
                public String valueCpp;
                public String valueTs;
                public String comment;

                EnumEntry(JSONObject entryObj) {
                    if (entryObj == null) {
                        throw new RuntimeException("Enum entry is null!");
                    }
                    for (Object key : entryObj.keySet()) {
                        String keyStr = String.valueOf(key);
                        if (this.supportedEntries.contains(keyStr)) continue;
                        throw new RuntimeException("Enum entry has unsupported key '" + keyStr + "'!");
                    }
                    Object indexObj = entryObj.get("i");
                    Object valueCppObj = entryObj.get("v");
                    if (indexObj == null) {
                        throw new RuntimeException("Enum entry has no index!");
                    }
                    if (valueCppObj == null) {
                        throw new RuntimeException("Enum entry has no value!");
                    }
                    this.index = (Long)indexObj;
                    this.valueCpp = (String)valueCppObj;
                    Object valueTsObj = entryObj.get("n");
                    if (valueTsObj == null) {
                        log.debug("Enum entry has no valueTs, value for C++ is used!");
                        this.valueTs = this.valueCpp;
                    } else {
                        this.valueTs = (String)valueTsObj;
                    }
                    this.comment = (String)entryObj.get("c");
                }
            }
        }
    }
}

