/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.CompatibilityOptional;
import com.rusefi.FileLog;
import com.rusefi.PortResult;
import com.rusefi.RecurringStep;
import com.rusefi.ScannerHelper;
import com.rusefi.SerialPortCache;
import com.rusefi.SerialPortType;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.io.serial.BufferedSerialIoStream;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.MaintenanceUtil;
import com.rusefi.maintenance.StLinkFlasher;
import com.rusefi.updater.OpenbltDetectorStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum SerialPortScanner {
    INSTANCE;

    private static final Logging log;
    private static final boolean SHOW_SOCKETCAN;
    private final RecurringStep portsScanner;
    private final Object lock = new Object();
    @NotNull
    private AvailableHardware knownHardware = new AvailableHardware(Collections.emptyList(), false, false, false);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final SerialPortCache portCache = new SerialPortCache();

    private SerialPortScanner() {
        this.portsScanner = new RecurringStep(() -> this.findAllAvailablePorts(false), () -> this.findAllAvailablePorts(true), "Ports Scanner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailableHardware getCurrentHardware() {
        Object object = this.lock;
        synchronized (object) {
            return this.knownHardware;
        }
    }

    public void addListener(Listener listener) {
        boolean shouldStart = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (shouldStart) {
            this.startTimer();
        }
    }

    private static PortResult inspectPort(String serialPort) {
        log.info("Determining type of serial port: " + serialPort);
        boolean isOpenblt = SerialPortScanner.isPortOpenblt(serialPort);
        log.info("Port " + serialPort + (isOpenblt ? " looks like" : " does not look like") + " an OpenBLT bootloader");
        if (isOpenblt) {
            return new PortResult(serialPort, SerialPortType.OpenBlt);
        }
        Optional<CalibrationsInfo> ecuCalibrations = SerialPortScanner.getEcuCalibrations(serialPort);
        boolean isEcu = ecuCalibrations.isPresent();
        log.info("Port " + serialPort + (isEcu ? " looks like" : " does not look like") + " an ECU");
        if (isEcu) {
            boolean ecuHasOpenblt = SerialPortScanner.ecuHasOpenblt(serialPort);
            log.info("ECU at " + serialPort + (ecuHasOpenblt ? " has" : " does not have") + " an OpenBLT bootloader");
            return new PortResult(serialPort, ecuHasOpenblt ? SerialPortType.EcuWithOpenblt : SerialPortType.Ecu, ecuCalibrations.get());
        }
        return new PortResult(serialPort, SerialPortType.Unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PortResult> inspectPorts(List<String> ports) {
        if (ports.isEmpty()) {
            return new ArrayList<PortResult>();
        }
        Iterator<String> resultsLock = new Iterator<String>();
        HashMap<String, PortResult> results = new HashMap<String, PortResult>();
        Thread callingThread = Thread.currentThread();
        List<Thread> threads = ports.stream().map(p -> {
            String threadName = "SerialPortScanner inspectPort " + p;
            Thread t = new Thread(() -> {
                log.trace(String.format("Thread `%s` is starting...", threadName));
                PortResult r = SerialPortScanner.inspectPort(p);
                Object object = resultsLock;
                synchronized (object) {
                    if (Thread.currentThread().isInterrupted()) {
                        log.trace(String.format("Thread `%s` is interrupted.", threadName));
                        return;
                    }
                    results.put((String)p, r);
                    if (results.size() == ports.size()) {
                        callingThread.interrupt();
                    }
                }
                log.trace(String.format("Thread `%s` has finished.", threadName));
            });
            t.setName(threadName);
            t.setDaemon(true);
            t.start();
            return t;
        }).collect(Collectors.toList());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Iterator<String> iterator = resultsLock;
        synchronized (iterator) {
            ScannerHelper.interruptThreads(threads);
        }
        for (String port : ports) {
            if (results.containsKey(port)) continue;
            log.info("Port " + port + " timed out, adding as Unknown.");
            results.put(port, new PortResult(port, SerialPortType.Unknown));
        }
        return new ArrayList<PortResult>(results.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllAvailablePorts(boolean includeSlowLookup) {
        boolean isListUpdated;
        boolean PCANConnected;
        boolean stLinkConnected;
        boolean dfuConnected;
        ArrayList<PortResult> ports = new ArrayList<PortResult>();
        Set<String> serialPorts = LinkManager.getCommPorts();
        log.info("getCommPorts: " + serialPorts);
        ArrayList<String> portsToInspect = new ArrayList<String>();
        for (String serialPort : serialPorts) {
            Optional<PortResult> cachedPort = this.portCache.get(serialPort);
            CompatibilityOptional.ifPresentOrElse(cachedPort, ports::add, () -> portsToInspect.add(serialPort));
        }
        for (PortResult p : SerialPortScanner.inspectPorts(portsToInspect)) {
            log.info("Port " + p.port + " detected as: " + p.type.friendlyString);
            ports.add(p);
            this.portCache.put(p);
        }
        this.portCache.retainAll(serialPorts);
        ports.sort(Comparator.comparingInt(a -> a.type.sortOrder));
        if (includeSlowLookup) {
            for (String tcpPort : TcpConnector.getAvailablePorts()) {
                ports.add(new PortResult(tcpPort, SerialPortType.Ecu));
            }
            dfuConnected = DfuFlasher.detectSTM32BootloaderDriverState(UpdateOperationCallbacks.DUMMY);
            stLinkConnected = StLinkFlasher.detectStLink(UpdateOperationCallbacks.DUMMY);
            PCANConnected = MaintenanceUtil.detectPcan(UpdateOperationCallbacks.DUMMY);
        } else {
            dfuConnected = false;
            stLinkConnected = false;
            PCANConnected = false;
        }
        if (PCANConnected) {
            ports.add(new PortResult("PCAN", SerialPortType.CAN));
        }
        if (SHOW_SOCKETCAN) {
            ports.add(new PortResult("SocketCAN", SerialPortType.CAN));
        }
        AvailableHardware currentHardware = new AvailableHardware(ports, dfuConnected, stLinkConnected, PCANConnected);
        Iterator<Listener> iterator = this.lock;
        synchronized (iterator) {
            isListUpdated = !this.knownHardware.equals(currentHardware);
            this.knownHardware = currentHardware;
        }
        if (isListUpdated) {
            for (Listener listener : this.listeners) {
                listener.onChange(currentHardware);
            }
        }
    }

    private void startTimer() {
        this.portsScanner.start();
    }

    public void stopTimer() {
        this.portsScanner.stop();
    }

    private static Optional<CalibrationsInfo> getEcuCalibrations(String port) {
        log.info("getEcuCalibrations " + port);
        return CalibrationsHelper.readCurrentCalibrationsWithoutSuspendingPortScanner(port, UpdateOperationCallbacks.LOGGER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ecuHasOpenblt(String port) {
        try (IoStream stream = BufferedSerialIoStream.openPort(port);){
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = OpenbltDetectorStrategy.streamHasOpenBlt(stream);
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPortOpenblt(String port) {
        IoStream stream = BufferedSerialIoStream.openPort(port);
        try {
            boolean bl = OpenbltDetectorStrategy.isPortOpenblt(stream);
            if (stream != null) {
                stream.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public void resume() {
        this.portsScanner.resume();
    }

    public CountDownLatch suspend() {
        return this.portsScanner.suspend();
    }

    static {
        log = Logging.getLogging(SerialPortScanner.class);
        SHOW_SOCKETCAN = FileLog.isLinux();
    }

    public static interface Listener {
        public void onChange(AvailableHardware var1);
    }
}

