/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AutotestLogging;
import com.rusefi.IoUtil;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.TestingUtils;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.ini.reader.IniFileReaderUtil;
import com.rusefi.io.LinkManager;
import com.rusefi.simulator.SimulatorFunctionalTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SimulatorFunctionalTestLauncher {
    static volatile boolean isHappy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            System.exit(66);
        });
        if (args.length == 0) {
            throw new IllegalArgumentException("Required argument: .ini filename");
        }
        String iniFileName = args[0];
        BinaryProtocol.iniFileProvider = signature -> {
            try {
                return IniFileReaderUtil.readIniFile(iniFileName);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        boolean startSimulator = args.length > 1 && args[1].equalsIgnoreCase("start");
        long start = System.currentTimeMillis();
        AutotestLogging.INSTANCE.start();
        boolean failed = false;
        try {
            LinkManager linkManager = new LinkManager();
            IoUtil.connectToSimulator(linkManager, startSimulator);
            TestingUtils.installVoidEngineSnifferAction(linkManager.getCommandQueue());
            new SimulatorFunctionalTest(linkManager).mainTestBody();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            failed = true;
        }
        finally {
            SimulatorExecHelper.destroy();
        }
        if (failed) {
            System.exit(-1);
        }
        isHappy = true;
        AutotestLogging.INSTANCE.logLine("*******************************************************************************");
        AutotestLogging.INSTANCE.logLine("**** SimulatorFunctionalTestLauncher  Looks good! *****************************");
        AutotestLogging.INSTANCE.logLine("*******************************************************************************");
        long time = (System.currentTimeMillis() - start) / 1000L;
        AutotestLogging.INSTANCE.logLine("Done in " + time + "secs");
        System.exit(0);
    }

    private static void buildSimulator() throws IOException, InterruptedException {
        Process makeProcess = Runtime.getRuntime().exec("make -j8", null, new File("../simulator"));
        SimulatorExecHelper.dumpProcessOutput(makeProcess, null);
        makeProcess.waitFor();
    }
}

