/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.AutotestLogging;
import com.rusefi.IoUtil;
import com.rusefi.core.EngineState;
import com.rusefi.functional_tests.EcuTestHelper;
import com.rusefi.io.CommandQueue;
import com.rusefi.waves.EngineChart;
import com.rusefi.waves.EngineChartParser;
import com.rusefi.waves.EngineReport;
import com.rusefi.waves.RevolutionLog;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;

public class TestingUtils {
    private static final Logging log = Logging.getLogging(TestingUtils.class);
    public static boolean isRealHardware;

    static void assertTrue(String msg, boolean b) {
        if (!b) {
            Assert.fail("Not true: " + msg);
        }
    }

    static void assertCloseEnough(String msg, double current, double ratio, double ... expectations) {
        for (double expected : expectations) {
            if (!EngineReport.isCloseEnough(TestingUtils.fixAngle(expected), current, ratio)) continue;
            return;
        }
        if (expectations.length == 1) {
            Assert.fail(msg + ": Got " + current + " while expecting " + Arrays.toString(expectations) + " ratio=" + Math.abs(1.0 - expectations[0] / current) + TestingUtils.printRange(current, ratio));
        }
        Assert.fail(msg + ": Got " + current + " while expecting " + Arrays.toString(expectations) + TestingUtils.printRange(current, ratio));
    }

    private static String printRange(double current, double ratio) {
        return " expected range from " + current / (1.0 + ratio) + " to " + current / (1.0 - ratio) + " with ratio " + ratio;
    }

    private static double fixAngle(double angle) {
        while (angle >= 720.0) {
            angle -= 720.0;
        }
        return angle;
    }

    static void assertTrue(boolean b) {
        if (!b) {
            Assert.fail("Not true");
        }
    }

    static void assertWave(EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave("", chart, key, width, expectedAngles);
    }

    static void assertWave(String msg, EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave(true, msg, chart, key, width, 0.05, 0.05, expectedAngles);
    }

    static void assertWaveFall(EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWaveFall("", chart, key, width, expectedAngles);
    }

    static void assertWaveFall(String msg, EngineChart chart, String key, double width, double ... expectedAngles) {
        TestingUtils.assertWave(false, msg, chart, key, width, 0.05, 0.05, expectedAngles);
    }

    static void assertWave(boolean rise, String msg, EngineChart chart, String key, double expectedWidth, double angleRatio, double widthRatio, double ... expectedAngles) {
        if (isRealHardware) {
            return;
        }
        RevolutionLog revolutionLog = chart.getRevolutionsLog();
        if (revolutionLog.getSize() < 2) {
            throw new IllegalStateException(msg + " Not many revolutions in " + chart);
        }
        StringBuilder events = chart.get(key);
        TestingUtils.assertTrue(msg + " Events not null for " + key, events != null);
        List<EngineReport.UpDown> wr = EngineReport.parse(events.toString());
        TestingUtils.assertTrue(msg + " waves for " + key, !wr.isEmpty());
        for (EngineReport.UpDown ud : wr) {
            int eventTime = rise ? ud.upTime : ud.downTime;
            double angleByTime = revolutionLog.getCrankAngleByTime(eventTime);
            TestingUtils.assertCloseEnough(msg + " angle for " + key + "@" + eventTime, TestingUtils.fixAngle(angleByTime), angleRatio, expectedAngles);
            double actualWidth = ud.getDutyCycle(revolutionLog);
            if (!EngineReport.isCloseEnough(TestingUtils.fixAngle(actualWidth), expectedWidth, widthRatio)) {
                System.out.println("f " + revolutionLog.getCrankAngleByTime(ud.downTime));
                System.out.println("t " + revolutionLog.getCrankAngleByTime(ud.upTime));
            }
            TestingUtils.assertCloseEnough(msg + " width for " + key, actualWidth, widthRatio, expectedWidth);
        }
    }

    public static void assertNull(String msg, Object value) {
        TestingUtils.assertTrue(msg, value == null);
    }

    public static EngineChart nextChart(CommandQueue commandQueue) {
        long start = System.currentTimeMillis();
        EngineChart chart = EngineChartParser.unpackToMap(TestingUtils.getNextWaveChart(commandQueue));
        AutotestLogging.INSTANCE.logLine("AUTOTEST nextChart() in " + (System.currentTimeMillis() - start));
        return chart;
    }

    static String getNextWaveChart(CommandQueue commandQueue) {
        IoUtil.sendBlockingCommand("reset_engine_chart", commandQueue);
        String result = TestingUtils.getEngineChart(commandQueue);
        AutotestLogging.INSTANCE.logLine("current chart: " + result);
        return result;
    }

    private static String getEngineChart(CommandQueue commandQueue) {
        final CountDownLatch engineChartLatch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        AutotestLogging.INSTANCE.logLine("waiting for next chart");
        commandQueue.getLinkManager().getEngineState().replaceStringValueAction("wave_chart", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                engineChartLatch.countDown();
                result.set(value);
            }
        });
        int timeoutMs = 60000;
        long waitStartTime = System.currentTimeMillis();
        IoUtil.wait(engineChartLatch, timeoutMs);
        log.info("got next chart in " + (System.currentTimeMillis() - waitStartTime) + "ms for engine_type " + EcuTestHelper.currentEngineType);
        TestingUtils.installVoidEngineSnifferAction(commandQueue);
        if (result.get() == null) {
            throw new IllegalStateException("Chart timeout: " + timeoutMs);
        }
        return (String)result.get();
    }

    public static void installVoidEngineSnifferAction(CommandQueue commandQueue) {
        commandQueue.getLinkManager().getEngineState().replaceStringValueAction("wave_chart", EngineState.ValueCallback.VOID);
    }
}

