/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.VariableRegistry;
import java.net.URISyntaxException;

public class ToolUtil {
    private static final Logging log = Logging.getLogging(ToolUtil.class);
    public static final String EOL = "\n";
    public static String TOOL = "(unknown script)";

    static String getJarFileName() {
        try {
            String jarPath = VariableRegistry.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (log.debugEnabled()) {
                log.debug("JAR Path : " + jarPath);
            }
            return jarPath.substring(jarPath.lastIndexOf("/") + 1);
        }
        catch (URISyntaxException e) {
            return "(unknown jar)";
        }
    }

    public static String getGeneratedAutomaticallyTag() {
        return "was generated automatically by rusEFI tool " + ToolUtil.getJarFileName() + " based on " + TOOL + " ";
    }

    static boolean isEmptyDefinitionLine(String line) {
        return line.length() == 0 || line.startsWith("!") || line.startsWith("//");
    }

    public static boolean startsWithToken(String line, String token) {
        return line.startsWith(token + " ") || line.startsWith(token + "\t");
    }

    static String trimLine(String line) {
        line = line.trim();
        line = line.replaceAll("\\s+", " ");
        return line;
    }
}

